; ****************************************************************************
;
; INIT06.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 29/07/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	mov si, offset copyright
	call print_msg

openfile:
	mov bx, offset ttyfilename
	mov cx, 0	; open for read
	mov ax, 5	; sysopen
	int 20h
        jc error
        mov word ptr [ttyr], ax

	mov bx, offset ttyfilename
	mov cx, 1	; open for write
	mov ax, 5	; sysopen
	int 20h
        jc error
        mov word ptr [ttyw], ax

wtty1:
        mov bx, word ptr [ttyw] ; file descriptor/number
	mov cx, offset msg_type_enter ; buffer
	mov dx, sizeof_msg_te	    ; byte count
	mov ax, 4		    ; syswrite
	int 20h	
        jc error

	or ax, ax
        jz error 

rtty1:
   	mov bx, word ptr [ttyr] ; file descriptor/number
	mov cx, offset typedchar    ; buffer
	mov dx, 1		    ; byte count
	mov ax, 3		    ; sysread
	int 20h	
        jc error

	or ax, ax
        jz error                   

	mov al, byte ptr [typedchar]
	
	cmp al, 1Bh
	je short singleuser	
	
	cmp al, 0Dh
	jne short rtty1

multiuser:
	mov bx, word ptr [ttyw] ; file descriptor/number
	mov cx, offset prompt   ; buffer
	mov dx, sizeofprompt	; byte count
	mov ax, 4		; syswrite
	int 20h	
        jc error

	or ax, ax
        jz error 
rtty2:
	mov bx, word ptr [ttyr] ; file descriptor/number
	mov cx, offset typedchar    ; buffer
	mov dx, 1		    ; byte count
	mov ax, 3		    ; sysread
	int 20h	
	jc short error

	or ax, ax
	jz short error				

	mov al, byte ptr [typedchar]
	
	cmp al, 1Bh
	je short closefiles	
	
	cmp al, 20h
	jnb short wtty2

	mov byte ptr [typedchar], 7

	cmp al, 0Dh
	je short wtty3
wtty2:
	mov bx, word ptr [ttyw] ; file descriptor/number
	mov cx, offset typedchar    ; buffer
	mov dx, 1		    ; byte count
	mov ax, 4		    ; syswrite
	int 20h	
	jc short error

	or ax, ax
	jz short error	
				
	jmp short rtty2
wtty3:
	mov si, offset nextline
	call print_msg
	jmp short closefiles

singleuser:
	mov bx, offset shell_file
	mov cx, offset shell_argp
	
        mov ax,  11 ; 'sys exec'
	int 20h
	
closefiles:
        mov bx, word ptr [ttyr]
	mov ax, 6 ; sysclose
	int 20h

 	;mov si, offset msg_ok
	;call print_msg

  	mov bx, word ptr [ttyw] ; file descriptor/number
        mov cx, offset msg_ok       ; buffer
        mov dx, msg_ok_size         ; byte count
	mov ax, 4		    ; syswrite
	int 20h		

       	mov bx, word ptr [ttyw]
	mov ax, 6 ; sysclose
	int 20h

	xor ah, ah
	int 16h

	mov si, offset nextline
	call print_msg

	iret
@@:
	mov ax, 1 ; 'sysexit'
	int 20h   ; UNIX system call 
		      ;	(Terminate process for DOS!)
here:	
	hlt
	jmp short here

error:
	mov si, offset msg_err
	call print_msg
        jmp short @b
 
print_msg:
	mov     AH,0Eh                  
        mov     BX,07h  
@@:
        lodsb                           ; Load byte at DS:SI to AL
        and     AL,AL            
        jz      short @f      
            
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short @b         
@@:
        retn

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

copyRight:
		db 0Dh, 0Ah
		db 'Retro UNIX 8086 v1 <sysexec> test (for /etc/init) !'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
                db  '(c) Erdogan TAN - 29/07/2013'
		db  0Dh, 0Ah, 0	
msg_err:
		db 0Dh, 0Ah 
                db 'Error ! '
nextline:
		db 0Dh, 0Ah, 0
msg_type_enter:
		db 0Dh, 0Ah
                db 'Type ENTER to start in multi user mode', 0Dh, 0Ah
                db 'or type ESC to start in single user mode.'
		db 0Dh, 0Ah
sizeof_msg_te  equ $ - msg_type_enter 
		db 0

ttyfilename:    db '/dev/tty0', 0

ttyr:
		dw 0 
ttyw:	
		dw 0
prompt:
		db 0Dh, 0Ah
		db 'Retro Unix 8086 v1', 0Dh, 0Ah
		db 'login: '
sizeofprompt equ $ - offset prompt

typedchar:	
		db 0
shell_argp:
	dw 	offset shell_file, 0
shell_file:
	db 	'/bin/sh', 0

msg_ok:	
		db 0Dh, 0Ah
		db 'OK. '
		db 0Dh, 0Ah
msg_ok_size equ $ - offset msg_ok 
		db 0

UNIX     	ends

                end     START_CODE
