;
; MASM modification by Erdogan Tan (08/12/2013)
;
; PIANO3.ASM  [ For true DOS ]
; One-Octave 'Piano' Program
; Free from Annie (2006)
;
;   Use keyboard number keys 1 through 8 to play the notes.
;   Space bar toggles the 'sustain' function.  ESC exits.
;
;     This code assembles, as-is, with the A86 assembler.
;
;        To assemble: A86 PIANO3.ASM
;
code   	SEGMENT PUBLIC 'CODE'
        assume cs:code,ds:code,es:code,ss:code

        org     100h            ;DOS .COM file
start_code:
        jmp     start           ;go start the program
;
tog     db      0               ;our 'sustain' flag
;
start:
        mov     dx,offset msg   ;point DX to sign-on message
        call    prt_str         ;print it
;
; Get user keypress.
;
get_key:
        mov     ah,0            ;function 0 - wait for keypress
        int     16h             ;call ROM BIOS keyboard services
        cmp     al,27           ;was ESC pressed?
        jz      quit            ;yes, so go exit
        cmp     al,32           ;was SPACE pressed?
        jz      toggle          ;yes, so go toggle 'sustain' mode
;
; Filter out all keys except '1' through '8' by checking the scan code.
;
        cmp     ah,02h          ;less than '1'?
        jl      get_key         ;yes, so ignore it
        cmp     ah,09h          ;greater than '8'?
        jg      get_key         ;yes, so ignore it
;
; Set up the tone parameters.
;
        sub     al,21h          ;change scan code to to digit (0-9)
        and     al,00000111b    ;mask off upper 5 bits
        shl     al,1            ;* by 2 (2 bytes/word)
        cbw                     ;byte --> word in AX
        mov     bx,ax           ;put in BX (for table)
        mov     ax,0            ;numerator (low word)
        mov     dx,12h          ;(high word)
        div     word ptr [table] + bx  ;divisor from table
        mov     bx,ax           ;save quotient in BX
;
; Set 1/pitch into timer, then turn on tone.
;
        mov     al,10110110b    ;the magic number...
        mov     dx,43h          ;
        out     dx,al           ;
        mov     ax,bx           ;1/pitch into AX
        mov     dx,42h          ;
        out     dx,al           ;
        mov     al,ah           ;MSB to AL, then...
        out     dx,al           ;
        mov     dx,61h          ;
        in      al,dx           ;
        or      al,3            ;turn on bits 0 and 1...
        out     dx,al           ;
        call    clr_buf         ;yes, so go clear keyboard buffer
        cmp     tog,1           ;is 'sustain' on?
        je      get_key         ;go get another keypress
;
; Delay for 2/18ths of a second.
;
delay:
        mov     ah,00h          ;function 0 - get system timer tick
        int     01Ah            ;call ROM BIOS time-of-day services
        add     dx,2            ;add our delay value to DX
        mov     bx,dx           ;store result in BX
pozz:
        int     01Ah            ;call ROM BIOS time-of-day services
        cmp     dx,bx           ;has the delay duration passed?
        jl      pozz            ;no, so go check again
        call    stopnote        ;go turn off the note
        jmp     get_key         ;go get another keypress
;
quit:
        jmp     exit            ;'lilypad' to exit
;
; Toggle 'sustain' mode.
;
toggle:
        cmp     tog,0           ;'sustain' mode currently off?
        je      turn_on         ;yes, so go turn it on
        mov     tog,0           ;no, so set 'sustain' flag to 'off'
        call    stopnote        ;turn off note
        call    clr_buf         ;go clear keyboard buffer
        mov     dx,offset off   ;point DX to appropriate screen msg
        call    prt_str         ;print it
        jmp     get_key         ;go get another keypress
turn_on:
        mov     tog,1           ;set 'sustain' flag to 'on'
        call    clr_buf         ;go clear keyboard buffer
        mov     dx,offset onn   ;point DX to appropriate screen msg
        call    prt_str         ;print it
        jmp     get_key         ;go get another keypress
;
; Clear the keyboard buffer.
;
clr_buf:
        push    es              ;preserve ES
        push    di              ;preserve DI
        mov     ax,40h          ;BIOS segment in AX
        mov     es,ax           ;transfer to ES
        mov     ax,1Ah          ;keyboard head pointer in AX
        mov     di,ax           ;transfer to DI
        mov     ax,1Eh          ;keyboard buffer start in AX
        mov     es: word ptr [di],ax   ;transfer to head pointer
        inc     di              ;bump pointer to...
        inc     di              ;...keyboard tail pointer
        mov     es: word ptr [di],ax   ;transfer to tail pointer
        pop     di              ;restore DI
        pop     es              ;restore ES
        ret
;
; Turn off speaker.
;
stopnote:
        push    dx              ;preserve DX
        mov     dx,61h          ;
        in      al,dx           ;
        and     al,11111100b    ;mask lower 2 bits
        out     dx,al           ;
        pop     dx              ;restore DX
        ret                     ;return to caller
;
; ESC pressed, so exit.
;
exit:
        call    stopnote        ;go silence the speaker
        mov     al,10           ;linefeed in AL
        int     29h             ;quick-print it
        int     20h             ;exit to DOS
;
; Our 'print string' routine.
;
prt_str:
        mov     ah,9            ;function 9 - print string
        int     21h             ;call DOS services
        ret                     ;return to caller
;
msg     db      13,10,'PIANO3'
        db      13,10,'Keyboard number keys 1 through 8 play the notes.'
        db      13,10,'ESC exits.  SPACE BAR toggles sustain -- now OFF$'
onn     db      08,08,'N ',08,'$'
off     db      08,'FF$'
;
;frequencies of notes
;
table   dw      262             ;middle C
        dw      294             ;D
        dw      330             ;E
        dw      347             ;F
        dw      392             ;G
        dw      440             ;A
        dw      494             ;B
        dw      524             ;C
code	ends

	end  start_code
