; ****************************************************************************
;
; SHELL01.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - 'sysfork' test
;
; [ Last Modification: 09/08/2013 ]
;
; ****************************************************************************

.8086

; UNIX v1 system calls
_rele 	equ 0
_exit 	equ 1
_fork 	equ 2
_read 	equ 3
_write	equ 4
_open	equ 5
_close 	equ 6
_wait 	equ 7
_creat 	equ 8
_link 	equ 9
_unlink	equ 10
_exec	equ 11
_chdir	equ 12
_time 	equ 13
_mkdir 	equ 14
_chmod	equ 15
_chown	equ 16
_break	equ 17
_stat	equ 18
_seek	equ 19
_tell 	equ 20
_mount	equ 21
_umount	equ 22
_setuid	equ 23
_getuid	equ 24
_stime	equ 25
_quit	equ 26	
_intr	equ 27
_fstat	equ 28
_emt 	equ 29
_mdate 	equ 30
_stty 	equ 31
_gtty	equ 32
_ilgins	equ 33

;;;
ESCKey equ 1Bh
EnterKey equ 0Dh

sys macro syscallnumber, arg1, arg2, arg3

    ; Retro UNIX 8086 v1 system call.

    ifnb <arg1> 	
      mov bx, arg1
    endif
    
    ifnb <arg2> 	
      mov cx, arg2
    endif

    ifnb <arg3> 	
      mov dx, arg3
    endif
     			
    mov ax, syscallnumber	
    int 20h	
   
    endm

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	mov si, offset sysfork_test
	call print_msg

      	mov bx, offset chldr
	sys _fork
	jc short error	

	; AX = process id
	call bin_to_hex
	mov word ptr [cpid], ax

	mov si, offset parent_return
	call print_msg

pwait:
	sys _wait
	jc short error

push ax
mov al, '.'
mov ah, 0Eh
mov bx, 7
int 10h
pop ax	
	cmp ax, word ptr [cpid]
	jne short pwait

@@:
	mov si, offset msg_ok
	call print_msg

	jmp short here	
chldr:
	; AX = process id
	call bin_to_hex
	mov word ptr [ppid], ax

	mov si, offset child_return
	call print_msg

	sys _exit
mov al, '@'
mov ah, 0Eh
mov bx, 7
int 10h	
	jmp short @b
	;jmp short pwait

here:	
	hlt
	jmp short here

error:
	mov si, offset msg_err
	call print_msg
        jmp short here
 
print_msg:
	mov     ah, 0Eh                  
        mov     bx, 07h  
@@:
        lodsb                           ; Load byte at DS:SI to AL
        and     al, al            
        jz      short @f      
            
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short @b         
@@:
        retn

bin_to_hex:
	db 0D4h, 10h                    ; Undocumented inst. AAM
					; AH = AL / 10h
					; AL = AL MOD 10h
	or ax, '00'                     ; Make it ZERO (ASCII) based

	xchg ah, al

	cmp al, '9'
	jna short @f
	add al, 7
@@::
	cmp ah, '9'
	jna short @f
	add ah, 7
@@:
	retn

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sysfork_test:	db 0Dh, 0Ah
		db 'Retro Unix 8086 v1 - <sysfork> test'
		db 0
		
parent_return:	db 0Dh, 0Ah
		db 'This is parent return !'
		db 0Dh, 0Ah
		db 'Child Process ID: '
cpid:           dw 3030h
		db 0Dh, 0Ah
sizeofparentr	equ $ - offset parent_return
		db 0
child_return:	db 0Dh, 0Ah
		db 'This is child return !'
		db 0Dh, 0Ah
		db 'Parent Process ID: '
ppid:           dw 3030h
		db 0Dh, 0Ah
sizeofchildr	equ $ - offset child_return
		db 0
msg_err:
		db 0Dh, 0Ah 
                db 'Error ! '
		db 0Dh, 0Ah, 0
msg_ok:
        	db 0Dh, 0Ah
        	db 'OK. '
        	db 0Dh, 0Ah
sizeof_ok 	equ $ - offset msg_ok 
        	db 0

UNIX     	ends

                end     START_CODE
