#include "KartenGrafik.h"

void KartenGrafik::Init(HWND hwnd)
{
  HDC hdc;
  int i;

  // CARDS.DLL laden
  hCardInst = LoadLibrary("CARDS.DLL");
  if (hCardInst == NULL)
    MessageBox(NULL,"Unable to open CARDS.DLL!","LoadLibrary",MB_OK);
  // Bitmaps laden
  for (i = 0; i < 52; i++)
  {
    hCardBMP[i] = LoadBitmap(hCardInst,MAKEINTRESOURCE(i+1));
  }
  hFreeBMP = LoadBitmap(hinst,"IDB_TEST");
    
  hdc = GetDC(hwnd);
  hMemDC = CreateCompatibleDC(hdc);
  ReleaseDC(hwnd,hdc);
}

void KartenGrafik::Clear()
{
}

void KartenGrafik::Close()
{
}

KartenGrafik::KartenGrafik()
{
}

KartenGrafik::~KartenGrafik()
{
  int i;
  // CARDS.DLL freigeben
  FreeLibrary((HMODULE)hCardInst);
  for (i = 0; i < 52; i++) DeleteObject( hCardBMP[i]);
  DeleteObject(hFreeBMP);
}

void KartenGrafik::MaleFreifeld(HDC hdc, unsigned px, unsigned py)
{
  hOldBMP = (HBITMAP) SelectObject(hMemDC,hFreeBMP);
  BitBlt(hdc,px+1,py+1,71,96,hMemDC,1,1,SRCCOPY);
  SelectObject(hMemDC,hOldBMP);
}

void KartenGrafik::MaleKarte (HDC hdc,Karte K,unsigned px, unsigned py, int teil, int Invers)
{
  POINT border[9];
  int Index;
  //  Karte zeichnen
  switch(K.Farbe)
  {
    case Kreuz: Index = (int) K.Wert-1;   break;
    case Pik:   Index = (int) K.Wert+38;  break;
    case Herz:  Index = (int) K.Wert+25;  break;
    case Karo:  Index = (int) K.Wert+12;  break;
  }
  hOldBMP = (HBITMAP) SelectObject(hMemDC,hCardBMP[Index]);

  if (teil)
  {
    if (Invers) BitBlt(hdc,px+1,py+1,69,18,hMemDC,1,1,NOTSRCCOPY);
    else BitBlt(hdc,px+1,py+1,69,18,hMemDC,1,1,SRCCOPY);

    border[0].x = px;    border[0].y = py+19;
    border[1].x = px;    border[1].y = py+2;
    border[2].x = px+2;  border[2].y = py;
    border[3].x = px+68; border[3].y = py;
    border[4].x = px+70; border[4].y = py+2;
    border[5].x = px+70; border[5].y = py+20;

    Polyline(hdc,border,6);
  }
  else
  {
    if (Invers) BitBlt(hdc,px+1,py+1,69,94,hMemDC,1,1,NOTSRCCOPY);
    else BitBlt(hdc,px+1,py+1,69,94,hMemDC,1,1,SRCCOPY);

    border[0].x = px+2;  border[0].y = py;
    border[1].x = px+68; border[1].y = py;
    border[2].x = px+70; border[2].y = py+2;
    border[3].x = px+70; border[3].y = py+93;
    border[4].x = px+68; border[4].y = py+95;
    border[5].x = px+2;  border[5].y = py+95;
    border[6].x = px;    border[6].y = py+93;
    border[7].x = px;    border[7].y = py+2;
    border[8].x = px+2;  border[8].y = py;

    Polyline(hdc,border,9);
  }
  
  SelectObject(hMemDC,hOldBMP);
}
