/***************************************************************************
  Windows Sockets Client Application Support Module

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.  

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/

/*
  MODULE: WS_DEBUG.C (debug routines)
*/

#include "ws_glob.h"
#include "ws_ftp.h"

struct win_info DBUGWINDOW;

HWND hWndDbg;

int CreateDebugWindow(HWND hMainWnd,HWND hInst)
{
  static WNDCLASS wndclass;
  long       nWndunits;     // window units for size and location
  int        nWndx;         // the x axis multiplier
  int        nWndy;         // the y axis multiplier
  int        nX;            // the resulting starting point (x, y)
  int        nY;
  int        nWidth;        // the resulting width and height for this
  int        nHeight;       // window

  wndclass.style        =CS_VREDRAW | CS_PARENTDC;
  wndclass.lpfnWndProc  =DebugWndProc;
  wndclass.cbClsExtra   =0;
  wndclass.cbWndExtra   =0;
  wndclass.hInstance    =(HANDLE)hInst;
  wndclass.hIcon        =LoadIcon((HINSTANCE)hInst,"WS_XBUG");
  wndclass.hCursor      =LoadCursor(NULL,IDC_ARROW);
  wndclass.hbrBackground=GetStockObject(LTGRAY_BRUSH);
  wndclass.lpszMenuName =szAppName;
  wndclass.lpszClassName=DBUGWNDCLASS;

  // Create a device independant size and location
  nWndunits = GetDialogBaseUnits();
  nWndx = LOWORD(nWndunits);
  nWndy = HIWORD(nWndunits);
  nX = ((40 * nWndx) / 4);
  nY = ((40 * nWndy) / 8);
  nWidth = ((200 * nWndx) / 4);
  nHeight = ((200 * nWndy) / 8);

  RegisterClass(&wndclass);

  hWndDbg=CreateWindow(DBUGWNDCLASS,"WS_FTP Debug",
      WS_OVERLAPPEDWINDOW,
      nX,nY,nWidth,nHeight,NULL,NULL,(HANDLE)hInst,NULL);
  ShowWindow(hWndDbg,SW_SHOWMINIMIZED);
  return(TRUE);
}

LRESULT CALLBACK DebugWndProc(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{

  switch (Message)
  {
    case WM_CREATE:
      DBUGWINDOW.hWnd=hWnd;
      DBUGWINDOW.nVpos=0;
      DBUGWINDOW.nMemPtr=0;
      DBUGWINDOW.nLineHeight=8;
      DBUGWINDOW.nScreenRows=20;

      SetScrollRange(hWnd, SB_VERT, 0, 100, FALSE);
      break;


    case WM_COMMAND:
      if(LOWORD(wParam)==BTN_CLOSE || LOWORD(wParam)==BTN_EXIT ||
         LOWORD(wParam)==CMD_CLOSE || LOWORD(wParam)==IDM_EXIT) {
      } else if(bCmdInProgress) return(FALSE);
     
      switch (LOWORD(wParam))
      {

#include "ws_debug.inc"

        case IDM_EXIT:
        case IDM_ABOUT:
             SendMessage(hWndMain,Message,wParam,lParam);
             break;

        default:
          return DefWindowProc(hWnd, Message, wParam, lParam);
      }
      break;

    case WM_SETCURSOR:
      if(bCmdInProgress)
        SetCursor(hWaitCursor);
      else
        return DefWindowProc(hWnd, Message, wParam, lParam);
      break;

    case WM_PAINT:
      DoWindowPaint(&DBUGWINDOW);
      break;

    case WM_VSCROLL:
      
      switch(LOWORD(wParam))
      {
        case SB_LINEDOWN:
          if(DBUGWINDOW.nVpos<(DBUGWINDOW.nMemPtr-1))
            DBUGWINDOW.nVpos++;
          break;
        case SB_LINEUP:
          if(DBUGWINDOW.nVpos>0)
            --DBUGWINDOW.nVpos;
          break;
        case SB_THUMBPOSITION:
          DBUGWINDOW.nVpos = min(DBUGWINDOW.nMemPtr, LOWORD(lParam));
          break;
        case SB_PAGEUP:
          if(DBUGWINDOW.nVpos>10)
            DBUGWINDOW.nVpos-=10;
          else DBUGWINDOW.nVpos=0;
          break;
        case SB_PAGEDOWN:
          if(DBUGWINDOW.nVpos<(DBUGWINDOW.nMemPtr-10))
            DBUGWINDOW.nVpos+=10;
          else DBUGWINDOW.nVpos=DBUGWINDOW.nMemPtr;
          break;
        default:
          return FALSE;
      }
      SetScrollPos(hWnd,SB_VERT,DBUGWINDOW.nVpos,TRUE);
      InvalidateRect(hWnd,NULL,TRUE);
      break;

    default:
      return DefWindowProc(hWnd, Message, wParam, lParam);
  }
  return 0L;
} 

