.TH UNFLICK 1 "19 January 1996"
.SH NAME
unflick \- extract images from a FLI/FLC file
.SH SYNOPSIS
.B unflick
[
.B \-a
|
.B \-m
]
[
.BI \-b " begin"
]
[
.BI \-n " max"
]
[ 
.B \-v
]
[
.B \-z
]
[
.B \-zz
]
.I animation
.I base
[
.I extension
]
.LP
.SH DESCRIPTION
The program
.B unflick
extracts single images or a series of images from a given 
FLI-animation.
The extracted images are stored in separated files. 
The formats PPM (raw and ascii) and FBM (mapped 8bpp) 
are available.
Additionally
.B unflick 
can perform an automatic compression of the output files using the
.B compress
or the
.B gzip
utility.
The file
.I animation
contains the input FLI-animation. 
The output file names are controlled by the parameters
.I base 
and
.IR extension .
.LP
If the parameter 
.I extension
is omitted, 
the names of the generated files are composed of the 
given 
.I base 
followed by a dot and a number field:
.IP
.nf
.IR base .001,
.IR base .002,
.IR base .003,
etc.
.fi
.LP
The number indicates the position at which the image appears 
in the FLI-animation.
Note that when the input animation has more than 999 frames 
automatically more digits are used in the number field of the
file names. 
.LP
In the case of a given 
.IR extension ,
the file names consist of the
.IR base ,
directly followed by the number field, plus a
dot and the given extension:
.IP
.nf
.IR base 001. extension ,
.IR base 002. extension ,
.IR base 003. extension ,
etc.
.fi
.LP
Before a image is written to disk,
the program tests if a file with the designated name already exists. 
In this case the old file is not overwritten and the program 
terminates with an error.
.SH OPTIONS
.TP
.B \-a
Write the images in PPM ascii format instead of PPM raw.
Note that this needs much more disk space.
.TP
.BI \-b " begin"
Only the images with the number
.I begin
or higher are extracted. 
By default the extraction starts with the first image.
.TP
.B \-m
Write the images in mapped FBM format.
Then they can be converted to other formats with the utilities
of the FBM package.
.TP
.BI \-n " max"
Extract not more than
.I max
images. 
By default all images from the 
given beginning up to the end are extracted. 
With this option it is possible to extract only a part 
of the images. 
.TP
.B \-v
Write some information about the processed FLI-file to
.IR stdout .
.TP
.B \-z
Postprocess the output files with the 
.B compress 
utility.
.TP
.B \-zz
Postprocess the output files with the 
.B gzip 
utility.
.RE
.SH EXAMPLES
For example we want to extract all images from the FLI-animation
`nicefilm.fli'.
We choose the names
.PP
.nf
	picture.001, picture.002, picture.003, ...
.fi
.LP
for the output files.
And we want that the images are written in PPM-ascii format.
In this case we give the command:
.PP
.nf
	% unflick -a nicefilm.fli picture
.fi
.LP
In the next example 
we are interested only in the 10th image of the FLI-animation. 
We want the output image in compressed PPM-raw format. 
As output name we wish
`picture010.ppm.Z'.
To do this we type the command:
.PP
.nf
	% unflick -b 10 -n 1 -z nicefilm.fli picture ppm
.fi
.LP
This only works when no old file with the name `picture010.ppm'
exists, because at first the image is written
to this file and then compressed. 
At the end this temporary file is removed by the
.B compress
command.
Note that
.B unflick
does not test the existence of the compressed file `picture010.ppm.Z'.
This is done by
.BR compress .
If such a file already exists 
.B compress 
usually asks to overwrite it.
When the answer is negative the compression is not performed
and the temporary file `picture010.ppm' is not removed.
.SH SEE ALSO
.BR ppm2fli (1)
.BR fbm (1)
and
.BR ppm (5)
.SH AUTHORS
Klaus Ehrenfried (klaus@es.go.dlr.de).
Copyright (C) 1996 by Klaus Ehrenfried.
Release of January 1996.
.LP
Permission to use, copy, modify, and distribute this software
is hereby granted, provided that the above copyright notice appears
in all copies and that the software is available to all free of charge.
The author disclaims all warranties with regard to this software,
including all implied warranties of merchant-ability and fitness.
The code is simply distributed as it is.
.\" end of man page
