/*
 * BSD-like Socket functions are emulated here.
 *
*/

#include <winsock.h>
#include <windows.h>
#include <limits.h>
#include <sys\types.h>

#include <unixapi.h>

int
WinRead (SOCKET fd, char *buf, int size)
{
    int nbytes;
    int wsaerror ;
    
    nbytes = recv ((SOCKET)fd, buf, size, 0);

    if (nbytes == SOCKET_ERROR)
    {
        wsaerror = WSAGetLastError();
        errno = ((wsaerror >= WSABASEERR) ? (wsaerror - WSABASEERR) : wsaerror); /* depends on codes same as BSD */
        return (-1);
    }
    else
    {
        errno = 0;
        return (nbytes);
    }
}

////////////////////////////////////////////////////////////////////////////////

int
WinWrite (SOCKET fd, char *buf, int size)
{
    int nbytes;
    int wsaerror ;
    
    nbytes = send ((SOCKET)fd, buf, size, 0);

    if (nbytes == SOCKET_ERROR)
    {
        wsaerror = WSAGetLastError();
        errno = ((wsaerror >= WSABASEERR) ? (wsaerror - WSABASEERR) : wsaerror); /* depends on codes same as BSD */
        return (-1);
    }
    else
    {
        errno = 0;
        return (nbytes);
    }
}

////////////////////////////////////////////////////////////////////////////////
