/*
 *
*/

#ifndef UNIXAPI_H
#define UNIXAPI_H

typedef unsigned int u_long ;
typedef unsigned int u_int ;
typedef unsigned char u_char ;
typedef unsigned short u_short ;
typedef long off_t;

#ifndef O_RDONLY
#define O_RDONLY       0x0000  /* open for reading only */
#endif

#ifndef O_WRONLY
#define O_WRONLY       0x0001  /* open for writing only */
#endif

#ifndef O_RDWR
#define O_RDWR         0x0002  /* open for reading and writing */
#endif

#ifndef O_APPEND
#define O_APPEND       0x0008  /* writes done at eof */
#endif


#ifndef O_CREAT
#define O_CREAT        0x0100  /* create and open file */
#endif

#ifndef O_TRUNC
#define O_TRUNC        0x0200  /* open and truncate */
#endif

#ifndef O_EXCL
#define O_EXCL         0x0400  /* open only if file doesn't already exist */
#endif

#define NAME_MAX 255
struct dirent {
    char d_name[NAME_MAX+1];
} ;

typedef struct _DIR {
    int Directory;
    unsigned long Index;
    char RestartScan;                   /* really BOOLEAN */
    struct dirent Dirent;
} DIR;

DIR *  opendir(const char *);
struct dirent *  readdir(DIR *);

/* #define DBGPRINT printf */
#define DBGPRINT

#endif /* UNIXAPI_H */
