/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * Revision 1.1  1995/03/07  23:14:41  bourquard
 * Original OSF sources
 *
 *
 * Revision 1.1.2.2  92/08/03  09:47:57  Dave_Hill
 * 	initial port to alpha
 * 	[92/08/03  09:37:32  Dave_Hill]
 * 
 * Revision 1.1  90/01/01  00:00:00  devrcs
 * 	Initial load into Alpha pool
 * 
 * Revision 1.2  91/12/30  12:48:20  devbld
 * 	Initial load of project
 * 
 */
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	displaymenucbs.c - display menu callbacks
 *
 *	Author:	Laurence P. G. Cable
 *
 *	Created : 5th May 1988
 *
 *
 *	Description
 *	-----------
 *
 *
 *	Modification History
 *	------------ -------
 *	
 *	31st May 1988	Laurence P. G. Cable
 *
 *	Pulled the edit button sorry didnt have the time!
 */

static char sccsid[] = "@(#)displaymenucbs.c	1.5	17:45:09 2/21/89";

#include <sys/types.h>
#include <sys/stat.h>

#ifdef  DEBUG
#include <stdio.h>
#endif  DEBUG
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include "dxdiff.h"
#include "arglists.h"
#include "y.tab.h"
#include "filestuff.h"
#include "parsediff.h"
#include "alloc.h"
#include "differencebox.h"
#include "menu.h"
#include "text.h"
#include "display.h"
#include "displaymenu.h"

/*******************************
 *******************************
 **
 ** Text Display Menu menu callbacks
 **
 *******************************
 *******************************/


/********************************
 *
 *      SkipToNextPrevDiffActivateCallback
 *
 ********************************/

extern	void	ScrollToNextDiffInDifferenceBox(), ScrollToPrevDiffInDifferenceBox();

static VoidProc
SkipToNextPrevDiffActivateCallback(w, clientd, calld)
	Widget	w;
	caddr_t	clientd;
	caddr_t	calld;
{
	DxDiffDisplayPtr	display = (DxDiffDisplayPtr)clientd;
	DifferenceBoxPtr	differencebox = DiffRegionADBPtrDifferenceBox(DxDiffDisplayPtrDiffRegionADB(display));
	TextDisplayADBPtr	ltext = DxDiffDisplayPtrLeftTextADB(display),
				rtext = DxDiffDisplayPtrRightTextADB(display),
				text, othertext;
	MenuEntryPtr		*lentries = AMenuBarPtrEntries(TextDisplayADBPtrMenuBar(ltext)),
				*rentries = AMenuBarPtrEntries(TextDisplayADBPtrMenuBar(rtext));
	Boolean			isleft;
	int			*top, *othertop, last, otherlast;
	void			(*scrollftn)();

#ifdef I18N_MULTIBYTE
	/* When one display is being scrolled, the other display must be
	   updated correspondingly. "otherscrollbar" is the XmScrollBar widget 
	   for the other display. "max" is the slider's maximum value and "min"
	   is the slider's minimum value. "slidersize" is the length of the 
	   slider between the values 1 and (max - min).
	*/

	static int max, min, slidersize;
	Widget otherscrollbar;
	static Arg scrollArgs[] = {
		{XmNmaximum, (XtArgVal)&max},
		{XmNminimum, (XtArgVal)&min},
		{XmNsliderSize, (XtArgVal)&slidersize}
	};
#endif /* I18N_MULTIBYTE */
	

	if ((isleft = (PushButtonEntryPtrWidget(MenuEntryPtrPushButtonEntryPtr(lentries[(int)NextDiffButton])) == w)) ||
	    PushButtonEntryPtrWidget(MenuEntryPtrPushButtonEntryPtr(rentries[(int)NextDiffButton])) == w) {
		scrollftn = ScrollToNextDiffInDifferenceBox;
	} else 
		if ((isleft = (PushButtonEntryPtrWidget(MenuEntryPtrPushButtonEntryPtr(lentries[(int)PrevDiffButton])) == w)) ||
		    PushButtonEntryPtrWidget(MenuEntryPtrPushButtonEntryPtr(rentries[(int)PrevDiffButton])) == w) {
			scrollftn = ScrollToPrevDiffInDifferenceBox;
		}

	if (isleft) {
		last = *(top = &(differencebox->toplnolf));
		otherlast = *(othertop = &(differencebox->toplnorf));
		text = ltext;
		othertext = rtext;
#ifdef I18N_MULTIBYTE
		/* Extract XmScrollBar widget of right display */
		otherscrollbar = (Widget) TextDisplayADBPtrVScroll(
			DxDiffDisplayPtrRightTextADB(display));
#endif /* I18N_MULTIBYTE */
	} else {
		last = *(top = &(differencebox->toplnorf));
		otherlast = *(othertop = &(differencebox->toplnolf));
		text = rtext;
		othertext = ltext;
#ifdef I18N_MULTIBYTE
		/* Extract XmScrollBar widget of left display */
		otherscrollbar = (Widget) TextDisplayADBPtrVScroll(
			DxDiffDisplayPtrLeftTextADB(display));
#endif /* I18N_MULTIBYTE */
	}

#ifdef I18N_BUG_FIX
	/* Extract scroll bar information of the other display. If the slider
	   size equals (max - min), i.e., the whole text can be fully displayed,
	   then there is no need to update the display.
	*/
	XtGetValues((Widget)otherscrollbar, scrollArgs, 3);
	if (slidersize == (max - min)) return;
#endif /* I18N_BUG_FIX */
	(*scrollftn)(differencebox, isleft ? LeftFile : RightFile);

	_XmTextDisableRedisplay(TextDisplayPtrWidget(TextDisplayADBPtrTextDisplay(text)), False);
	XmTextScroll(TextDisplayPtrWidget(TextDisplayADBPtrTextDisplay(text)), *top - last);

	if (differencebox->scrollmode == ScrollBoth) {
		_XmTextDisableRedisplay(TextDisplayPtrWidget(TextDisplayADBPtrTextDisplay(othertext)), False);
		XmTextScroll(TextDisplayPtrWidget(TextDisplayADBPtrTextDisplay(othertext)), *othertop - otherlast);
	}

	UpdateTextHighLights(TextDisplayADBPtrTextDisplay(ltext), TextDisplayADBPtrTextDisplay(rtext), differencebox);

	_XmTextEnableRedisplay(TextDisplayPtrWidget(TextDisplayADBPtrTextDisplay(text)));
	if (differencebox->scrollmode == ScrollBoth) {
		_XmTextEnableRedisplay(TextDisplayPtrWidget(TextDisplayADBPtrTextDisplay(othertext)));
	}
}

XtCallbackRec	SkipToNextPrevDiffCallbackList[] = {
			{ (XtCallbackProc)SkipToNextPrevDiffActivateCallback, 0 },
			{ (VoidProc)NULL, 0 }
		};



/********************************
 *
 *      EditActivateCallback
 *
 ********************************/

#ifdef	EDITBTN
static VoidProc
EditActivateCallback(w, clientd, calld)
	Widget	w;
	caddr_t	clientd;
	caddr_t	calld;
{
}

XtCallbackRec	EditCallbackList[] = {
			{ EditActivateCallback, 0 },
			{ (VoidProc)NULL, 0 }
		 };
#endif	EDITBTN
