/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * Revision 1.1.4.2  1994/04/08  19:04:20  Susan_Ng
 * 	code drop for post-Sterling fixes/I18N changes
 * 	[1994/04/07  18:17:25  Susan_Ng]
 *
 * Revision 2.0.1.3  1993/11/18  08:20:06  uwsmw
 * 	add I18N_MULTIBYTE comments
 * 
 * Revision 2.0.1.2  1993/09/28  02:19:35  uwsmw
 * 	I18N changes for BL6
 * 
 * Revision 1.1.2.3  93/01/05  17:26:12  Don_Haney
 * 	Implement HyperHelp and mnemonics
 * 	[92/12/31  14:52:13  Don_Haney]
 * 
 * Revision 1.1.2.2  92/08/03  09:48:11  Dave_Hill
 * 	initial port to alpha
 * 	[92/08/03  09:37:45  Dave_Hill]
 * 
 * Revision 1.1  90/01/01  00:00:00  devrcs
 * 	Initial load into Alpha pool
 * 
 * Revision 1.2  91/12/30  12:48:20  devbld
 * 	Initial load of project
 * 
 */
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  
 * 
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	dxdiff.h - application header file for dxdiff
 *
 *	Author:	Laurence P. G. Cable
 *
 *	Created : 3rd March 1988
 *
 *
 *
 *	Modification History
 *	------------ -------
 *	
 */
#ifdef I18N_MULTIBYTE
#include <Mrm/MrmAppl.h>
#endif /* I18N_MULTIBYTE */

#ifndef	DXDIFF_H
#define	DXDIFF_H

#define	DXDIFFNAME	"dxdiff"	/* application name */
#define	DXDIFFCLASS	"DxDiff"	/* application class */

#define	DXDIFFSHELLVARL	"$DxDiffLeftFile"	/* MUST have $ at start */
#define	DXDIFFSHELLVARR	"$DxDiffRightFile"	/* ditto */

/* added for NT compilation */
#ifndef _XtIntrinsic_h
#include <X11/intrinsic.h>
#endif _XtIntrinsic_h

#ifdef WIN32
#define off_t   _off_t
typedef char    *caddr_t;
#define S_IFMT  _S_IFMT
#define S_IFDIR _S_IFDIR
#define close 	_close
#define open  	_open
#define read  	_read
#define fdopen	_fdopen
#endif WIN32

/* note that any shell variable specified MUST be prefixed by a $ */

typedef void (*VoidProc)();

/********************************
 *
 *      EnvVariables
 *
 ********************************/

typedef	struct	_envvariables	{
		char	*shellvariable,
			*value;
} EnvVariables;

#ifdef HYPERHELP
#include        <DXm/bkr_api.h>
#define         dxdiff_help  "dxdiff"
#endif

#endif	DXDIFF_H /* do not include anything after this line */

/********************************
 * 
 * application resources
 *
 ********************************/

typedef struct _application_options {
    Boolean	slaveverticalscrolling;
    Boolean	slavehorizontalscrolling;

    Boolean	displaylinenumbers;
    Boolean	drawdiffsaslines;

    Boolean	Debug;
    XColor	linenumberforeground;

} *application_options_ptr;

extern struct _application_options app_options;

#ifdef I18N_MULTIBYTE
static char *db_filename_vec[] = {  /* Mrm.heirachy file list. */
    "DXdiff.uid"                    /* There is only one UID file for */
};                                  /* this application. */

extern MrmHierarchy dxdiff_hierarchy;   /* MRM database hierarchy id */
extern MrmType dxdiff_class;            /* and class variable. */

#define nFiles( x ) (sizeof(x)/sizeof(char *))
#define nRegs(x)    (sizeof(x)/sizeof(MrmRegisterArg))

extern Widget toplevel;
#endif /* I18N_MULTIBYTE */

