# NODEBUG=
!include <ntwin32.mak>

PROGRAM = dxdiff
DXWIN32OBJ = ..\dxwin32\dxwin32.obj


MSVCFLAGS = -NODEFAULTLIB:libc.lib
DXWIN32RBJ = ..\dxwin32\dxwin32.res

#++++++++++++++++++++++++++++++++++++++++++++++
# may need to be customized after installation
#
!ifndef EXCURSIONSDK
EXCURSIONSDK = ..\..
!endif
TOPDIR = $(EXCURSIONSDK)
FLEXDIR = c:\flex\src
YACCDIR = c:\yacc\intel
#----------------------------------------------

OBJS = parsediffy.obj parsediffl.obj differencebox.obj diffregionadb.obj displaymenu.obj \
       displaymenucbs.obj dxdiff.obj dxdiffdisplay.obj \
       filestuff.obj invokediff.obj mainmenu.obj mainmenucbs.obj menu.obj misc.obj \
       textdisplay.obj textdisplayadb.obj vscrollbarcbs.obj scrolling.obj dodiff.obj \
       fileselect.obj message.obj errors.obj hscrollbarcbs.obj binary.obj

!ifndef PROCESSOR_ARCHITECTURE
!error Please set environment variable PROCESSOR_ARCHITECTURE to x86, ALPHA, or MIPS
!endif
LIBDIR = $(PROCESSOR_ARCHITECTURE)

DXLIBS = \
     $(TOPDIR)\lib\$(LIBDIR)\dxm.lib \
     $(TOPDIR)\lib\$(LIBDIR)\mrm.lib  $(TOPDIR)\lib\$(LIBDIR)\Xm.lib \
     $(TOPDIR)\lib\$(LIBDIR)\Xt.lib $(TOPDIR)\lib\$(LIBDIR)\x11.lib 

MYFLAGS = $(cflags) \
# $(cdebug) 
    $(cvarsdll) -W0 -D__STDC__ \
   -DNO_REGEX -DNO_REGCOMP -DNO_CONST -DSTRINGS_ALIGNED -DDEC_MOTIF_BUG_FIX \
#   -DMEM_DEBUG \
    -DDEC_MOTIF_EXTENSION /Zi /Ox \
    -I$(TOPDIR)\x11 -I$(TOPDIR)\include 
 
UILSRC = $(TOPDIR)/include/uil
MSGSRC = $(MAKEDIR)/msg
#UIL_INCLUDES = -I$(UILSRC) -I$(MSGSRC)
UIL_INCLUDES = -I$(UILSRC)

all:: $(PROGRAM).exe $(PROGRAM).uid 

$(OBJS): ..\$*.c
    $(cc)  $(MYFLAGS)  ..\$*.c -Fo$*.obj

$(PROGRAM).uid: ..\$(PROGRAM).uil
    copy ..\msg.uil
    $(EXCURSIONSDK)\bin\$(PROCESSOR_ARCHITECTURE)\uil $(UIL_INCLUDES) -o $*.uid ..\$*.uil

$(PROGRAM).res: ..\$(PROGRAM).rc
    $(rc) $(rcvars) -r -fo $(PROGRAM).res $(cvarsdll) ..\$(PROGRAM).rc

msg.uid: msg.uil
    uil $(UIL_INCLUDES) -o $*.uid ..\$*.uil

!ifndef DXWIN32

MYLFLAGS = /PDB:NONE

$(PROGRAM).exe: $(OBJS) $(PROGRAM).res
    $(link) \
    -subsystem:windows \
    $(MSVCFLAGS) \
#    $(ldebug) \
    $(MYLFLAGS) \
    $(OBJS) $(PROGRAM).res \
#    $(DXLIBS) kernel32.lib  advapi32.lib wsock32.lib msvcrt.lib  \
    $(DXLIBS) \
    $(guilibsdll) \
    -out:$*.exe

#parsediffy.c : parsediffy.y
#    $(YACCDIR)\yacc -d -v -l $*.y 
#    copy ytab.h y.tab.h
#    del ytab.h
#    copy ytab.c $*.c
#    del ytab.c

#parsediffl.c : parsediffl.l
#    cd $(FLEXDIR)
#    flex -d -L $(MAKEDIR)\$*.l 
#    copy lexyy.c $(MAKEDIR)\$*.c
#    del lexyy.c
#    cd $(MAKEDIR)
!endif

!ifdef DXWIN32

$(PROGRAM).exe: $(DXWIN32OBJ) $(DXWIN32RBJ) $(OBJS)
    $(link) \
    $(MSVCFLAGS) \
    $(ldebug) \
    $(OBJS) \
    $(DXWIN32OBJ) \
    $(DXWIN32RBJ) \
    $(guilflags) \
    $(guilibsdll) $(DXLIBS) \
    -out:$*.exe

$(DXWIN32).obj:
    cd ..\dxwin32
    $(MAKE) all
    cd $(MAKEDIR)

$(DXWIN32RBJ):
    cd ..\dxwin32
    $(MAKE) all
    cd $(MAKEDIR)

!endif


