/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * Revision 1.1  1995/03/07  23:15:03  bourquard
 * Original OSF sources
 *
 * Revision 1.1.4.2  1994/04/08  19:04:57  Susan_Ng
 * 	code drop for post-Sterling fixes/I18N changes
 * 	[1994/04/07  18:18:27  Susan_Ng]
 *
 * Revision 2.0.1.3  1993/11/18  08:24:09  uwsmw
 * 	add I18N comments
 * 
 * Revision 2.0.1.2  1993/09/28  02:20:37  uwsmw
 * 	I18N changes for BL6
 * 
 * Revision 1.1.2.2  92/08/03  09:48:27  Dave_Hill
 * 	initial port to alpha
 * 	[92/08/03  09:38:01  Dave_Hill]
 * 
 * Revision 1.1  90/01/01  00:00:00  devrcs
 * 	Initial load into Alpha pool
 * 
 * Revision 1.2  91/12/30  12:48:20  devbld
 * 	Initial load of project
 * 
 */
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	message.c - message box handling
 *
 *	Author:	Laurence P. G. Cable
 *
 *	Created : 4th July 1988
 *
 *
 *	Description
 *	-----------
 *
 *
 *	Modification History
 *	------------ -------
 *
 *	02 Feb 1990	Colin Prosser
 *
 *	Fix typo in return type of ReportDiffErrors().  "void void" ==> void
 *	The compiler ought to have caught this but didn't until now.
 */



#include <sys/types.h>
#include <sys/stat.h>

#ifdef  DEBUG
#include <stdio.h>
#endif  DEBUG
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#ifdef I18N_MULTIBYTE
#include <DXm/DECspecific.h>
#endif /* I18N_MULTIBYTE */
#include "dxdiff.h"
#include "arglists.h"
#include "y.tab.h"
#include "filestuff.h"
#include "parsediff.h"
#include "alloc.h"
#include "differencebox.h"
#include "menu.h"
#include "text.h"
#include "display.h"


typedef	struct _differrclosure {	/* private structure for this modeule */
	DxDiffDisplayPtr	dxdiffdisplay;	/* my display */
	DenPtr			denptr;		/* cuurent error being displayed in the diff list */
} DiffErrClosure, *DiffErrClosurePtr;

/********************************
 *
 *	ReportDiffErrorsMBActivateCallBack
 *
 ********************************/

static void
ReportDiffErrorsMBActivateCallBack(w, clientd, calld)
	Widget	w;
	caddr_t	clientd,
		calld;
{
	register MessageBoxPtr	     messagebox = (MessageBoxPtr)clientd;
	register DiffErrClosurePtr   differrclosure = (DiffErrClosurePtr)MessageBoxPtrClosure(messagebox);

	if (differrclosure->denptr != (DenPtr)NULL) {
		SetMessageBoxMessage(messagebox, differrclosure->denptr->error);
		differrclosure->denptr = differrclosure->denptr->next;
		XtSetMappedWhenManaged(MessageBoxPtrWidget(messagebox), False);
		XtSetMappedWhenManaged(MessageBoxPtrWidget(messagebox), True);
	} else { /* all done */
		XtFree((char *)differrclosure);
		XtDestroyWidget(MessageBoxPtrWidget(messagebox));
	}
}

/********************************
 *
 *	ReportDiffErrors
 *
 ********************************/

void
ReportDiffErrors(dxdiffdisplay)
	register DxDiffDisplayPtr dxdiffdisplay;
{

#ifdef I18N_MULTIBYTE
	Display *dpy = XtDisplay(toplevel);
	MrmCode type;
	XmString error;
	long byte_count, status;
#else
	char			   *error;
#endif /* I18N_MULTIBYTE */
	register MessageBoxPtr	   messagebox;
	register DiffErrClosurePtr differrclosure;

	if ((differrclosure = (DiffErrClosurePtr)XtMalloc(sizeof (DiffErrClosure))) == (DiffErrClosurePtr)NULL) {
		return;	/* oops */
	}


	if (DxDiffDisplayPtrDiffList(dxdiffdisplay)->dencnt != 0) {
#ifdef I18N_MULTIBYTE
		error = DXmCvtFCtoCS(
		DxDiffDisplayPtrDiffList(dxdiffdisplay)->denhead->error,
		&byte_count, &status);
#else
		error = DxDiffDisplayPtrDiffList(dxdiffdisplay)->denhead->error;
#endif /* I18N_MULTIBYTE */
		differrclosure->denptr = DxDiffDisplayPtrDiffList(dxdiffdisplay)->denhead->next;
	} else {
#ifdef I18N_MULTIBYTE
		MrmFetchLiteral(dxdiff_hierarchy, "k_error_msg",
			dpy, &error, &type);
#else
		error = "diff(1) child returned non zero exit status!";
#endif /* I18N_MULTIBYTE */
		differrclosure->denptr = (DenPtr)NULL;
	}

	messagebox = (MessageBoxPtr)CreateMessageBox(MainADBPtrWidget(DxDiffDisplayPtrMainADB(dxdiffdisplay)),
					"dxdiffdisplayerror",
					(CoreArgListPtr)NULL,
					(DialogBoxArgListPtr)NULL,
					(LabelArgListPtr)NULL,
					error,
					differrclosure
		     );
}
