/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * Revision 1.2  1995/03/09  21:51:22  bourquard
 * port to NT
 *
 * Revision 2.0.1.5  1994/01/14  09:11:06  uws
 * merge with SS Jan 13
 *
 * Revision 2.0.1.4  1993/11/19  18:30:11  uwsmw
 * add comments
 *
 * Revision 1.1.4.2  1993/06/25  16:58:24  Lynda_Rice
 * 	Motif 1.2 Support
 * 	[1993/06/24  20:20:14  Lynda_Rice]
 *
 * Revision 1.2  91/12/30  12:48:20  devbld
 * 	Initial load of project
 * 
 * Revision 1.1.2.3  1993/01/05  17:26:36  Don_Haney
 * 	Implement HyperHelp and mnemonics
 * 	[92/12/31  14:52:29  Don_Haney]
 * 
 * Revision 1.1.2.2  92/08/03  09:48:51  Dave_Hill
 * 	initial port to alpha
 * 	[92/08/03  09:38:37  Dave_Hill]
 * 
 * Revision 1.1  90/01/01  00:00:00  devrcs
 * 	Initial load into Alpha pool
 * 
 */
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	mainmenu.c - main menu
 *
 *	Author:	Laurence P. G. Cable
 *
 *	Created : 30th April 1988
 *
 *
 *	Description
 *	-----------
 *
 *
 *	Modification History
 *	------------ -------
 *	
 *	8th May 1988	Laurence P. G. Cable
 *
 *	Blundered! atlered the core arglist copy code so as it wont overwrite the destory callback info
 *	copied from the static description!
 */

static char sccsid[] = "@(#)mainmenu.c	1.2	07:47:15 5/10/88";

#include <sys/types.h>
#include <sys/stat.h>

#ifdef  DEBUG
#include <stdio.h>
#endif  DEBUG
#include <X11/Xlib.h>
#ifdef WIN32
#include <X11/xfuncs.h>
#endif WIN32
#include <Xm/Xm.h>

#include "dxdiff.h"
#include "arglists.h"
#include "y.tab.h"
#include "filestuff.h"
#include "parsediff.h"
#include "alloc.h"
#include "differencebox.h"
#include "menu.h"
#include "text.h"
#include "display.h"
#include "mainmenu.h"

extern XtCallbackRec	OpenFilesCallbackList[],
#ifdef	VIEWBTNS
			ViewNextPrevCallbackList[],
#endif
			QuitCallbackList[],
#ifdef	SEARCH
			SetRECallbackList[],
			SearchLeftRightCallbackList[],
			FindNextPrevCallbackList[],
#endif
			SlaveVerticalScrollCallbackList[],
			SlaveHorizontalScrollCallBackList[],
			DiffRenderModeCallbackList[],
			RenderLineNumberingCallbackList[],
			DoDifferencesInNewCallbackList[],
			DoDifferencesCallbackList[],
#if defined( HYPERHELP )
			HelpMenuOnContextSymbol[],
			VisualDiffsSymbol[],
			HelpMenuSymbol[],
			HelpOnContextSymbol[],
			AboutSymbol[],
			SelectFilesSymbol[],
			ChangeCharsSymbol[],
			DisplayDiffsSymbol[],
			DiffExitSymbol[],
			CompareNewSymbol[],
#else
			HelpCallbackList[],
#endif
                        NullCallbackList[];

extern XtCallbackRec	FilesPullDownCallbackList[],
#ifdef	SEARCH
			SearchPullDownCallbackList[],
#endif
			OptionsPullDownCallbackList[],
#if defined( HYPERHELP )
			HelpPullDownCallbackList[],
#endif
			DifferencesPullDownCallbackList[];

extern	XtCallbackRec	PushButtonDestroyCallbackList[],
			PullDownMenuDestroyCallbackList[],
			PullDownDestroyCallbackList[],
			AMenuBarDestroyCallbackList[];


/********************************
 *
 *      Main Menu Template
 *
 ********************************/


/********************************
 *
 *      'Files' PullDown 
 *	'Open Files ....' 
 *
 ********************************/

static	PushButtonEntry	openfiles = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)OpenFilesCallbackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) SelectFilesSymbol),
#endif
	StaticInitPushButtonEntryMnemonic('O'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Open..."),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("openfiles"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};



/********************************
 *
 *      'Files' PullDown 
 *	'View Next' 
 *
 ********************************/

#ifdef	VIEWBTNS
static	PushButtonEntry	viewnext = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, (char *)NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack(ViewNextPrevCallbackList),
	StaticInitPushButtonEntrySensitivity(False),
	StaticInitFontArgList(0, 0, (XmFontList)NULL),
	StaticInitPushButtonEntryWidget((Widget)NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("View Next"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString((char  *)NULL),
	StaticInitPushButtonEntryButtonName("viewnext"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString((XmString)NULL),
	StaticInitPushButtonEntryAlternativeCString((XmString)NULL)
};




/********************************
 *
 *      'Files' PullDown 
 *	'View Prev' 
 *
 ********************************/

static	PushButtonEntry	viewprev = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, (char *)NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack(ViewNextPrevCallbackList),
	StaticInitPushButtonEntrySensitivity(False),
	StaticInitFontArgList(0, 0, (XmFontList)NULL),
	StaticInitPushButtonEntryWidget((Widget)NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("View Prev"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString((char  *)NULL),
	StaticInitPushButtonEntryButtonName("viewprev"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString((XmString)NULL),
	StaticInitPushButtonEntryAlternativeCString((XmString)NULL)
};
#endif	VIEWBTNS


/********************************
 *
 *      'Files' PullDown 
 *	'Quit' 
 *
 ********************************/

static	PushButtonEntry	quit = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)QuitCallbackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) DiffExitSymbol),
#endif	
	StaticInitPushButtonEntryMnemonic('x'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Exit"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("quit"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};






/********************************
 *
 *      'Files' PullDown 
 *
 ********************************/

static PushButtonEntryPtr filesmenubuttons[] = {
	&openfiles,
#ifdef	VIEWBTNS
	&viewnext,
	&viewprev,
#endif
	&quit
};

static	PullDownMenuEntry filespulldownmenu = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownMenuDestroyCallbackList),
	StaticInitPullDownMenuEntryWidget(NULL),
	StaticInitPullDownMenuEntryMenuName("filespulldown"),
	StaticInitPullDownMenuEntryNumButtons(sizeof filesmenubuttons / sizeof (PushButtonEntryPtr)),
	StaticInitPullDownMenuEntryPushButtons(filesmenubuttons)
};

static PullDownEntry filespulldown = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPullDownEntrySubMenuWidget(NULL),
	StaticInitPullDownEntryPullDownCallBack((XtArgVal)FilesPullDownCallbackList),
#ifdef HYPERHELP
	StaticInitPullDownEntryContextHelp((XtArgVal) SelectFilesSymbol),
#endif
	StaticInitPullDownEntryMnemonic('F'),
	StaticInitPullDownEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPullDownEntryWidget(NULL),
	StaticInitPullDownEntrySubMenuParent(NULL),
	StaticInitPullDownEntryEntryName("filespulldown"),
#ifdef I18N_MULTIBYTE
	StaticInitPullDownEntryMainString(NULL),
#else
	StaticInitPullDownEntryMainString("File"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPullDownEntryPullDownMenuEntry(&filespulldownmenu),
	StaticInitPullDownEntryMainCString(NULL)
};


/********************************
 *
 *      'Search' PullDown 
 *	'RE's....' 
 *
 ********************************/

#ifdef	SEARCH
static	PushButtonEntry	setres = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)SetRECallbackList),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("RE's..."),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("setres"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};



/********************************
 *
 *      'Search' PullDown 
 *	'Find Next' 
 *
 ********************************/

static	PushButtonEntry	findnext = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)FindNextPrevCallbackList),
	StaticInitPushButtonEntrySensitivity(False),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Find Next"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("findnext"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};




/********************************
 *
 *      'Search' PullDown 
 *	'Find Prev' 
 *
 ********************************/

static	PushButtonEntry	findprev = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)FindNextPrevCallbackList),
	StaticInitPushButtonEntrySensitivity(False),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Find Prev"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("findprev"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};





/********************************
 *
 *      'Search' PullDown 
 *
 ********************************/

static PushButtonEntryPtr searchmenubuttons[] = {
	&setres,
	&findnext,
	&findprev
};

static	PullDownMenuEntry searchpulldownmenu = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, PullDownMenuDestroyCallbackList),
	StaticInitPullDownMenuEntryWidget((Widget)NULL),
	StaticInitPullDownMenuEntryMenuName("searchpulldown"),
	StaticInitPullDownMenuEntryNumButtons(sizeof searchmenubuttons / sizeof (PushButtonEntryPtr)),
	StaticInitPullDownMenuEntryPushButtons(searchmenubuttons)
};

static PullDownEntry searchpulldown = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, PullDownDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, (char *)NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPullDownEntrySubMenuWidget((Widget)NULL),
	StaticInitPullDownEntryPullDownCallBack(SearchPullDownCallbackList),
	StaticInitPullDownEntrySensitivity(False),
	StaticInitFontArgList(0, 0, (XmFontList)NULL),
	StaticInitPullDownEntryWidget((Widget)NULL),
	StaticInitPullDownEntrySubMenuParent((Widget)NULL),
	StaticInitPullDownEntryEntryName("searchpulldown"),
#ifdef I18N_MULTIBYTE
	StaticInitPullDownEntryMainString(NULL),
#else
	StaticInitPullDownEntryMainString("Search"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPullDownEntryPullDownMenuEntry(&searchpulldownmenu),
	StaticInitPullDownEntryMainCString((XmString)NULL)
};
#endif	SEARCH


/********************************
 *
 *      'Options' PullDown 
 *	'Slave Vertical Scrolling On/Off' 
 *
 ********************************/

static	PushButtonEntry	slavevertical = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)SlaveVerticalScrollCallbackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) ChangeCharsSymbol),
#endif
	StaticInitPushButtonEntryMnemonic('V'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
	StaticInitPushButtonEntryAlternativeString(NULL),
#else
	StaticInitPushButtonEntryMainString("Linked Vertical Scrolling On"),
	StaticInitPushButtonEntryAlternativeString("Linked Vertical Scrolling Off"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryButtonName("slavevertical"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};



/********************************
 *
 *      'Options' PullDown 
 *	'Slave Horizontal Scrolling On/Off' 
 *
 ********************************/

static	PushButtonEntry	slavehorizontal = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)SlaveHorizontalScrollCallBackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) ChangeCharsSymbol),
#endif
	StaticInitPushButtonEntryMnemonic('H'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
	StaticInitPushButtonEntryAlternativeString(NULL),
#else
	StaticInitPushButtonEntryMainString("Linked Horizontal Scrolling On"),
	StaticInitPushButtonEntryAlternativeString("Linked Horizontal Scrolling Off"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryButtonName("slavehorizontal"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};




/********************************
 *
 *      'Options' PullDown 
 *	'Draw Diffs As Lines/Filled Polygons' 
 *
 ********************************/

static	PushButtonEntry	drawdiffs = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)DiffRenderModeCallbackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) ChangeCharsSymbol),
#endif
	StaticInitPushButtonEntryMnemonic('R'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
	StaticInitPushButtonEntryAlternativeString(NULL),
#else
	StaticInitPushButtonEntryMainString("Render Diffs As Lines"),
	StaticInitPushButtonEntryAlternativeString("Render Diffs As Filled Polygons"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryButtonName("drawdiffs"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};





/********************************
 *
 *      'Options' PullDown 
 *	'Display Line Numbers' 
 *
 ********************************/

static	PushButtonEntry	drawlinenumbers = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)RenderLineNumberingCallbackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) ChangeCharsSymbol),
#endif
	StaticInitPushButtonEntryMnemonic('N'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
	StaticInitPushButtonEntryAlternativeString(NULL),
#else
	StaticInitPushButtonEntryMainString("Display Diff Line Numbers"),
	StaticInitPushButtonEntryAlternativeString("No Diff Line Numbers"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryButtonName("drawlinenumbers"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};





/********************************
 *
 *      'Options' PullDown 
 *
 ********************************/

static PushButtonEntryPtr optionsmenubuttons[] = {
	&slavevertical,
	&slavehorizontal,
	&drawdiffs,
	&drawlinenumbers
};

static	PullDownMenuEntry optionspulldownmenu = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownMenuDestroyCallbackList),
	StaticInitPullDownMenuEntryWidget(NULL),
	StaticInitPullDownMenuEntryMenuName("optionspulldown"),
	StaticInitPullDownMenuEntryNumButtons(sizeof optionsmenubuttons / sizeof (PushButtonEntryPtr)),
	StaticInitPullDownMenuEntryPushButtons(optionsmenubuttons)
};

static PullDownEntry optionspulldown = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPullDownEntrySubMenuWidget(NULL),
	StaticInitPullDownEntryPullDownCallBack((XtArgVal)OptionsPullDownCallbackList),
#ifdef HYPERHELP
	StaticInitPullDownEntryContextHelp((XtArgVal) ChangeCharsSymbol),
#endif
	StaticInitPullDownEntryMnemonic('O'),
	StaticInitPullDownEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPullDownEntryWidget(NULL),
	StaticInitPullDownEntrySubMenuParent(NULL),
	StaticInitPullDownEntryEntryName("optionspulldown"),
#ifdef I18N_MULTIBYTE
	StaticInitPullDownEntryMainString(NULL),
#else
	StaticInitPullDownEntryMainString("Options"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPullDownEntryPullDownMenuEntry(&optionspulldownmenu),
	StaticInitPullDownEntryMainCString(NULL)
};





/********************************
 *
 *      'Differences' PullDown 
 *	'Do Differences' 
 *
 ********************************/

static	PushButtonEntry	dodifferences = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)DoDifferencesCallbackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) DisplayDiffsSymbol),
#endif
	StaticInitPushButtonEntryMnemonic('D'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Do Differences"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("dodifferences"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};





/********************************
 *
 *      'Differences' PullDown 
 *	'Do Differences In New' 
 *
 ********************************/

static	PushButtonEntry	dodifferencesinnew = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)DoDifferencesInNewCallbackList),
#ifdef HYPERHELP
	StaticInitPushButtonEntryContextHelp((XtArgVal) CompareNewSymbol),
#endif
	StaticInitPushButtonEntryMnemonic('N'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Do Differences In New"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("dodifferencesinnew"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};





/********************************
 *
 *      'Differences' PullDown 
 *
 ********************************/

static PushButtonEntryPtr differencesmenubuttons[] = {
	&dodifferences,
	&dodifferencesinnew
};

static	PullDownMenuEntry differencespulldownmenu = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownMenuDestroyCallbackList),
	StaticInitPullDownMenuEntryWidget(NULL),
	StaticInitPullDownMenuEntryMenuName("differencespulldown"),
	StaticInitPullDownMenuEntryNumButtons(sizeof differencesmenubuttons / sizeof (PushButtonEntryPtr)),
	StaticInitPullDownMenuEntryPushButtons(differencesmenubuttons)
};

static PullDownEntry differencespulldown = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPullDownEntrySubMenuWidget(NULL),
	StaticInitPullDownEntryPullDownCallBack((XtArgVal)DifferencesPullDownCallbackList),
#ifdef HYPERHELP
	StaticInitPullDownEntryContextHelp((XtArgVal) DisplayDiffsSymbol),
#endif
	StaticInitPullDownEntryMnemonic('D'),
	StaticInitPullDownEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPullDownEntryWidget(NULL),
	StaticInitPullDownEntrySubMenuParent(NULL),
	StaticInitPullDownEntryEntryName("differencespulldown"),
#ifdef I18N_MULTIBYTE
	StaticInitPullDownEntryMainString(NULL),
#else
	StaticInitPullDownEntryMainString("Differences"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPullDownEntryPullDownMenuEntry(&differencespulldownmenu),
	StaticInitPullDownEntryMainCString(NULL)
};










/********************************
 *
 *	'Help' 
 *
 ********************************/


#if (((XmVERSION == 1) && (XmREVISION >=2) && !defined(WIN32) ) || XmVERSION >= 2 || defined (HYPERHELP))

/********************************
 *
 *      'Help' PullDown 
 *	'On Context'
 *
 ********************************/

static	PushButtonEntry	oncontext = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
#ifdef HYPERHELP
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)HelpMenuOnContextSymbol),
	StaticInitPushButtonEntryContextHelp((XtArgVal) HelpOnContextSymbol),
#else
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)NullCallbackList),
#endif
	StaticInitPushButtonEntryMnemonic('C'),
	StaticInitPushButtonEntryAccelerator("Shift<Key>osfHelp"),
	StaticInitPushButtonEntryAcceleratorText("Shift+Help"),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Context-Sensitive Help"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("oncontext"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};


/********************************
 *
 *      'Help' PullDown 
 *	'On Window'
 *
 ********************************/

static	PushButtonEntry	onwindow = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
#ifdef HYPERHELP
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)VisualDiffsSymbol),
	StaticInitPushButtonEntryContextHelp((XtArgVal) VisualDiffsSymbol),
#else
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)NullCallbackList),
#endif
	StaticInitPushButtonEntryMnemonic('O'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Overview"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("onwindow"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};




/********************************
 *
 *      'Help' PullDown 
 *	'On Help'
 *
 ********************************/

static	PushButtonEntry	onhelp = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
#ifdef HYPERHELP
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)HelpMenuSymbol),
	StaticInitPushButtonEntryContextHelp((XtArgVal) HelpMenuSymbol),
#else
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)NullCallbackList),
#endif
	StaticInitPushButtonEntryMnemonic('H'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Using Help"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("onhelp"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};





/********************************
 *
 *      'Help' PullDown 
 *	'On Version'
 *
 ********************************/

static	PushButtonEntry	onversion = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
#ifdef HYPERHELP
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)AboutSymbol),
	StaticInitPushButtonEntryContextHelp((XtArgVal) AboutSymbol),
#else
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)NullCallbackList),
#endif
	StaticInitPushButtonEntryMnemonic('P'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Product Information"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("onversion"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};





/********************************
 *
 *      'Help' PullDown 
 *
 ********************************/

static PushButtonEntryPtr helpmenubuttons[] = {
	&oncontext,
	&onwindow,
	&onhelp,
	&onversion
};

static	PullDownMenuEntry helppulldownmenu = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownMenuDestroyCallbackList),
	StaticInitPullDownMenuEntryWidget(NULL),
	StaticInitPullDownMenuEntryMenuName("helppulldown"),
	StaticInitPullDownMenuEntryNumButtons(sizeof helpmenubuttons / sizeof (PushButtonEntryPtr)),
	StaticInitPullDownMenuEntryPushButtons(helpmenubuttons)
};

static PullDownEntry helppulldown = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PullDownDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPullDownEntrySubMenuWidget(NULL),
#ifdef HYPERHELP
	StaticInitPullDownEntryPullDownCallBack((XtArgVal)HelpPullDownCallbackList),
	StaticInitPullDownEntryContextHelp((XtArgVal) HelpMenuSymbol),
#else
	StaticInitPullDownEntryPullDownCallBack((XtArgVal)NullCallbackList),
#endif
	StaticInitPullDownEntryMnemonic('H'),
	StaticInitPullDownEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPullDownEntryWidget(NULL),
	StaticInitPullDownEntrySubMenuParent(NULL),
	StaticInitPullDownEntryEntryName("helppulldown"),
#ifdef I18N_MULTIBYTE
	StaticInitPullDownEntryMainString(NULL),
#else
	StaticInitPullDownEntryMainString("Help"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPullDownEntryPullDownMenuEntry(&helppulldownmenu),
	StaticInitPullDownEntryMainCString(NULL)
};

#else

static	PushButtonEntry	help = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)PushButtonDestroyCallbackList),
	StaticInitLabelArgList(XmSTRING, NULL, 0, 0, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	StaticInitPushButtonEntryActivateCallBack((XtArgVal)HelpCallbackList),
	StaticInitPullDownEntryMnemonic('H'),
	StaticInitPushButtonEntryAccelerator(NULL),
	StaticInitPushButtonEntryAcceleratorText(NULL),
	StaticInitPushButtonEntrySensitivity(True),
	StaticInitFontArgList(0, 0, NULL),
	StaticInitPushButtonEntryWidget(NULL),
#ifdef I18N_MULTIBYTE
	StaticInitPushButtonEntryMainString(NULL),
#else
	StaticInitPushButtonEntryMainString("Help"),
#endif  /* I18N_MULTIBYTE */
	StaticInitPushButtonEntryAlternativeString(NULL),
	StaticInitPushButtonEntryButtonName("help"),
	StaticInitPushButtonEntryCurrentLabel(NoLabel),
	StaticInitPushButtonEntryMainCString(NULL),
	StaticInitPushButtonEntryAlternativeCString(NULL)
};

#endif /* HYPERHELP */





/********************************
 *
 *	'Main Menu'
 *
 ********************************/

static MenuEntry filesme =	{
	EntryIsPullDown,
	(PushButtonOrPullDownPtr)&filespulldown
};

#ifdef	SEARCH
static MenuEntry searchme = {
	EntryIsPullDown,
	(PushButtonOrPullDownPtr)&searchpulldown
};
#endif

static MenuEntry optionsme = {
	EntryIsPullDown,
	(PushButtonOrPullDownPtr)&optionspulldown
};

static MenuEntry differencesme = {
	EntryIsPullDown,
	(PushButtonOrPullDownPtr)&differencespulldown
};

static MenuEntry helpme = {
#if (((XmVERSION == 1) && (XmREVISION >=2) && !defined(WIN32) ) || XmVERSION >= 2 || defined (HYPERHELP))
	EntryIsPullDown,
	(PushButtonOrPullDownPtr)&helppulldown
#else
	EntryIsCascadeButton,
	(PushButtonOrPullDownPtr)&help
#endif
};

static MenuEntry *mainmenuentries[] = {
	&filesme,
#ifdef	SEARCH
	&searchme,
#endif
	&optionsme,
	&differencesme,
	&helpme
};

static AMenuBar mainmenubar = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)AMenuBarDestroyCallbackList),
	StaticInitADBConstraintArgList(XmATTACH_FORM,XmATTACH_SELF,
				       XmATTACH_FORM, XmATTACH_FORM,
				       NULL, NULL,
				       NULL, NULL,
				       0,0,0,0),
	StaticInitMenuBarArgList(XmHORIZONTAL, XmMENU_BAR),
	StaticInitAMenuBarWidget(NULL),
	StaticInitAMenuBarMenuName("mainmenu"),
	StaticInitAMenuBarNumEntries(sizeof (mainmenuentries) /
				     sizeof (MenuEntryPtr)),
	StaticInitAMenuBarEntries(mainmenuentries)
};

#ifdef I18N_MULTIBYTE

/******************************************************************************
*
* fetch_main_menu_label : fetch labels of main menu from UID and then assign
*				to different data structures.
*
* parameters : none
*
* return value : none
*
******************************************************************************/

void fetch_main_menu_label(void)
{
	int i;
	Display *dpy = XtDisplay(toplevel);
	MrmCode type;

	/* Fetch xmstring labels of main menus from UID */
	for (i = 0; i < NUM_OF_MAIN_LABEL; i++){
		if (MrmFetchLiteral(dxdiff_hierarchy, main_literal[i],
			dpy, &main_menu[i], &type) != MrmSUCCESS)
				main_menu[i] = NULL;
											}
											/* Set Main Menu Labels using XmStrings defined in UID */

	/* Files Pulldown */
	PullDownEntryMainCString(filespulldown) =
		main_menu[FILEPULLDOWN];
	PushButtonEntryMainCString(openfiles) = main_menu[OPENFILES];
#ifdef VIEWBTNS
	PushButtonEntryMainCString(viewnext) = main_menu[VIEWNEXT];
	PushButtonEntryMainCString(viewprev) = main_menu[VIEWPREV];
#endif VIEWBTNS
	PushButtonEntryMainCString(quit) = main_menu[QUIT];

	PullDownEntryMainCString(filespulldown) =
	main_menu[FILEPULLDOWN];

#ifdef  SEARCH
	/* Search Pulldown */
	PullDownEntryMainCString(searchpulldown) =
	main_menu[SEARCHPULLDOWN];
	PushButtonEntryMainCString(setres) = main_menu[SETRES];
	PushButtonEntryMainCString(findnext) = main_menu[FINDNEXT];
	PushButtonEntryMainCString(findprev) = main_menu[FINDPREV];
#endif SEARCH

        /* Options Pulldown */
	PullDownEntryMainCString(optionspulldown) =
		main_menu[OPTIONSPULLDOWN];

	PushButtonEntryMainCString(slavevertical) =
		main_menu[SLAVEVERTICAL];
	PushButtonEntryAlternativeCString(slavevertical) =
		main_menu[SLAVEVERTICAL_ALT];

        PushButtonEntryMainCString(slavehorizontal) =
		main_menu[SLAVEHORIZONTAL];
	PushButtonEntryAlternativeCString(slavehorizontal) =
		main_menu[SLAVEHORIZONTAL_ALT];

	PushButtonEntryMainCString(drawdiffs) =
		main_menu[DRAWDIFFS];
	PushButtonEntryAlternativeCString(drawdiffs) =
		main_menu[DRAWDIFFS_ALT];

	PushButtonEntryMainCString(drawlinenumbers) =
		main_menu[DRAWLINENUMBERS];
        PushButtonEntryAlternativeCString(drawlinenumbers) =
		main_menu[DRAWLINENUMBERS_ALT];

	/* Differences PullDown */
	PullDownEntryMainCString(differencespulldown) =
		main_menu[DIFFERENCESPULLDOWN];
	PushButtonEntryMainCString(dodifferences) =
		main_menu[DODIFFERENCES];
	PushButtonEntryMainCString(dodifferencesinnew) =
		main_menu[DODIFFERENCESINNEW];

#ifdef HYPERHELP
	/* Help Pulldown */
	PullDownEntryMainCString(helppulldown) =
		main_menu[HELPPULLDOWN];
	PushButtonEntryMainCString(oncontext) =
		main_menu[ONCONTEXT];
	PushButtonEntryMainCString(onwindow) =
		main_menu[ONWINDOW];
	PushButtonEntryMainCString(onhelp) =
		main_menu[ONHELP];
	PushButtonEntryMainCString(onversion) =
		main_menu[ONVERSION];
#else
	/* Help Button */
	PushButtonEntryMainCString(help) = main_menu[HELP];
#endif HYPERHELP
}

#endif /* I18N_MULTIBYTE */

														     

/********************************
 *
 *	CreateNewMainMenu
 *
 ********************************/


AMenuBarPtr
CreateMainMenu(parent, core, constraints, menubar, closure)
	Widget			parent;
	CoreArgListPtr		core;
	ADBConstraintArgListPtr	constraints;
	MenuBarArgListPtr	menubar;
	caddr_t			closure;
{
	register AMenuBarPtr 	      new;
	register PushButtonEntryPtr   pb,*ppb;
	register PullDownEntryPtr     pd;
	register PullDownMenuEntryPtr pdm;
	register unsigned int         num;
	Arg	 		      helppushbutton;
	
#ifdef I18N_MULTIBYTE
	/* Fetch xmstring labels of main menu from UID */
	fetch_main_menu_label();
#endif /* I18N_MULTIBYTE */

	if ((new = (AMenuBarPtr)NewAMenuBar(&mainmenubar)) == NULL) {
		return new;
	}

	if (core != (CoreArgListPtr)NULL) {
		bcopy((char *)core, (char *)&AMenuBarPtrCoreArgList(new),
		      sizeof(CoreArgList) - sizeof (Arg));	/* dont overwrite ther destroy callback */
	}

	if (constraints != (ADBConstraintArgListPtr)NULL) {
		bcopy((char *)constraints, (char *)&AMenuBarPtrConstraintArgList(new),
		      sizeof(ADBConstraintArgList));
	}

	if (menubar != (MenuBarArgListPtr)NULL) {
		bcopy((char *)menubar, (char *)&AMenuBarPtrMenuBarArgList(new),
		      sizeof(MenuBarArgList));
	}

#if (((XmVERSION == 1) && (XmREVISION >=2) && !defined(WIN32) ) || XmVERSION >= 2 || defined (HYPERHELP))
	pd = (PullDownEntryPtr)MenuEntryPtrPullDown(
		AMenuBarPtrEntries(new)[(int)HelpButton]);
	LabelLabel(PullDownEntryPtrLabelArgList(pd)) = 
		(XtArgVal)PullDownEntryPtrMainCString(pd);

	pdm = PullDownEntryPtrPullDownMenuEntry(pd);

	for (num = PullDownMenuEntryPtrNumButtons(pdm),
	     ppb = PullDownMenuEntryPtrPushButtons(pdm);
	     num -- > 0;
	     ppb++) {
		LabelLabel(PushButtonEntryPtrLabelArgList(*ppb)) =
			(XtArgVal)PushButtonEntryPtrMainCString(*ppb);
		PushButtonEntryPtrCurrentLabel(*ppb) = MainLabel;
	}
#else
	pb = (PushButtonEntryPtr)MenuEntryPtrPushButton(
		AMenuBarPtrEntries(new)[(int)HelpButton]);
	LabelLabel(PushButtonEntryPtrLabelArgList(pb)) =
		(XtArgVal)PushButtonEntryPtrMainCString(pb);
	PushButtonEntryPtrCurrentLabel(pb) = MainLabel;
#endif

	pd = (PullDownEntryPtr)MenuEntryPtrPullDown(
		AMenuBarPtrEntries(new)[(int)FilesButton]);
	LabelLabel(PullDownEntryPtrLabelArgList(pd)) = 
		(XtArgVal)PullDownEntryPtrMainCString(pd);

	pdm = PullDownEntryPtrPullDownMenuEntry(pd);

	for (num = PullDownMenuEntryPtrNumButtons(pdm),
	     ppb = PullDownMenuEntryPtrPushButtons(pdm);
	     num -- > 0;
	     ppb++) {
		LabelLabel(PushButtonEntryPtrLabelArgList(*ppb)) =
			(XtArgVal)PushButtonEntryPtrMainCString(*ppb);
		PushButtonEntryPtrCurrentLabel(*ppb) = MainLabel;
	}

#ifdef	SEARCH
	pd = MenuEntryPtrPullDown(AMenuBarPtrEntries(new)[(int)SearchButton]);
	LabelLabel(PullDownEntryPtrLabelArgList(pd)) =
		PullDownEntryPtrMainCString(pd);

	pdm = PullDownEntryPtrPullDownMenuEntry(pd);

	for (num = PullDownMenuEntryPtrNumButtons(pdm),
	     ppb = PullDownMenuEntryPtrPushButtons(pdm);
	     num -- > 0;
	     ppb++) {
		LabelLabel(PushButtonEntryPtrLabelArgList(*ppb)) =
			PushButtonEntryPtrMainCString(*ppb);
		PushButtonEntryPtrCurrentLabel(*ppb) = MainLabel;
	}
#endif

	pd = (PullDownEntryPtr)MenuEntryPtrPullDown(
		AMenuBarPtrEntries(new)[(int)OptionsButton]);
	LabelLabel(PullDownEntryPtrLabelArgList(pd)) =
		(XtArgVal)PullDownEntryPtrMainCString(pd);

	pdm = PullDownEntryPtrPullDownMenuEntry(pd);

	for (num = PullDownMenuEntryPtrNumButtons(pdm),
	     ppb = PullDownMenuEntryPtrPushButtons(pdm);
	     num -- > 0;
	     ppb++) {
		LabelLabel(PushButtonEntryPtrLabelArgList(*ppb)) =
			(XtArgVal)PushButtonEntryPtrMainCString(*ppb);
		PushButtonEntryPtrCurrentLabel(*ppb) = MainLabel;
	}

	pd = (PullDownEntryPtr)MenuEntryPtrPullDown(
		AMenuBarPtrEntries(new)[(int)DifferencesButton]);
	LabelLabel(PullDownEntryPtrLabelArgList(pd)) =
		(XtArgVal)PullDownEntryPtrMainCString(pd);

	pdm = PullDownEntryPtrPullDownMenuEntry(pd);

	for (num = PullDownMenuEntryPtrNumButtons(pdm),
	     ppb = PullDownMenuEntryPtrPushButtons(pdm);
	     num -- > 0;
	     ppb++) {
		LabelLabel(PushButtonEntryPtrLabelArgList(*ppb)) =
			(XtArgVal)PushButtonEntryPtrMainCString(*ppb);
		PushButtonEntryPtrCurrentLabel(*ppb) = MainLabel;
	}

#ifdef	VIEWBTNS
	ViewNextPrevCallbackList[0].closure = closure;
#endif
	OpenFilesCallbackList[0].closure = closure;
	QuitCallbackList[0].closure = closure;
#ifdef	SEARCH
	SetRECallbackList[0].closure = closure;
	SearchLeftRightCallbackList[0].closure = closure;
	FindNextPrevCallbackList[0].closure = closure;
#endif
	SlaveVerticalScrollCallbackList[0].closure = closure;
	SlaveHorizontalScrollCallBackList[0].closure = closure;
	DiffRenderModeCallbackList[0].closure = closure;
	RenderLineNumberingCallbackList[0].closure = closure;
	DoDifferencesInNewCallbackList[0].closure = closure;
	DoDifferencesCallbackList[0].closure = closure;
	FilesPullDownCallbackList[0].closure = closure;
#ifdef	SEARCH
	SearchPullDownCallbackList[0].closure = closure;
#endif
	OptionsPullDownCallbackList[0].closure = closure;
	DifferencesPullDownCallbackList[0].closure = closure;

	CreateAMenuBar(parent, new);

#if (((XmVERSION == 1) && (XmREVISION >=2) && !defined(WIN32) ) || XmVERSION >= 2 || defined (HYPERHELP))
        pd = (PullDownEntryPtr)MenuEntryPtrPullDown(
		AMenuBarPtrEntries(new)[(int)HelpButton]);
	helppushbutton.name = XmNmenuHelpWidget;
	helppushbutton.value = (XtArgVal)PullDownMenuEntryPtrWidget(pd);
	XtSetValues(AMenuBarPtrWidget(new), &helppushbutton, 1);

#else
	pb = (PushButtonEntryPtr)MenuEntryPtrPushButton(
		AMenuBarPtrEntries(new)[(int)HelpButton]);
	helppushbutton.name = XmNmenuHelpWidget;
	helppushbutton.value = (XtArgVal)PushButtonEntryPtrWidget(pb);
	XtSetValues(AMenuBarPtrWidget(new), &helppushbutton, 1);
#endif

	return new;
}
