/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * Revision 1.1  1995/03/07  23:15:38  bourquard
 * Original OSF sources
 *
 *
 * Revision 1.1.4.2  1993/06/25  16:58:56  Lynda_Rice
 * 	Motif 1.2 Support
 * 	[1993/06/24  20:23:16  Lynda_Rice]
 *
 * Revision 1.2  91/12/30  12:48:20  devbld
 * 	Initial load of project
 * 
 * Revision 1.1.2.2  1993/01/05  17:27:04  Don_Haney
 * 	Implement HyperHelp and mnemonics
 * 	[92/12/31  14:52:47  Don_Haney]
 * 
 * Revision 1.1.2.1  92/11/12  15:29:47  devrcs
 * 	Fix revision
 * 
 * Revision 1.1  90/01/01  00:00:00  devrcs
 * 	Initial load into Alpha pool
 * 
 */
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	menu.h - menu code
 *
 *	Author:	Laurence P. G. Cable
 *
 *	Created : 28th April 1988
 *
 *
 *	Description
 *	-----------
 *
 *
 *	Modification History
 *	------------ -------
 *	
 */

#ifndef	MENU_H
#define	MENU_H

#ifdef I18N_MULTIBYTE

/*******************************
 *
 * UI Label Declarations
 *
 *******************************/

/*******************************
 *
 * Main Menu Label Declarations
 *
 *******************************/

/* The following macros represent the array indexes for the main menu labels 
   defined in the array main_literal[]. Hence, their orders should be in sync
   with the array. */

#define 	FILEPULLDOWN            0
#define 	OPENFILES               1
#define 	VIEWNEXT                2
#define 	VIEWPREV                3
#define 	QUIT                    4
#define 	SEARCHPULLDOWN          5
#define 	SETRES                  6
#define 	FINDNEXT                7
#define 	FINDPREV                8
#define 	OPTIONSPULLDOWN         9
#define      	SLAVEVERTICAL           10
#define         SLAVEVERTICAL_ALT       11
#define         SLAVEHORIZONTAL         12
#define         SLAVEHORIZONTAL_ALT     13
#define         DRAWDIFFS               14
#define         DRAWDIFFS_ALT           15
#define         DRAWLINENUMBERS         16
#define         DRAWLINENUMBERS_ALT     17
#define 	DIFFERENCESPULLDOWN     18
#define         DODIFFERENCES           19
#define         DODIFFERENCESINNEW      20
#ifdef HYPERHELP
#define 	HELPPULLDOWN            21
#define         ONCONTEXT               22
#define         ONWINDOW                23
#define         ONHELP                  24
#define         ONVERSION               25

#define 	NUM_OF_MAIN_LABEL       26      /* Number of Main Menu Labels */
#else
#define 	HELP                    21

#define 	NUM_OF_MAIN_LABEL       22      /* Number of Main Menu Labels */
#endif HYPERHELP

/* The following array main_literal[] contains exported values defined in 
   DXdiff.uil. */

static char *main_literal[] = {
	"k_filespulldown",
	"k_openfiles",
	"k_viewnext",
	"k_viewprev",
	"k_quit",
	"k_searchpulldown",
	"k_setres",
	"k_findnext",
	"k_findprev",
	"k_optionspulldown",
	"k_slavevertical",
	"k_slavevertical_alt",
	"k_slavehorizontal",
	"k_slavehorizontal_alt",
	"k_drawdiffs",
	"k_drawdiffs_alt",
	"k_drawlinenumbers",
	"k_drawlinenumbers_alt",
	"k_differencespulldown",
	"k_dodifferences",
	"k_dodifferencesinnew",
#ifdef HYPERHELP
	"k_helppulldown",
	"k_oncontext",
	"k_onwindow",
	"k_onhelp",
	"k_onversion"
#else
	"k_help"
#endif HYPERHELP
};


XmString main_menu[NUM_OF_MAIN_LABEL];

/***************************************
 *
 * Display Menu Label Declarations
 *
 **************************************/

/* change to left and right button labels because they have
   different mnemonic */

/* The following macros are the array indexes for display_literal[]. 
   This array contains labels for left and right buttons. */

#define LEFT_NEXTDIFF                           0
#define LEFT_PREVDIFF                           1
#define RIGHT_NEXTDIFF                          2
#define RIGHT_PREVDIFF                          3
#define EDIT                                    4

#define NUM_OF_DISPLAY_LABEL    5       /* Number of Display Menu Labels */

static char *display_literal[] = {
	"k_left_nextdiff",
	"k_left_prevdiff",
	"k_right_nextdiff",
	"k_right_prevdiff",
	"k_edit"
};

XmString display_menu[NUM_OF_DISPLAY_LABEL];

#endif /* I18N_MULTIBYTE */

/*******************************
 *
 *	PushButtonEntry
 *
 ********************************/

typedef	enum	_labelactive	{
	NoLabel,
	MainLabel,
	AlternateLabel
} LabelActive;

typedef	struct	_pushbuttonentry {
	CoreArgList	core;
	LabelArgList	label;
	Arg		activatecallback;
#ifdef HYPERHELP
	Arg		contexthelp;
#endif
	Arg		mnemonic;
	Arg		accelerator;
	Arg		acceleratortext;
	Arg		sensitivity;
	FontArgList	font;			/* not used */

	Widget		w;
	char		*main,
			*alternative,
			*buttonname;

	LabelActive	currentlabel;

	XmString	maincs,
			alternativecs;
}	PushButtonEntry, *PushButtonEntryPtr;
	
#ifdef HYPERHELP

#define	InitPushButtonEntryPtrArgList(p)				\
					InitCoreArgList((p)->core);	\
					InitLabelArgList((p)->label);	\
					(p)->activatecallback.name = 	\
						XmNactivateCallback;	\
					(p)->contexthelp.name =		\
					        XmNhelpCallback;	\
					(p)->mnemonic.name =		\
					        XmNmnemonic;		\
					(p)->accelerator.name =		\
					        XmNaccelerator;		\
					(p)->acceleratortext.name =	\
					        XmNacceleratorText;	\
					(p)->sensitivity.name =		\
						XmNsensitive;		\
					InitFontArgList((p)->font)

#else

#define	InitPushButtonEntryPtrArgList(p)				\
					InitCoreArgList((p)->core);	\
					InitLabelArgList((p)->label);	\
					(p)->activatecallback.name = 	\
						XmNactivateCallback;	\
					(p)->mnemonic.name =		\
					        XmNmnemonic;		\
					(p)->accelerator.name =		\
					        XmNaccelerator;		\
					(p)->acceleratortext.name =	\
					        XmNacceleratorText;	\
					(p)->sensitivity.name =		\
						XmNsensitive;		\
					InitFontArgList((p)->font)

#endif

#define	InitPushButtonEntryArgList(p)	InitPushButtonEntryPtrArgList(&(p))

#define PushButtonEntryPtrCoreArgList(p)	((p)->core)
#define	PushButtonEntryCoreArgList(p)	PushButtonEntryPtrCoreArgList(&(p))

#define PushButtonEntryPtrLabelArgList(p)	((p)->label)
#define	PushButtonEntryLabelArgList(p)		\
					PushButtonEntryPtrLabelArgList(&(p))

#define	PushButtonEntryPtrActivateCallBack(p)	((p)->activatecallback.value)
#define	PushButtonEntryActivateCallBack(p)	\
					PushButtonEntryPtrActivateCallBack(&(p))

#define PushButtonEntryPtrContextHelp(p)	((p)->contexthelp.value)
#define	PushButtonEntryContextHelp(p)		\
					PushButtonEntryPtrContextHelp(&(p))

#define PushButtonEntryPtrMnemonic(p)		((p)->mnemonic.value)
#define	PushButtonEntryMnemonic(p)		\
					PushButtonEntryPtrMnemonic(&(p))

#define PushButtonEntryPtrAccelerator(p)	((p)->accelerator.value)
#define	PushButtonEntryAccelerator(p)		\
					PushButtonEntryPtrAccelerator(&(p))

#define PushButtonEntryPtrAcceleratorText(p)	((p)->acceleratortext.value)
#define	PushButtonEntryAcceleratorText(p)	\
					PushButtonEntryPtrAcceleratorText(&(p))

#define PushButtonEntryPtrSensitivity(p)	((p)->sensitivity.value)
#define	PushButtonEntrySensitivity(p)		\
					PushButtonEntryPtrSensitivity(&(p))

#define PushButtonEntryPtrFontArgList(p)	((p)->font)
#define	PushButtonEntryFontArgList(p)		\
					PushButtonEntryPtrFontArgList(&(p))

#define PushButtonEntryPtrWidget(p)	((p)->w)
#define	PushButtonEntryWidget(p)	PushButtonEntryPtrWidget(&(p))

#define PushButtonEntryPtrMainString(p)	((p)->main)
#define	PushButtonEntryMainString(p)	PushButtonEntryPtrMainString(&(p))

#define PushButtonEntryPtrMainCString(p)	((p)->maincs)
#define	PushButtonEntryMainCString(p)	PushButtonEntryPtrMainCString(&(p))


#define PushButtonEntryPtrAlternativeString(p)	((p)->alternative)
#define	PushButtonEntryAlternativeString(p)	\
				PushButtonEntryPtrAlternativeString(&(p))

#define PushButtonEntryPtrAlternativeCString(p)	((p)->alternativecs)
#define	PushButtonEntryAlternativeCString(p)	\
				PushButtonEntryPtrAlternativeCString(&(p))


#define PushButtonEntryPtrButtonName(p)	((p)->buttonname)
#define	PushButtonEntryButtonName(p)	PushButtonEntryPtrButtonName(&(p))

#define PushButtonEntryPtrCurrentLabel(p)	((p)->currentlabel)
#define	PushButtonEntryCurrentLabel(p)	PushButtonEntryPtrCurrentLabel(&(p))


#define	StaticInitPushButtonEntryActivateCallBack(cb)	\
	{ XmNactivateCallback, (cb) }

#define	StaticInitPushButtonEntryContextHelp(sn)	\
	{ XmNhelpCallback, (sn) }

#define	StaticInitPushButtonEntryMnemonic(sn)		\
	{ XmNmnemonic, (sn) }

#define	StaticInitPushButtonEntryAccelerator(s)	\
	{ XmNaccelerator, (XtArgVal)(s) }

#define	StaticInitPushButtonEntryAcceleratorText(s)	\
	{ XmNacceleratorText, (XtArgVal)(s) }

#define	StaticInitPushButtonEntrySensitivity(sn)	\
	{ XmNsensitive, (sn) }

#define	StaticInitPushButtonEntryWidget(w)		(w)
#define	StaticInitPushButtonEntryMainString(s)		(s)
#define	StaticInitPushButtonEntryAlternativeString(s)	(s)
#define	StaticInitPushButtonEntryMainCString(s)		(s)
#define	StaticInitPushButtonEntryAlternativeCString(s)	(s)
#define	StaticInitPushButtonEntryButtonName(s)		(s)
#define	StaticInitPushButtonEntryCurrentLabel(s)	(s)

/********************************
 *
 *	PullDownMenuEntry
 *
 ********************************/

typedef	struct	_pulldownmenuentry {
	CoreArgList		core;

	Widget			w;
	char			*menuname;
	unsigned int		numbuttons;
	PushButtonEntryPtr	*pushbuttons;
} PullDownMenuEntry, *PullDownMenuEntryPtr;

#define	InitPullDownMenuEntryPtrArgList(p) 	InitCoreArgList((p)->core)
#define	InitPullDownMenuEntryArgList(p)		\
					InitPullDownMenuEntryPtrArgList(&(p))

#define	PullDownMenuEntryPtrCoreArgList(p)	((p)->core)
#define	PullDownMenuEntryCoreArgList(p)		\
					PullDownMenuEntryPtrCoreArgList(&(p))

#define	PullDownMenuEntryPtrWidget(p)		((p)->w)
#define	PullDownMenuEntryWidget(p)		PullDownMenuEntryPtrWidget(&(p))

#define	PullDownMenuEntryPtrMenuName(p)		((p)->menuname)
#define	PullDownMenuEntryMenuName(p)		PullDownMenuEntryPtrMenuName(&(p))

#define	PullDownMenuEntryPtrNumButtons(p)	((p)->numbuttons)
#define	PullDownMenuEntryNumButtons(p)	\
					PullDownMenuEntryPtrNumButtons(&(p))

#define	PullDownMenuEntryPtrPushButtons(p)	((p)->pushbuttons)
#define	PullDownMenuEntryPushButtons(p)	\
					PullDownMenuEntryPtrPushButtons(&(p))


#define	StaticInitPullDownMenuEntryWidget(w)		(w)
#define	StaticInitPullDownMenuEntryMenuName(s)		(s)
#define	StaticInitPullDownMenuEntryNumButtons(n)	(n)
#define	StaticInitPullDownMenuEntryPushButtons(pb)	(pb)

/********************************
 *
 *	PullDownEntry
 *
 ********************************/

typedef	struct	_pulldownentry {
	CoreArgList		core;
	LabelArgList		label;
	Arg			submenuwidget;
	Arg			pulldowncallback;
#ifdef HYPERHELP
	Arg			contexthelp;
#endif
	Arg		mnemonic;
	Arg			sensitivity;
	FontArgList		font;		/* not used */
	

	Widget			w,
				submenuparent;	
	char 			*entryname,
				*main;
	PullDownMenuEntryPtr	pulldownmenuentry;
	XmString		maincs;
} PullDownEntry, *PullDownEntryPtr;

#ifdef HYPERHELP

#define	InitPullDownEntryPtrArgList(p)					 \
			InitCoreArgList((p)->core);			 \
			InitLabelArgList((p)->label);			 \
			(p)->submenuwidget.name = XmNsubMenuId;	 \
			(p)->pulldowncallback.name = XmNcascadingCallback; \
			(p)->contexthelp.name = XmNhelpCallback;	 \
			(p)->mnemonic.name = XmNmnemonic;		 \
			(p)->sensitivity.name = XmNsensitive;		 \
			InitFontArgList((p)->font)
#else

#define	InitPullDownEntryPtrArgList(p)					 \
			InitCoreArgList((p)->core);			 \
			InitLabelArgList((p)->label);			 \
			(p)->submenuwidget.name = XmNsubMenuId;	 \
			(p)->pulldowncallback.name = XmNcascadingCallback; \
			(p)->mnemonic.name = XmNmnemonic;		 \
			(p)->sensitivity.name = XmNsensitive;		 \
			InitFontArgList((p)->font)
#endif

#define	InitPullDownEntryArgList(p)	InitPullDownEntryPtrArgList(&(p))

#define	PullDownEntryPtrCoreArgList(p)	((p)->core)

/* The following I18N changes fix missing parentheses */
#ifdef I18N_BUG_FIX
#define PullDownEntryCoreArgList(p)     PullDownEntryPtrCoreArgList(&(p))
#else
#define	PullDownEntryCoreArgList(p)	PullDownEntryPtrCoreArgList(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrLabelArgList(p)	((p)->label)
#ifdef I18N_BUG_FIX
#define PullDownEntryLabelArgList(p)    PullDownEntryPtrLabelArgList(&(p))
#else
#define	PullDownEntryLabelArgList(p)	PullDownEntryPtrLabelArgList(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrSubMenuWidget(p)	((p)->submenuwidget.value)
#define	PullDownEntrySubMenuWidget(p)		\
				PullDownEntryPtrSubMenuWidget(&(p))

#define	PullDownEntryPtrPullDownCallBack(p)	((p)->pulldowncallback.value)
#ifdef I18N_BUG_FIX
#define PullDownEntryPullDownCallBack(p)        \
				PullDownEntryPtrPullDownCallBack(&(p))
#else
#define	PullDownEntryPullDownCallBack(p)	\
				PullDownEntryPtrPullDownCallBack(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrContextHelp(p)	((p)->contexthelp.value)
#ifdef I18N_BUG_FIX
#define PullDownEntryContextHelp(p)     PullDownEntryPtrContextHelp(&(p))
#else
#define	PullDownEntryContextHelp(p)	PullDownEntryPtrContextHelp(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrMnemonic(p)	((p)->mnemonic.value)
#ifdef I18N_BUG_FIX
#define PullDownEntryMnemonic(p)        PullDownEntryPtrMnemonic(&(p))
#else
#define	PullDownEntryMnemonic(p)	PullDownEntryPtrMnemonic(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrSensitivity(p)	((p)->sensitivity.value)
#ifdef I18N_BUG_FIX
#define PullDownEntrySensitivity(p)     PullDownEntryPtrSensitivity(&(p))
#else
#define	PullDownEntrySensitivity(p)	PullDownEntryPtrSensitivity(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrFontArgList(p)	((p)->font)
#ifdef I18N_BUG_FIX
#define PullDownEntryFontArgList(p)     PullDownEntryPtrFontArgList(&(p))
#else
#define	PullDownEntryFontArgList(p)	PullDownEntryPtrFontArgList(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrWidget(p)	((p)->w)
#ifdef I18N_BUG_FIX
#define PullDownEntryWidget(p)          PullDownEntryPtrWidget(&(p))
#else
#define	PullDownEntryWidget(p)		PullDownEntryPtrWidget(&p))
#endif /* I18N_BUG_FIX */
#define	PullDownEntryPtrSubMenuParent(p)	((p)->submenuparent)
#ifdef I18N_BUG_FIX
#define PullDownEntrySubMenuParent(p)           \
				PullDownEntryPtrSubMenuParent(&(p))
#else
#define	PullDownEntrySubMenuParent(p)		\
				PullDownEntryPtrSubMenuParent(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrMainString(p)	((p)->main)
#ifdef I18N_BUG_FIX
#define PullDownEntryMainString(p)      PullDownEntryPtrMainString(&(p))
#else
#define	PullDownEntryMainString(p)	PullDownEntryPtrMainString(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrMainCString(p)	((p)->maincs)
#ifdef I18N_BUG_FIX
#define PullDownEntryMainCString(p)     PullDownEntryPtrMainCString(&(p))
#else
#define	PullDownEntryMainCString(p)	PullDownEntryPtrMainCString(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrEntryName(p)	((p)->entryname)
#ifdef I18N_BUG_FIX
#define PullDownEntryEntryName(p)       PullDownEntryPtrEntryName(&(p))
#else
#define	PullDownEntryEntryName(p)	PullDownEntryPtrEntryName(&p))
#endif /* I18N_BUG_FIX */

#define	PullDownEntryPtrPullDownMenuEntry(p)	((p)->pulldownmenuentry)
#define	PullDownEntryPullDownMenuEntry(p)		\
				PullDownEntryPullDownMenuEntry(&(p))

#define	StaticInitPullDownEntrySubMenuWidget(w)		{ XmNsubMenuId, (w) }
#define	StaticInitPullDownEntryPullDownCallBack(w)	{ XmNcascadingCallback, (w) }
#define	StaticInitPullDownEntryContextHelp(s)		{ XmNhelpCallback, (s) }
#define	StaticInitPullDownEntryMnemonic(s)		{ XmNmnemonic, (s) }
#define	StaticInitPullDownEntrySensitivity(s)		{ XmNsensitive, (s) }
#define	StaticInitPullDownEntryWidget(w)		(w)
#define	StaticInitPullDownEntrySubMenuParent(w)		(w)
#define	StaticInitPullDownEntryMainString(s)		(s)
#define	StaticInitPullDownEntryMainCString(s)		(s)
#define	StaticInitPullDownEntryEntryName(s)		(s)
#define	StaticInitPullDownEntryPullDownMenuEntry(e)	(e)

/********************************
 *
 *	MenuEntry
 *
 ********************************/

typedef	enum 	_menuentryenum {
	EntryIsPushButton,
	EntryIsPullDown,
	EntryIsCascadeButton
} MenuEntryEnum;

typedef	union _pushbuttonorpulldown {
	PushButtonEntry	pushbutton;
	PullDownEntry	pulldown;
} *PushButtonOrPullDownPtr;

typedef	struct	_menuentry {
	MenuEntryEnum		type;
	PushButtonOrPullDownPtr	entry;
} MenuEntry, *MenuEntryPtr;

#define	MenuEntryType(p)	MenuEntryPtrType(&(p))
#define	MenuEntryPtrType(p)	((p)->type)

#define	MenuEntryPullDown(p)	MenuEntryPtrPullDown(&(p))
#define	MenuEntryPtrPullDown(p)	((p)->entry)

#define	MenuEntryPushButton(p)		MenuEntryPtrPushButton(&(p))
#define	MenuEntryPtrPushButton(p)	((p)->entry)

#define	MenuEntryPullDownEntryPtr(p)	\
					MenuEntryPtrPullDownEntryPtr(&(p))
#define	MenuEntryPtrPullDownEntryPtr(p)		(&((p)->entry->pulldown))

#define	MenuEntryPushButtonEntryPtr(p)	\
					MenuEntryPtrPushButtonEntryPtr(&(p))
#define	MenuEntryPtrPushButtonEntryPtr(p)	(&((p)->entry->pushbutton))

#define	StaticInitMenuEntryType(t)	(t)
#define	StaticInitMenuEntryEntry(e)	(e)

#define	StaticInitMenuEntryPushButton(pb)				\
	{								\
		StaticInitMenuEntryType(EntryIsPushButton),		\
		StaticInitMenuEntryEntry((PushButtonOrPullDownPtr)&(pb))	\
	}

#define	StaticInitMenuEntryPullDown(pd)					\
	{								\
		StaticInitMenuEntryType(EntryIsPullDown),		\
		StaticInitMenuEntryEntry((PushButtonOrPullDownPtr)&(pd))	\
	}



/********************************
 *
 *	AMenuBar
 *
 ********************************/

typedef	struct	_amenubar	{
	CoreArgList		core;
	ADBConstraintArgList	constraints;
	MenuBarArgList		menubar;

	Widget			w;
	char			*menuname;
	unsigned int		numentries;
	MenuEntryPtr		*entries;
} AMenuBar, *AMenuBarPtr;

#define	InitAMenuBarPtrArgList(p)				   \
			InitCoreArgList((p)->core);	   	   \
			InitADBConstraintArgList((p)->constraints);\
			InitMenuBarArgList((p)->menubar)

#define	InitAMenuBarArgList(p)	InitAMenuBarPtrArgList(&(p))

#define	AMenuBarPtrCoreArgList(p)	((p)->core)
#define	AMenuBarCoreArgList(p)		AMenuBarPtrCoreArgList(&(p))

#define	AMenuBarPtrConstraintArgList(p)	((p)->constraints)
#define	AMenuBarConstraintArgList(p)	AMenuBarPtrConstraintArgList(&(p))

#define	AMenuBarPtrMenuBarArgList(p)	((p)->menubar)
#define	AMenuBarMenuBarArgList(p)	AMenuBarPtrMenuBarArgList(&(p))

#define	AMenuBarPtrWidget(p)	((p)->w)
#define	AMenuBarWidget(p)	AMenuBarPtrWidget(&(p))

#define	AMenuBarPtrMenuName(p)	((p)->menuname)
#define	AMenuBarMenuName(p)	AMenuBarPtrMenuName(&(p))

#define	AMenuBarPtrNumEntries(p)	((p)->numentries)
#define	AMenuBarNumEntries(p)		AMenuBarPtrNuNummEntries(&(p))

#define	AMenuBarPtrEntries(p)	((p)->entries)
#define	AMenuBarEntries(p)	AMenuBarPtrEntries(&(p))

#define	StaticInitAMenuBarWidget(w)		(w)
#define	StaticInitAMenuBarMenuName(s)		(s)
#define	StaticInitAMenuBarNumEntries(n)		(n)
#define	StaticInitAMenuBarEntries(e)		(e)

#endif	MENU_H
