/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * Revision 1.2  1995/03/09  21:52:20  bourquard
 * port to NT .
 *
 * Revision 1.1.4.2  1994/04/08  19:06:23  Susan_Ng
 * 	code drop for post-Sterling fixes/I18N changes
 * 	[1994/04/07  18:20:22  Susan_Ng]
 *
 * Revision 2.0.1.3  1993/11/18  08:49:58  uwsmw
 * 	add I18N comments
 * 
 * Revision 2.0.1.2  1993/09/28  02:25:20  uwsmw
 * 	I18N changes for BL6
 * 
 * Revision 1.1.2.3  92/11/25  08:10:33  Russ_Kuhn
 * 	Changed message dialog in CreateMessageBox() to error dialog
 * 	Added a little offset in the label to enhance readability
 * 	[92/11/25  08:08:52  Russ_Kuhn]
 * 
 * Revision 1.1.2.2  92/08/03  09:49:16  Dave_Hill
 * 	initial port to alpha
 * 	[92/08/03  09:39:04  Dave_Hill]
 * 
 * Revision 1.1  90/01/01  00:00:00  devrcs
 * 	Initial load into Alpha pool
 * 
 * Revision 1.2  91/12/30  12:48:20  devbld
 * 	Initial load of project
 * 
 */
#ifndef lint	/* BuildSystemHeader added automatically */
static char *BuildSystemHeader= "$Id: message.c,v 1.3 1995/03/10 18:06:25 bourquard Exp $";
#endif		/* BuildSystemHeader */
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	message.c - message box handling
 *
 *	Author:	Laurence P. G. Cable
 *
 *	Created : 4th July 1988
 *
 *
 *	Description
 *	-----------
 *
 *
 *	Modification History
 *	------------ -------
 *	
 */



#include <sys/types.h>
#include <sys/stat.h>

#ifdef  DEBUG
#include <stdio.h>
#endif  DEBUG
#include <X11/Xlib.h>
#ifdef WIN32
#include <X11/xfuncs.h>
#endif WIN32
#include <Xm/Xm.h>
#include "dxdiff.h"
#include "arglists.h"
#include "y.tab.h"
#include "filestuff.h"
#include "parsediff.h"
#include "alloc.h"
#include "differencebox.h"
#include "menu.h"
#include "text.h"
#include "display.h"


/********************************
 *
 *	MessageBoxDestroyCallback
 *
 ********************************/

static void
MessageBoxDestroyCallback(w, clientd, calld)
	Widget	w;
	caddr_t	clientd,
		calld;
{
	register MessageBoxPtr messagebox = (MessageBoxPtr)clientd;

	if (LabelLabel(MessageBoxPtrLabelArgList(messagebox)) != NULL) {
#ifdef I18N_MULTIBYTE
		XmStringFree(LabelLabel(MessageBoxPtrLabelArgList(messagebox)));;
#else
		XtFree((char *)LabelLabel(MessageBoxPtrLabelArgList(messagebox)));
#endif /* I18N_MULTIBYTE */
	}

	XtFree((char *)messagebox);
}


static XtCallbackRec	messageboxdestroycallbacklist[] = {
	{ (VoidProc)MessageBoxDestroyCallback, NULL },
	{ (VoidProc)NULL, NULL }
};

/********************************
 *
 *	MessageBoxActivateCallback
 *
 ********************************/

static void
MessageBoxActivateCallback(w, clientd, calld)	/* the default one !!!! */
	Widget	w;
	caddr_t	clientd,
		calld;
{
	register MessageBoxPtr messagebox = (MessageBoxPtr)clientd;

	XtDestroyWidget(MessageBoxPtrWidget(messagebox));	/* throw it away */
}

static XtCallbackRec	messageboxactivatecallbacklist[] = {
	{ (VoidProc)MessageBoxActivateCallback, NULL },
	{ (VoidProc)NULL, NULL }
};

/********************************
 *
 *	SetMessageBoxMessage
 *
 ********************************/

void 
SetMessageBoxMessage(messagebox, message)
	register MessageBoxPtr messagebox;
#ifdef I18N_MULTIBYTE
	XmString               message;
#else
	char		       *message;
#endif /* I18N_MULTIBYTE */
{
	if (LabelLabel(MessageBoxPtrLabelArgList(messagebox)) != NULL) {
#ifdef I18N_MULTIBYTE
		XmStringFree(LabelLabel(MessageBoxPtrLabelArgList(messagebox)));;
#else
		XtFree((char *)LabelLabel(MessageBoxPtrLabelArgList(messagebox)));
#endif  /* I18N_MULTIBYTE */
	}

#ifdef I18N_MULTIBYTE
	if (message != (XmString) NULL) {
		LabelLabel(MessageBoxPtrLabelArgList(messagebox)) = (XtArgVal)
		XmStringCopy(message);
#else
	if (message != (char *)NULL) {
		LabelLabel(MessageBoxPtrLabelArgList(messagebox)) = (XtArgVal)
		XmStringLtoRCreate(message , "ISO8859-1");
#endif /* I18N_MULTIBYTE */
		XtSetValues(MessageBoxPtrWidget(messagebox),
			    PointerToArg(LabelLabel(MessageBoxPtrLabelArgList(messagebox))),
			    1
		);
	}
}

/********************************
 *
 *	NewMessageBox
 *
 ********************************/

static MessageBoxPtr
NewMessageBox(copy)
	register MessageBoxPtr copy;
{
	register MessageBoxPtr new;

	if ((new = (MessageBoxPtr)XtMalloc(sizeof (MessageBox))) == (MessageBoxPtr)NULL) {
		return (MessageBoxPtr)NULL;	/* error */
	}

	if (copy != (MessageBoxPtr)NULL)
		bcopy((char*)copy, (char *)new, sizeof (MessageBox));

	return new;
}

/********************************
 *
 *	CreateMessageBox
 *
 ********************************/

static MessageBox messagebox = {
	StaticInitCoreArgList(0, 0, 0, 0, 0, (XtArgVal)messageboxdestroycallbacklist),
	StaticInitDialogBoxArgList(XmPIXELS, XmSTRING, NULL, 
	    XmDIALOG_APPLICATION_MODAL, XmRESIZE_ANY, True, 0, 0),
	StaticInitLabelArgList(XmSTRING, NULL, 10, 10, XmALIGNMENT_CENTER, 2, 2, 2, 2, True, False),
	{ XmNdefaultPosition, True },
	{ XmNactivateCallback, (XtArgVal)messageboxactivatecallbacklist },
	NULL,
	NULL
};

MessageBoxPtr
CreateMessageBox(parent, name, core, dialog, label, message, activateproc, closure)
	Widget			parent;
	char			*name;
	CoreArgListPtr		core;
	DialogBoxArgListPtr	dialog;
	LabelArgListPtr		label;
#ifdef I18N_MULTIBYTE
	XmString                message;
#else
	char			*message;
#endif  /* I18N_MULTIBYTE */
	void			(*activateproc)();
	caddr_t			closure;
{
	register MessageBoxPtr new;
#ifdef I18N_MULTIBYTE
	MrmCode type;
#endif /* I18N_MULTIBYTE */

	if ((new = NewMessageBox(&messagebox)) == (MessageBoxPtr)NULL) {
		return (MessageBoxPtr)NULL;	/* error */
	}


	if (core != (CoreArgListPtr)NULL) {
		bcopy((char *)core, (char *)&MessageBoxPtrCoreArgList(new), sizeof (CoreArgList) - 
		      sizeof (Arg));
	}

	if (dialog != (DialogBoxArgListPtr)NULL) {
		bcopy((char *)dialog, (char *)&MessageBoxPtrDialogBoxArgList(new), sizeof (DialogBoxArgList));
	}

	if (label != (LabelArgListPtr)NULL) {
		bcopy((char *)label, (char *)&MessageBoxPtrLabelArgList(new), sizeof (LabelArgList));
	}

	DialogBoxStyle(MessageBoxPtrDialogBoxArgList(new)) = 
		XmDIALOG_APPLICATION_MODAL;

#ifdef I18N_MULTIBYTE
	(&MessageBoxPtrDialogBoxArgList(new))->title.name = XmNdialogTitle;
	MrmFetchLiteral(dxdiff_hierarchy, "k_error_title",
		XtDisplay(toplevel),
		&DialogBoxTitle(MessageBoxPtrDialogBoxArgList(new)),
		&type);
#else
	DialogBoxTitle(MessageBoxPtrDialogBoxArgList(new)) = (XtArgVal)"dxdiff: message";
#endif /* I18N_MULTIBYTE */

	(&MessageBoxPtrLabelArgList(new))->label.name = XmNmessageString;
#ifdef I18N_MULTIBYTE
	if (message != (XmString) NULL) {
		LabelLabel(MessageBoxPtrLabelArgList(new)) = (XtArgVal)message;
#else
	if (message != (char *)NULL) {
		LabelLabel(MessageBoxPtrLabelArgList(new)) = (XtArgVal)
		XmStringLtoRCreate(message , "ISO8859-1");
#endif  /* I18N_MULTIBYTE */
	}

	messageboxdestroycallbacklist[0].closure = messageboxactivatecallbacklist[0].closure = new;

	if (activateproc != (void (*)())NULL) {
		MessageBoxPtrActivateCallBack(new) = (int)activateproc;
	}

	MessageBoxPtrClosure(new) = (caddr_t)closure;	/* the display  ??? */


	MessageBoxPtrWidget(new) = (Widget)XmCreateErrorDialog(parent,
							   name,
							   &MessageBoxPtrCoreArgList(new),
						 	   NumberOfArgsBetween(&MessageBoxPtrCoreArgList(new),
							   &MessageBoxPtrActivateCallBack(new)));

	if (MessageBoxPtrWidget(new) == (Widget)NULL) {
             return (MessageBoxPtr)NULL;   /* error */
        }

	XtUnmanageChild((Widget)XmMessageBoxGetChild(MessageBoxPtrWidget(new),
			XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild((Widget)XmMessageBoxGetChild(MessageBoxPtrWidget(new),
			XmDIALOG_HELP_BUTTON));
	XtManageChild((Widget)MessageBoxPtrWidget(new));

	return new;
}
