#ifndef lint
char yysccsid[] = "@(#)yaccpar	1.4 (Berkeley) 02/25/90";
#endif
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  
 * 
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	parsediffy.y - yacc parser for diff input
 *
 *	Author: Laurence P. G. Cable
 *
 *	Created : 3rd March 1988
 *
 *
 *	Description
 *	-----------
 *
 *	This yacc description file is used to create an syntax analyser
 *	to parse the output from diff. 
 *
 *	Modification History
 *	------------ -------
 *	
 *	31st March		Laurence P. G. Cable
 *
 *	Changed the number_sequence rule to reflect changes to the 
 *	NumberSequence Data structure ..... now NumberSequences of 1
 *	have the howmany field set to 1 but the 2nd number now == the 1st
 *
 *	21st April		Laurence P. G. Cable
 *
 *	Added discard_diffs support
 *
 *	
 *	25th April 1988		Laurnce P. G. Cable
 *
 *	Added support for collection of stats & init HighLightInfoPtrs in
 *	struct _edc to NULL
 *
 *	06 Aug 1990		Colin Prosser
 *
 *	Fix storage allocation bugs and portability problems.
 *	Cures seg fault reported in UWS QAR 02624.
 */

static char sccsid[] = "@(#)parsediffy.y	2.2";
#include <stdio.h>
#include <assert.h>

#include <X11//Xlib.h>
#ifdef WIN32
#include <X11//xfuncs.h>
#define yyerror printf      /* Deb's hack */
#endif
#include <Xm//Xm.h>
#ifdef I18N_MULTIBYTE
#include <DXm//DXmCSText.h>
#endif /* I18N_MULTIBYTE */

#include "dxdiff.h"
#include "filestuff.h"

#ifdef WIN32
#include "y.tab.h"
#endif				/* end ifdef WIN32 */

#include "parsediff.h"
#include "alloc.h"

#if	YACCDEBUG
#define	NDEBUG	/* for the assert */
#endif


#if	YACCDEBUG

int yaccdebug = 1; /***** REMOVE THIS LATER *****/
#ifdef WIN32
int debug;
#else
extern int debug;
#endif WIN32

#define	DEBUGMSG(x)	\
	if (debug || yaccdebug) {	\
		printf(x);		\
	}

#define	DEBUGMSG1(x,y)	\
	if (debug || yaccdebug) {	\
		printf(x,y);		\
	}

#endif	YACCDEBUG



/* vars used to create chains */

/* used to chain diff's onto edit cmd nodes */

static	DflPtr	*dfl1ptr,dfl1tail;
static	DflPtr	*dfl2ptr,dfl2tail;

static  unsigned int serial = 0;

static DiffListBlk dlb;

static	BfnPtr		*bfnptr;
static	CfnPtr		*cfnptr;
static	IfnPtr		*ifnptr;
static	OfnPtr		*ofnptr;
static	DcnPtr		*dcnptr;
static	DenPtr		*denptr;
static	EdcPtr		*edcptr;
static	DflPtr		*dflptr;
static	NodeCommonPtr	*ncpptr;

#define	ChainNodeInstance(np,pptr,last)	(np)->prev = (last);		\
					*(pptr) = (last) = (np);	\
					(pptr) = &((np)->next)

#define	ChainNodeCommonInstance(np)	(np)->common.prev = (NodePtr)dlb.nptail;	\
					(np)->common.serial = serial++;	\
					*ncpptr = dlb.nptail = 		\
						(NodeCommonPtr)(np);	\
					ncpptr = (NodeCommonPtr *)&((np)->common.next)
					

StoreCachePtr	nssc;
StoreCachePtr	edcsc;
StoreCachePtr	dflsc;
StoreCachePtr	bfnsc;
StoreCachePtr	cfnsc;
StoreCachePtr	ofnsc;
StoreCachePtr	ifnsc;
StoreCachePtr	densc;
StoreCachePtr	dcnsc;

#define YY_DIFF_CMD_LINE 257
#define YY_DIFF_ERROR 258
#define YY_COMMON_NOTIFICATION 259
#define YY_BINARY_NOTIFICATION 260
#define YY_FILES_NOTIFICATION 261
#define YY_ONLY_NOTIFICATION 262
#define YY_DIFF_IN_1_AND_NOT_2 263
#define YY_DIFF_IN_2_AND_NOT_1 264
#define YY_STRING 265
#define YY_APPEND_CMD 266
#define YY_CHANGE_CMD 267
#define YY_DELETE_CMD 268
#define YY_COMMA 269
#define YY_LINE_NUMBER 270
#define YY_PATHNAME 271
#define YY_EOLN 272
#define YY_SEP 273
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    1,    1,    2,    2,    2,   10,   11,   12,   13,   13,
   15,   15,   14,   14,   14,    3,    3,    5,    6,    4,
    7,    7,    8,    9,
};
short yylen[] = {                                         2,
    0,    2,    3,    3,    3,    3,    3,    3,    2,    3,
    1,    3,    1,    1,    1,    4,    3,    3,    2,    1,
    2,    1,    3,    1,    1,    1,    2,    3,    3,    3,
    3,    2,    3,    2,
};
short yydefred[] = {                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    9,
    0,    2,    0,    0,    0,    0,    0,    0,    0,   10,
    0,   34,    0,    0,    0,    0,    0,   13,   15,   14,
    0,    3,    4,    5,    6,    7,    8,    0,    0,    0,
    0,    0,   27,   25,   33,   30,   28,   29,   31,   12,
    0,    0,    0,   19,   21,    0,   16,   17,   18,   23,
};
short yydgoto[] = {                                       1,
   11,   31,   12,   13,   14,   15,   16,   17,   18,   19,
   40,   41,   42,   43,   44,
};
short yysindex[] = {                                      0,
 -247, -272, -244, -241, -243, -242, -240, -239, -262,    0,
 -264,    0, -251, -238, -237, -236, -235, -234, -258,    0,
 -232,    0, -231, -230, -229, -228, -226,    0,    0,    0,
 -225,    0,    0,    0,    0,    0,    0, -219, -218, -258,
 -258, -224,    0,    0,    0,    0,    0,    0,    0,    0,
 -222, -221, -220,    0,    0, -216,    0,    0,    0,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0, -250,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   26,    0,
    0,    0,    0,    0,    0, -251,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,
    8,   33,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
   -1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -21,   -3,
};
#define YYTABLESIZE 305
short yytable[] = {                                      20,
   20,   28,   29,   30,   38,   39,   27,   22,    2,    3,
    4,    5,    6,    7,    8,   11,   11,   11,   54,   55,
   32,   11,    9,   22,   10,   26,   21,   23,   24,   51,
   25,   26,   24,   33,   34,   35,   36,   37,   45,   46,
   47,   48,   49,   50,    9,   52,   53,   39,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   20,   20,   20,   20,
   20,   20,   20,   22,   22,   22,   22,   22,   22,   22,
   20,    0,   20,   20,    0,    0,    0,   22,    0,   22,
   22,   26,   26,   26,   26,   26,   26,   26,   24,   24,
   24,   24,   24,   24,   24,   26,    0,   26,    0,    0,
    0,    0,   24,    0,   24,
};
short yycheck[] = {                                     272,
    0,  266,  267,  268,  263,  264,  269,    0,  256,  257,
  258,  259,  260,  261,  262,  266,  267,  268,   40,   41,
  272,  272,  270,  265,  272,    0,  271,  271,  271,   31,
  271,  271,    0,  272,  272,  272,  272,  272,  271,  271,
  271,  271,  271,  270,  270,  265,  265,  264,  273,  272,
  272,  272,   56,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,
  260,  261,  262,  256,  257,  258,  259,  260,  261,  262,
  270,   -1,  272,  273,   -1,   -1,   -1,  270,   -1,  272,
  273,  256,  257,  258,  259,  260,  261,  262,  256,  257,
  258,  259,  260,  261,  262,  270,   -1,  272,   -1,   -1,
   -1,   -1,  270,   -1,  272,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 273
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"YY_DIFF_CMD_LINE",
"YY_DIFF_ERROR","YY_COMMON_NOTIFICATION","YY_BINARY_NOTIFICATION",
"YY_FILES_NOTIFICATION","YY_ONLY_NOTIFICATION","YY_DIFF_IN_1_AND_NOT_2",
"YY_DIFF_IN_2_AND_NOT_1","YY_STRING","YY_APPEND_CMD","YY_CHANGE_CMD",
"YY_DELETE_CMD","YY_COMMA","YY_LINE_NUMBER","YY_PATHNAME","YY_EOLN","YY_SEP",
};
char *yyrule[] = {
"$accept : diff_output",
"diff_output :",
"diff_output : diff_output an_edit_context",
"diff_output : diff_output common_files_notification YY_EOLN",
"diff_output : diff_output binary_files_notification YY_EOLN",
"diff_output : diff_output identical_files_notification YY_EOLN",
"diff_output : diff_output only_in_one_notification YY_EOLN",
"diff_output : diff_output diff_command_notification YY_EOLN",
"diff_output : diff_output diff_error_notification YY_EOLN",
"diff_output : diff_output YY_EOLN",
"diff_output : diff_output error YY_EOLN",
"number_sequence : YY_LINE_NUMBER",
"number_sequence : YY_LINE_NUMBER YY_COMMA YY_LINE_NUMBER",
"edit_cmd : YY_APPEND_CMD",
"edit_cmd : YY_DELETE_CMD",
"edit_cmd : YY_CHANGE_CMD",
"an_edit_cmd : number_sequence edit_cmd number_sequence YY_EOLN",
"difference1_line : YY_DIFF_IN_1_AND_NOT_2 YY_STRING YY_EOLN",
"difference2_line : YY_DIFF_IN_2_AND_NOT_1 YY_STRING YY_EOLN",
"list_of_1differences : difference1_line list_of_differences",
"list_of_1differences : difference1_line",
"list_of_2differences : difference2_line list_of_differences",
"list_of_2differences : difference2_line",
"list_of_differences : list_of_1differences YY_SEP list_of_2differences",
"list_of_differences : list_of_1differences",
"list_of_differences : list_of_2differences",
"an_edit_context : an_edit_cmd",
"an_edit_context : an_edit_cmd list_of_differences",
"binary_files_notification : YY_BINARY_NOTIFICATION YY_PATHNAME YY_PATHNAME",
"identical_files_notification : YY_FILES_NOTIFICATION YY_PATHNAME YY_PATHNAME",
"common_files_notification : YY_COMMON_NOTIFICATION YY_PATHNAME YY_PATHNAME",
"only_in_one_notification : YY_ONLY_NOTIFICATION YY_PATHNAME YY_PATHNAME",
"only_in_one_notification : YY_ONLY_NOTIFICATION YY_PATHNAME",
"diff_command_notification : YY_DIFF_CMD_LINE YY_PATHNAME YY_PATHNAME",
"diff_error_notification : YY_DIFF_ERROR YY_STRING",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifndef YYSTACKSIZE
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 300
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
#define yystacksize YYSTACKSIZE
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];


/*
 * Note: ptrs in *dlbp MUST be set to NULL on entry !!!!
 */

parsediff(dlbp)
	DiffListBlkPtr	dlbp;
{
	int	     ret;

/*
	assert((char *)&nptail - (char *)&bfnhead != sizeof (DiffListBlk));
*/
	
	/*
	 *	this next bit is tacky, but quick
	 *
	 *	copy the (zeroed) DiffListBlk into the static head
	 * 	and tail pointers at the begining of this file
	 *	also init the stats counters at the end ....
	 */

	bcopy((char *)dlbp, (char *)&dlb, sizeof (DiffListBlk) - sizeof (dlbp->caches));

	/*
	 *	now initialise the indirect pointers to point to the
	 *	static 'head' variables
	 *
	 */
	bfnptr = &dlb.bfnhead;
	cfnptr = &dlb.cfnhead;
	ifnptr = &dlb.ifnhead;
	ofnptr = &dlb.ofnhead;
	dcnptr = &dlb.dcnhead;
	denptr = &dlb.denhead;
	edcptr = &dlb.edchead;
	dflptr = &dlb.dflhead;
	ncpptr = &dlb.nphead;
		     
	FreeBackEndStore(dlbp->caches);

	nssc =  &dlbp->caches->nssc;
	edcsc = &dlbp->caches->edcsc;
	dflsc = &dlbp->caches->dflsc;
	bfnsc = &dlbp->caches->bfnsc;
	cfnsc = &dlbp->caches->cfnsc;
	ofnsc = &dlbp->caches->ofnsc;
	ifnsc = &dlbp->caches->ifnsc;
	densc = &dlbp->caches->densc;
	dcnsc = &dlbp->caches->dcnsc;

	/* parse the input */

	serial = 1;
	ret = yyparse();

	dlbp->caches->cachesempty = False;

	/*
	 * and use this nasty copy technique to return the created
	 * lists !!
	 */

	bcopy((char *)&dlb, (char *)dlbp, sizeof (DiffListBlk) - sizeof (dlbp->caches));

	if (ret) { /* OK */
	} else { /* error */
	}

	return ret;
}
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv(); 

#ifdef WIN32
    yydebug=1;
#else
    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif WIN32
#endif YYDEBUG

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce: 
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 10:
{ yyerrok; }
break;
case 11:
{
	register NumberSequencePtr tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<number_sequence(1)>>: %d\n",yyvsp[0].token.number );
#endif
	
	AllocNumberSequenceOf1(tp, nssc);
	tp->numbers[0] = yyvsp[0].token.number ;
	tp->numbers[1] = yyvsp[0].token.number ;

	yyval.ns  = tp;
}
break;
case 12:
{
	register NumberSequencePtr tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<number_sequence(2)>>: %d\t",yyvsp[-2].token.number );
	DEBUGMSG1(" %d\n",yyvsp[0].token.number );
#endif
	
	AllocNumberSequenceOf2(tp, nssc);
	tp->numbers[0] = yyvsp[-2].token.number ;
	tp->numbers[1] = yyvsp[0].token.number ;

	yyval.ns  = tp;
}
break;
case 13:
{ yyval.et  = EAppend; }
break;
case 14:
{ yyval.et  = EDelete; }
break;
case 15:
{ yyval.et  = EChange; }
break;
case 16:
{
	register EdcPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG("<<an_edit_cmd>>\n");
#endif

	dlb.nccnt++;
	dlb.edccnt++;

	AllocEdc(tp, yyvsp[-2].et , edcsc);
	tp->ns1 = yyvsp[-3].ns ;
	tp->ns2 = yyvsp[-1].ns ;

	tp->highl = tp->highr = (HighLightInfoPtr)NULL;

	dfl1ptr = &(tp->diffsin1);
	dfl2ptr = &(tp->diffsin2);
	
	dfl1tail = dfl2tail = (DflPtr)NULL;

	ChainNodeInstance(tp, edcptr, dlb.edctail);
	ChainNodeCommonInstance(tp);
}
break;
case 17:
{
	register DflPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG("<<difference1_line>>\n");
#endif
	
	if (!discard_diffs) {
		dlb.df1cnt++;
		dlb.nccnt++;

		AllocDfl(tp, EDiffin1NotIn2, dflsc);
		(tp)->difference = yyvsp[-1].token.string ;

		ChainNodeInstance(tp, dfl1ptr, dfl1tail);
		ChainNodeCommonInstance(tp);
	}
}
break;
case 18:
{
	register DflPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG("<<difference2_line>>\n");
#endif
	
	if (!discard_diffs) {
		dlb.df2cnt++;
		dlb.nccnt++;

		AllocDfl(tp, EDiffin2NotIn1, dflsc);
		(tp)->difference = yyvsp[-1].token.string ;

		ChainNodeInstance(tp, dfl2ptr, dfl2tail);
		ChainNodeCommonInstance(tp);
	}
}
break;
case 22:
{
}
break;
case 26:
{
#ifdef	YACCDEBUG
	DEBUGMSG("<<an_edit_context(1)>>\n");
#endif
}
break;
case 27:
{
#ifdef	YACCDEBUG
	DEBUGMSG("<<an_edit_context(2)>>\n");
#endif

}
break;
case 28:
{
	register BfnPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<binary_files_notification>>: '%s'\t",yyvsp[-1].token.string );
	DEBUGMSG1(" '%s'\n",yyvsp[0].token.string );
#endif

	dlb.bfncnt++;
	dlb.nccnt++;

	AllocBfn(tp, bfnsc);
	tp->path1 = yyvsp[-1].token.string ;
	tp->path2 = yyvsp[0].token.string ;

	ChainNodeInstance(tp, bfnptr, dlb.bfntail);
	ChainNodeCommonInstance(tp);
}
break;
case 29:
{
	register IfnPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<identical_files_notification>>: '%s'\t",yyvsp[-1].token.string );
	DEBUGMSG1(" '%s'\n",yyvsp[0].token.string );
#endif

	dlb.ifncnt++;
	dlb.nccnt++;

	AllocIfn(tp, ifnsc);
	tp->path1 = yyvsp[-1].token.string ;
	tp->path2 = yyvsp[0].token.string ;

	ChainNodeInstance(tp, ifnptr, dlb.ifntail);
	ChainNodeCommonInstance(tp);
}
break;
case 30:
{
	register CfnPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<common_files_notification>>: '%s'\t",yyvsp[-1].token.string );
	DEBUGMSG1(" '%s'\n",yyvsp[0].token.string );
#endif

	dlb.cfncnt++;
	dlb.nccnt++;

	AllocCfn(tp, cfnsc);
	tp->path1 = yyvsp[-1].token.string ;
	tp->path2 = yyvsp[0].token.string ;

	ChainNodeInstance(tp, cfnptr, dlb.cfntail);
	ChainNodeCommonInstance(tp);
}
break;
case 31:
{
	register OfnPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<only_in_one_notification(1)>>: '%s'\t",yyvsp[-1].token.string );
	DEBUGMSG1(" '%s'\n",yyvsp[0].token.string );
#endif

	dlb.ofncnt++;
	dlb.nccnt++;

	AllocOfn(tp, ofnsc);
	tp->path1 = yyvsp[-1].token.string ;
	tp->path2 = yyvsp[0].token.string ;

	ChainNodeInstance(tp, ofnptr, dlb.ofntail);
	ChainNodeCommonInstance(tp);
}
break;
case 32:
{
	register OfnPtr	tp;
#ifdef	YACCDEBUG
	DEBUGMSG1("<<only_in_one_notification(1)>>: '%s'\n",yyvsp[0].token.string );
#endif

	dlb.ofncnt++;
	dlb.nccnt++;

	AllocOfn(tp, ofnsc);
	tp->path1 = yyvsp[0].token.string ;
	tp->path2 = (Pathname)NULL;

	ChainNodeInstance(tp, ofnptr, dlb.ofntail);
	ChainNodeCommonInstance(tp);
}
break;
case 33:
{
	register DcnPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<diff_command_notification(1)>>: '%s'\t",yyvsp[-1].token.string );
	DEBUGMSG1(" '%s'\n",yyvsp[0].token.string );
#endif

	dlb.dcncnt++;
	dlb.nccnt++;

	AllocDcn(tp, dcnsc);
	tp->path1 = yyvsp[-1].token.string ;
	tp->path2 = yyvsp[0].token.string ;

	ChainNodeInstance(tp, dcnptr, dlb.dcntail);
	ChainNodeCommonInstance(tp);
}
break;
case 34:
{
	register DenPtr	tp;

#ifdef	YACCDEBUG
	DEBUGMSG1("<<diff_error_notification>>: '%s'\n",yyvsp[0].token.string );
#endif

	dlb.dencnt++;
	dlb.nccnt++;

	AllocDen(tp, densc);
	tp->error = yyvsp[0].token.string ;

	ChainNodeInstance(tp, denptr, dlb.dentail);
	ChainNodeCommonInstance(tp);
}
break;
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#ifdef YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#ifdef YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
