/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * Revision 1.1  1995/03/07  23:16:09  bourquard
 * Original OSF sources
 *
 *
 * Revision 1.1  90/01/01  00:00:00  devrcs
 * Initial load into Alpha pool
 * 
 * Revision 1.2  91/12/30  12:48:20  devbld
 * Initial load of project
 * 
 */
/*
 * Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *
 *	dxdiff
 *
 *	text.h - include file for text
 *
 *	Author:	Laurence P. G. Cable
 *
 *	Created : 29th April 1988
 *
 *
 *	Description
 *	-----------
 *
 *
 *	Modification History
 *	------------ -------
 *	
 *	17th August	1988	Laurence P. G. Cable
 *
 *	Experimental Horizontal Scroll stuff
 */

#ifndef	TEXT_H
#define	TEXT_H



/********************************
 *
 *      TextDisplay
 *
 ********************************/

typedef struct  _textdisplay	{
	CoreArgList		core;
	ADBConstraintArgList	constraints;
	TextArgList		text;
	FontArgList		font;

	Widget			textwidget;
	FileInfoPtr		file;
	XmFontList		fontlist;
	
	Widget			scrollwindow;
	int			scrollwidth,
				scrollheight;
	unsigned short		actualwidth;

} TextDisplay, *TextDisplayPtr;

#ifdef I18N_BUG_FIX
/* replace "_>" by "->" */
#define InitTextDisplayPtrArgList(p)     			\
		InitCoreArgList((p)->core);                     \
		InitADBConstraintArgList((p)->contraints);      \
		InitTextArgList((p)->text);                     \
		InitFontArgList((p)->font)
#else
#define	InitTextDisplayPtrArgList(p)				\
		InitCoreArgList((p)->core);			\
		InitADBConstraintArgList((p)_>contraints);	\
		InitTextArgList((p)->text);			\
		InitFontArgList((p)->font)
#endif /* I18N_BUG_FIX */

#define	InitTextDisplayArgList(p)	InitTextDisplayPtrArgList(&(p))

#define	TextDisplayPtrCoreArgList(p)	((p)->core)
#define	TextDisplayCoreArgList(p)	TextDisplayPtrCoreArgList(&(p))

#define	TextDisplayPtrConstraintArgList(p)	((p)->constraints)
#define	TextDisplayConstraintsArgList(p)	\
			TextDisplayPtrConstraintArgList(&(p))

#define	TextDisplayPtrTextArgList(p)	((p)->text)
#define	TextDisplayTextArgList(p)	TextDisplayPtrTextArgList(&(p))

#define	TextDisplayPtrFontArgList(p)	((p)->font)
#define	TextDisplayFontArgList(p)	TextDisplayPtrFontArgList(&(p))

#define	TextDisplayPtrTextWindowArgList(p) ((p)->textW)
#define	TextDisplayTextWindowArgList(p)	TextDisplayPtrTextWindowArgList(&(p))

#define	TextDisplayPtrWidget(p)		((p)->textwidget)
#define	TextDisplayWidget(p)		TextDisplayPtrWidget(&(p))

#define	TextDisplayPtrFile(p)		((p)->file)
#define	TextDisplayFile(p)		TextDisplayPtrFile(&(p))

#define	TextDisplayPtrFontList(p)	((p)->fontlist)
#define	TextDisplayFontList(p)		TextDisplayPtrFontList(&(p))

#define	TextDisplayPtrScrollWidget(p)	((p)->scrollwindow)
#define	TextDisplayScrollWidget(p)	TextDisplayPtrScrollWidget(&(p))

#define	TextDisplayPtrScrollWidth(p)	((p)->scrollwidth)
#define	TextDisplayScrollWidth(p)	TextDisplayPtrScrollWidth(&(p))

#define	TextDisplayPtrScrollHeight(p)	((p)->scrollheight)
#define	TextDisplayScrollHeight(p)	TextDisplayPtrScrollHeight(&(p))

#define	TextDisplayPtrActualWidth(p)	((p)->actualwidth)
#define	TextDisplayActualWidth(p)	TextDisplayPtrActualWidth(&(p))
#endif	TEXT_H
