
# line 67 "gram.y"
#include <stdio.h>
#include <ctype.h>
#include "twm.h"
#include "menus.h"
#include "list.h"
#include "util.h"
#include "screen.h"
#include "parse.h"
#include <X11/Xos.h>
#include <X11/Xmu/CharSet.h>

static char *Action = "";
static char *Name = "";
static MenuRoot	*root, *pull = NULL;

static MenuRoot *GetRoot();

static Bool CheckWarpScreenArg(), CheckWarpRingArg();
static Bool CheckColormapArg();
static void GotButton(), GotKey(), GotTitleButton();
static char *ptr;
static name_list **list;
static int cont = 0;
static int color;
int mods = 0;
unsigned int mods_used = (ShiftMask | ControlMask | Mod1Mask);

extern int do_single_keyword(), do_string_keyword(), do_number_keyword();
extern name_list **do_colorlist_keyword();
extern int do_color_keyword(), do_string_savecolor();
extern int yylineno;

# line 100 "gram.y"
typedef union 
{
    int num;
    char *ptr;
} YYSTYPE;
# define LB 257
# define RB 258
# define LP 259
# define RP 260
# define MENUS 261
# define MENU 262
# define BUTTON 263
# define DEFAULT_FUNCTION 264
# define PLUS 265
# define MINUS 266
# define ALL 267
# define OR 268
# define CURSORS 269
# define PIXMAPS 270
# define ICONS 271
# define COLOR 272
# define SAVECOLOR 273
# define MONOCHROME 274
# define FUNCTION 275
# define ICONMGR_SHOW 276
# define ICONMGR 277
# define WINDOW_FUNCTION 278
# define ZOOM 279
# define ICONMGRS 280
# define ICONMGR_GEOMETRY 281
# define ICONMGR_NOSHOW 282
# define MAKE_TITLE 283
# define GRAYSCALE 284
# define ICONIFY_BY_UNMAPPING 285
# define DONT_ICONIFY_BY_UNMAPPING 286
# define NO_TITLE 287
# define AUTO_RAISE 288
# define NO_HILITE 289
# define ICON_REGION 290
# define META 291
# define SHIFT 292
# define LOCK 293
# define CONTROL 294
# define WINDOW 295
# define TITLE 296
# define ICON 297
# define ROOT 298
# define FRAME 299
# define COLON 300
# define EQUALS 301
# define SQUEEZE_TITLE 302
# define DONT_SQUEEZE_TITLE 303
# define START_ICONIFIED 304
# define NO_TITLE_HILITE 305
# define TITLE_HILITE 306
# define MOVE 307
# define RESIZE 308
# define WAIT 309
# define SELECT 310
# define KILL 311
# define LEFT_TITLEBUTTON 312
# define RIGHT_TITLEBUTTON 313
# define NUMBER 314
# define KEYWORD 315
# define NKEYWORD 316
# define CKEYWORD 317
# define CLKEYWORD 318
# define FKEYWORD 319
# define FSKEYWORD 320
# define SKEYWORD 321
# define DKEYWORD 322
# define JKEYWORD 323
# define WINDOW_RING 324
# define WARP_CURSOR 325
# define ERRORTOKEN 326
# define NO_STACKMODE 327
# define STRING 328
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 654 "gram.y"

yyerror(s) char *s;
{
    twmrc_error_prefix();
    fprintf (stderr, "error in input file:  %s\n", s ? s : "");
    ParseError = 1;
}
RemoveDQuote(str)
char *str;
{
    register char *i, *o;
    register n;
    register count;

    for (i=str+1, o=str; *i && *i != '\"'; o++)
    {
	if (*i == '\\')
	{
	    switch (*++i)
	    {
	    case 'n':
		*o = '\n';
		i++;
		break;
	    case 'b':
		*o = '\b';
		i++;
		break;
	    case 'r':
		*o = '\r';
		i++;
		break;
	    case 't':
		*o = '\t';
		i++;
		break;
	    case 'f':
		*o = '\f';
		i++;
		break;
	    case '0':
		if (*++i == 'x')
		    goto hex;
		else
		    --i;
	    case '1': case '2': case '3':
	    case '4': case '5': case '6': case '7':
		n = 0;
		count = 0;
		while (*i >= '0' && *i <= '7' && count < 3)
		{
		    n = (n<<3) + (*i++ - '0');
		    count++;
		}
		*o = n;
		break;
	    hex:
	    case 'x':
		n = 0;
		count = 0;
		while (i++, count++ < 2)
		{
		    if (*i >= '0' && *i <= '9')
			n = (n<<4) + (*i - '0');
		    else if (*i >= 'a' && *i <= 'f')
			n = (n<<4) + (*i - 'a') + 10;
		    else if (*i >= 'A' && *i <= 'F')
			n = (n<<4) + (*i - 'A') + 10;
		    else
			break;
		}
		*o = n;
		break;
	    case '\n':
		i++;	/* punt */
		o--;	/* to account for o++ at end of loop */
		break;
	    case '\"':
	    case '\'':
	    case '\\':
	    default:
		*o = *i++;
		break;
	    }
	}
	else
	    *o = *i++;
    }
    *o = '\0';
}

static MenuRoot *GetRoot(name, fore, back)
char *name;
char *fore, *back;
{
    MenuRoot *tmp;

    tmp = FindMenuRoot(name);
    if (tmp == NULL)
	tmp = NewMenuRoot(name);

    if (fore)
    {
	int save;

	save = Scr->FirstTime;
	Scr->FirstTime = TRUE;
	GetColor(COLOR, &tmp->hi_fore, fore);
	GetColor(COLOR, &tmp->hi_back, back);
	Scr->FirstTime = save;
    }

    return tmp;
}

static void GotButton(butt, func)
int butt, func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0)
	    continue;

	Scr->Mouse[butt][i][mods].func = func;
	if (func == F_MENU)
	{
	    pull->prev = NULL;
	    Scr->Mouse[butt][i][mods].menu = pull;
	}
	else
	{
	    root = GetRoot(TWM_ROOT, NULLSTR, NULLSTR);
	    Scr->Mouse[butt][i][mods].item = AddToMenu(root,"x",Action,
		    NULLSTR, func, NULLSTR, NULLSTR);
	}
    }
    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}

static void GotKey(key, func)
char *key;
int func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0) 
	  continue;
	if (!AddFuncKey(key, i, mods, func, Name, Action)) 
	  break;
    }

    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}


static void GotTitleButton (bitmapname, func, rightside)
    char *bitmapname;
    int func;
    Bool rightside;
{
    if (!CreateTitleButton (bitmapname, func, Action, pull, rightside, True)) {
	twmrc_error_prefix();
	fprintf (stderr, 
		 "unable to create %s titlebutton \"%s\"\n",
		 rightside ? "right" : "left", bitmapname);
    }
    Action = "";
    pull = NULL;
}

static Bool CheckWarpScreenArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0 ||
	strcmp (s,  WARPSCREEN_BACK) == 0)
      return True;

    for (; *s && isascii(*s) && isdigit(*s); s++) ; /* SUPPRESS 530 */
    return (*s ? False : True);
}


static Bool CheckWarpRingArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0)
      return True;

    return False;
}


static Bool CheckColormapArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s, COLORMAP_NEXT) == 0 ||
	strcmp (s, COLORMAP_PREV) == 0 ||
	strcmp (s, COLORMAP_DEFAULT) == 0)
      return True;

    return False;
}


twmrc_error_prefix ()
{
    fprintf (stderr, "%s:  line %d:  ", ProgramName, yylineno);
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 14,
	257, 16,
	-2, 18,
-1, 20,
	257, 27,
	-2, 29,
-1, 23,
	257, 34,
	-2, 36,
-1, 24,
	257, 37,
	-2, 39,
-1, 25,
	257, 40,
	-2, 42,
-1, 26,
	257, 43,
	-2, 45,
-1, 39,
	257, 69,
	-2, 71,
-1, 44,
	257, 156,
	-2, 155,
-1, 45,
	257, 159,
	-2, 158,
-1, 251,
	257, 143,
	-2, 142,
	};
# define YYNPROD 193
# define YYLAST 412
short yyact[]={

   4,  47, 253, 168, 278, 247,  30,  46,  37, 132,
  95,  62,  63,  13,  12,  32,  33,  35,  36,  31,
  22, 244,  38,  11,  21,  10,  20,  27,  34,  14,
  19,  26,  29,  24,   9,  64,  51, 260,  51, 205,
 198, 192, 102, 186, 101, 162,  44,  45,  28,  23,
  47, 239, 240,  62,  63, 201,  15,  16, 133,  41,
  43, 237,  47, 171, 275,  42,  62,  63,  40,  39,
  66,  25,  47,  47,  47, 238,  18, 195, 281, 232,
 233, 234, 235, 236, 230, 136,  48,  49, 258, 146,
 142,  47,  57,  58,  59, 264, 265,  62,  63, 118,
 163, 270, 165, 100, 141, 130, 135,  78,  79,  47,
  47,  47,  47,  47, 204, 203, 124, 228, 229,  90,
 122, 123, 109, 139, 140,  84, 138, 226, 158,  60,
  50,  55, 158,  53, 143, 144, 145, 147, 148, 104,
 103, 227, 245, 196,  51, 221, 222, 223, 224, 225,
 219, 154, 155, 156, 157, 154, 155, 156, 157, 248,
 159, 197, 199, 166, 152, 187, 149,  86,  87, 193,
 160,  93, 172,  92,  91, 279, 276,  94, 169, 126,
  96, 269, 261, 202, 167, 137,  98, 134,  97, 231,
 220, 153, 191, 189,  89, 161,  88,  85,  83,  82,
  81, 121,  80, 170, 125, 164, 105, 127, 120, 119,
 267,  77, 174,  76,  75, 175, 176, 177, 178, 179,
 180, 181, 182, 183, 184, 185, 188,  74,  73,  72,
  71, 150, 151,  70,  99, 108,  69, 194,  68,  67,
  56,  54,  52, 200,   8,   7,   6,   5,   3, 206,
   2,   1, 208, 209, 210, 211, 212, 213, 214, 215,
 216, 217, 218, 173,  65,  61, 262,  17, 241,   0,
   0, 242, 243, 246,   0,   0,   0, 250,   0,   0,
 251, 252,   0,   0,   0, 190,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 106, 107, 207, 110, 111, 112, 113, 114,
 115, 116, 117, 274,   0,   0,   0,   0,   0, 257,
   0,   0,   0, 128, 129,   0,   0, 249, 131,   0,
   0,   0,   0,   0,   0,   0,   0, 268,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 254,
   0,   0, 277, 280,   0,   0,   0, 282,   0,   0,
 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 256,   0,   0, 259,   0,   0,   0,
   0,   0,   0,   0, 263,   0,   0,   0, 266,   0,
   0,   0,   0, 271,   0, 272, 273,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 283 };
short yypact[]={

-1000,-1000,-256,-1000,-1000,-1000,-1000,-1000,-1000,-327,
-327,-276,-124,-126,-1000,-327,-327,-266,-231,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-327,-327,-1000,-1000,-1000,-132,-1000,-308,-308,-1000,
-1000,-1000,-327,-276,-1000,-1000,-276,-1000,-312,-276,
-1000,-1000,-1000,-1000,-1000,-1000,-154,-257,-259,-1000,
-1000,-1000,-1000,-327,-1000,-1000,-1000,-154,-154,-135,
-154,-154,-154,-154,-154,-154,-154,-154,-160,-1000,
-137,-141,-141,-1000,-1000,-141,-1000,-1000,-154,-154,
-1000,-1000,-152,-154,-1000,-313,-1000,-200,-173,-1000,
-1000,-308,-308,-1000,-136,-140,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-327,-157,
-155,-1000,-1000,-1000,-1000,-1000,-255,-1000,-1000,-1000,
-1000,-1000,-276,-1000,-1000,-327,-1000,-1000,-327,-327,
-327,-327,-327,-327,-327,-327,-327,-327,-327,-215,
-1000,-1000,-1000,-1000,-276,-1000,-1000,-1000,-1000,-1000,
-217,-223,-1000,-1000,-1000,-1000,-218,-203,-1000,-1000,
-1000,-1000,-219,-276,-1000,-327,-327,-327,-327,-327,
-327,-327,-327,-327,-327,-327,-1000,-1000,-1000,-150,
-1000,-216,-1000,-1000,-327,-327,-237,-253,-1000,-1000,
-327,-1000,-1000,-327,-327,-1000,-321,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-308,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-308,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-278,-172,-1000,-1000,-222,-1000,-1000,-1000,
-1000,-1000,-1000,-170,-1000,-1000,-1000,-276,-1000,-1000,
-327,-156,-276,-1000,-276,-276,-1000,-157,-236,-1000,
-1000,-1000,-1000,-1000,-1000,-327,-254,-182,-1000,-1000,
-327,-308,-1000,-1000 };
short yypgo[]={

   0,  76, 129, 267, 130, 266, 265, 264, 251, 250,
 248, 247, 246, 245, 244, 242, 241, 240, 234, 239,
 238, 236, 235, 233, 230, 229, 228, 227, 214, 213,
 211, 210,  45, 209, 208, 205, 202, 201, 200, 121,
 199, 198, 197, 196, 194, 139, 193, 192, 191, 190,
 189, 188, 187, 186, 185, 184, 183, 182, 181, 179,
 178, 176, 175, 173, 172, 171, 170, 169, 166, 165,
 163, 162, 161, 159, 143, 142 };
short yyr1[]={

   0,   8,   9,   9,  10,  10,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  17,  10,  10,  10,
  10,  10,  10,  10,  10,  19,  10,  20,  10,  10,
  21,  10,  23,  10,  24,  10,  10,  25,  10,  10,
  26,  10,  10,  27,  10,  10,  28,  10,  29,  10,
  30,  10,  31,  10,  33,  10,  34,  10,  36,  10,
  38,  10,  40,  10,  10,  42,  10,  10,  10,  43,
  10,  10,  44,  10,  11,  12,  13,   6,   7,  45,
  45,  48,  48,  48,  48,  48,  48,  46,  46,  49,
  49,  49,  49,  49,  49,  49,  49,  49,  47,  47,
  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,
  15,  51,  51,  52,  16,  53,  53,  54,  54,  54,
  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,
  54,  54,  54,  54,  54,  54,  54,  54,  54,  39,
  55,  55,  56,  57,  56,  56,  41,  59,  59,  60,
  60,  58,  61,  61,  62,  14,  63,  14,  14,  65,
  14,  64,  64,  22,  66,  66,  67,  67,  18,  68,
  68,  69,  37,  70,  70,  71,  35,  72,  72,  73,
  32,  74,  74,  75,  75,   2,   2,   5,   5,   5,
   3,   1,   4 };
short yyr2[]={

   0,   1,   0,   2,   1,   1,   1,   1,   1,   6,
   3,   2,   2,   1,   2,   2,   0,   3,   1,   4,
   4,   2,   2,   2,   2,   0,   3,   0,   3,   1,
   0,   3,   0,   3,   0,   3,   1,   0,   3,   1,
   0,   3,   1,   0,   3,   1,   0,   3,   0,   3,
   0,   3,   0,   9,   0,   4,   0,   4,   0,   3,
   0,   3,   0,   3,   2,   0,   3,   2,   2,   0,
   3,   1,   0,   3,   1,   2,   2,   6,   6,   0,
   2,   1,   1,   1,   1,   2,   1,   0,   2,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   0,   2,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   3,   0,   2,   2,   3,   0,   2,   3,   2,   3,
   2,   3,   2,   3,   2,   3,   2,   3,   2,   3,
   2,   3,   2,   3,   2,   3,   2,   3,   2,   3,
   0,   2,   2,   0,   4,   2,   3,   0,   2,   1,
   1,   3,   0,   2,   2,   1,   0,   5,   1,   0,
   3,   0,   5,   3,   0,   2,   3,   4,   3,   0,
   2,   1,   3,   0,   2,   2,   3,   0,   2,   1,
   3,   0,   2,   2,   7,   1,   2,   1,   2,   2,
   2,   1,   1 };
short yychk[]={

-1000,  -8,  -9, -10, 256, -11, -12, -13, -14, 290,
 281, 279, 270, 269, 285, 312, 313,  -3,  -1, 286,
 282, 280, 276, 305, 289, 327, 287, 283, 304, 288,
 262, 275, 271, 272, 284, 273, 274, 264, 278, 325,
 324, 315, 321, 316, 302, 303, 263, 328,  -1,  -1,
  -4, 314, -15, 257, -16, 257, -17,  -1,  -1,  -1,
  -2,  -6, 319, 320, 301,  -7, 301, -19, -20, -21,
 -23, -24, -25, -26, -27, -28, -29, -30,  -1,  -1,
 -36, -38, -40, -41, 257, -42,  -2,  -2, -43, -44,
  -1,  -4, -63, -65,  -4, 322,  -4, -51, -53, -18,
 257, 301, 301,  -1, -45, -45, -18, -18, -22, 257,
 -18, -18, -18, -18, -18, -18, -18, -18, 259, -33,
 -34, -37, 257, -39, 257, -39, -59, -39, -18, -18,
 257, -18, 322, 258, -52, 306, 258, -54, 299, 296,
 297, 277, 263, 307, 308, 309, 262, 310, 311, -68,
  -2,  -2, 300, -48, 291, 292, 293, 294, 268, 300,
 -66,  -1, -32, 257, -35, 257, -70, -55, 258, -60,
  -1, 318, -64,  -4,  -1,  -1,  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,  -1,  -1, 258, -69,  -1, -46,
  -4, -47, 258, -67,  -1, 300, -74, -72, 258, -71,
  -1, 258, -56, 318, 317, 258,  -1,  -4,  -1,  -1,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 300,
 -49, 295, 296, 297, 298, 299, 277, 291, 267, 268,
 300, -50, 295, 296, 297, 298, 299, 277, 291, 267,
 268,  -1,  -1,  -1, 258, -75,  -1, 258, -73,  -2,
  -1,  -1,  -1, 323,  -2,  -2,  -4,  -1, 260,  -2,
 259, -57,  -5,  -4, 265, 266,  -4, -31,  -1, -58,
 257,  -4,  -4,  -4, -32, 300, -61,  -1, 258, -62,
  -1, 260,  -1,  -2 };
short yydef[]={

   2,  -2,   1,   3,   4,   5,   6,   7,   8,   0,
   0,  13,   0,   0,  -2,   0,   0,   0,   0,  25,
  -2,  30,  32,  -2,  -2,  -2,  -2,  46,  48,  50,
   0,   0,  58,  60,  62,   0,  65,   0,   0,  -2,
  72,  74,   0,   0,  -2,  -2,   0, 191,   0,  11,
  12, 192,  14, 111,  15, 115,   0,   0,   0,  21,
  22,  24, 185,   0,  79,  23,  79,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  54,  56,
   0,   0,   0,  64, 147,   0,  67,  68,   0,   0,
  75,  76,   0,   0, 190,   0,  10,   0,   0,  17,
 169,   0,   0, 186,   0,   0,  26,  28,  31, 164,
  33,  35,  38,  41,  44,  47,  49,  51,   0,   0,
   0,  59, 173,  61, 140,  63,   0,  66,  70,  73,
 161, 160,   0, 110, 112,   0, 114, 116,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  19,  20,  87,  80,  81,  82,  83,  84,  86,  98,
   0,   0,  55, 181,  57, 177,   0,   0, 146, 148,
 149, 150,   0,   0, 113, 118, 120, 122, 124, 126,
 128, 130, 132, 134, 136, 138, 168, 170, 171,   0,
  85,   0, 163, 165,   0,   0,   0,   0, 172, 174,
   0, 139, 141,   0,   0, 157,   0,   9, 117, 119,
 121, 123, 125, 127, 129, 131, 133, 135, 137,   0,
  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,
   0,  99, 100, 101, 102, 103, 104, 105, 106, 107,
 108, 109,   0,   0, 180, 182,   0, 176, 178, 179,
 175,  -2, 145,   0,  77,  78, 166,   0,  52, 183,
   0,   0,   0, 187,   0,   0, 167,   0,   0, 144,
 152, 162, 188, 189,  53,   0,   0,   0, 151, 153,
   0,   0, 154, 184 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 9:
# line 140 "gram.y"
{ AddIconRegion(yypvt[-4].ptr, yypvt[-3].num, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num); } break;
case 10:
# line 141 "gram.y"
{ if (Scr->FirstTime)
						  {
						    Scr->iconmgr.geometry=yypvt[-1].ptr;
						    Scr->iconmgr.columns=yypvt[-0].num;
						  }
						} break;
case 11:
# line 147 "gram.y"
{ if (Scr->FirstTime)
						    Scr->iconmgr.geometry = yypvt[-0].ptr;
						} break;
case 12:
# line 150 "gram.y"
{ if (Scr->FirstTime)
					  {
						Scr->DoZoom = TRUE;
						Scr->ZoomCount = yypvt[-0].num;
					  }
					} break;
case 13:
# line 156 "gram.y"
{ if (Scr->FirstTime) 
						Scr->DoZoom = TRUE; } break;
case 14:
# line 158 "gram.y"
{} break;
case 15:
# line 159 "gram.y"
{} break;
case 16:
# line 160 "gram.y"
{ list = &Scr->IconifyByUn; } break;
case 18:
# line 162 "gram.y"
{ if (Scr->FirstTime) 
		    Scr->IconifyByUnmapping = TRUE; } break;
case 19:
# line 164 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, False);
					} break;
case 20:
# line 167 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, True);
					} break;
case 21:
# line 170 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR);
					  Scr->Mouse[yypvt[-1].num][C_ROOT][0].func = F_MENU;
					  Scr->Mouse[yypvt[-1].num][C_ROOT][0].menu = root;
					} break;
case 22:
# line 174 "gram.y"
{ Scr->Mouse[yypvt[-1].num][C_ROOT][0].func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->Mouse[yypvt[-1].num][C_ROOT][0].menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->Mouse[yypvt[-1].num][C_ROOT][0].item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num,NULLSTR,NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 23:
# line 190 "gram.y"
{ GotKey(yypvt[-1].ptr, yypvt[-0].num); } break;
case 24:
# line 191 "gram.y"
{ GotButton(yypvt[-1].num, yypvt[-0].num); } break;
case 25:
# line 192 "gram.y"
{ list = &Scr->DontIconify; } break;
case 27:
# line 194 "gram.y"
{ list = &Scr->IconMgrNoShow; } break;
case 29:
# line 196 "gram.y"
{ Scr->IconManagerDontShow = TRUE; } break;
case 30:
# line 197 "gram.y"
{ list = &Scr->IconMgrs; } break;
case 32:
# line 199 "gram.y"
{ list = &Scr->IconMgrShow; } break;
case 34:
# line 201 "gram.y"
{ list = &Scr->NoTitleHighlight; } break;
case 36:
# line 203 "gram.y"
{ if (Scr->FirstTime)
						Scr->TitleHighlight = FALSE; } break;
case 37:
# line 205 "gram.y"
{ list = &Scr->NoHighlight; } break;
case 39:
# line 207 "gram.y"
{ if (Scr->FirstTime)
						Scr->Highlight = FALSE; } break;
case 40:
# line 209 "gram.y"
{ list = &Scr->NoStackModeL; } break;
case 42:
# line 211 "gram.y"
{ if (Scr->FirstTime)
						Scr->StackMode = FALSE; } break;
case 43:
# line 213 "gram.y"
{ list = &Scr->NoTitle; } break;
case 45:
# line 215 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoTitlebar = TRUE; } break;
case 46:
# line 217 "gram.y"
{ list = &Scr->MakeTitle; } break;
case 48:
# line 219 "gram.y"
{ list = &Scr->StartIconified; } break;
case 50:
# line 221 "gram.y"
{ list = &Scr->AutoRaise; } break;
case 52:
# line 223 "gram.y"
{
					root = GetRoot(yypvt[-5].ptr, yypvt[-3].ptr, yypvt[-1].ptr); } break;
case 53:
# line 225 "gram.y"
{ root->real_menu = TRUE;} break;
case 54:
# line 226 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 55:
# line 227 "gram.y"
{ root->real_menu = TRUE; } break;
case 56:
# line 228 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 58:
# line 230 "gram.y"
{ list = &Scr->IconNames; } break;
case 60:
# line 232 "gram.y"
{ color = COLOR; } break;
case 62:
# line 234 "gram.y"
{ color = GRAYSCALE; } break;
case 65:
# line 238 "gram.y"
{ color = MONOCHROME; } break;
case 67:
# line 240 "gram.y"
{ Scr->DefaultFunction.func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->DefaultFunction.menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->DefaultFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 68:
# line 256 "gram.y"
{ Scr->WindowFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->WindowFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 69:
# line 264 "gram.y"
{ list = &Scr->WarpCursorL; } break;
case 71:
# line 266 "gram.y"
{ if (Scr->FirstTime) 
					    Scr->WarpCursor = TRUE; } break;
case 72:
# line 268 "gram.y"
{ list = &Scr->WindowRingL; } break;
case 74:
# line 273 "gram.y"
{ if (!do_single_keyword (yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
					"unknown singleton keyword %d\n",
						     yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 75:
# line 283 "gram.y"
{ if (!do_string_keyword (yypvt[-1].num, yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown string keyword %d (value \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 76:
# line 293 "gram.y"
{ if (!do_number_keyword (yypvt[-1].num, yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown numeric keyword %d (value %d)\n",
						     yypvt[-1].num, yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 77:
# line 305 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 78:
# line 308 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 81:
# line 315 "gram.y"
{ mods |= Mod1Mask; } break;
case 82:
# line 316 "gram.y"
{ mods |= ShiftMask; } break;
case 83:
# line 317 "gram.y"
{ mods |= LockMask; } break;
case 84:
# line 318 "gram.y"
{ mods |= ControlMask; } break;
case 85:
# line 319 "gram.y"
{ if (yypvt[-0].num < 1 || yypvt[-0].num > 5) {
					     twmrc_error_prefix();
					     fprintf (stderr, 
				"bad modifier number (%d), must be 1-5\n",
						      yypvt[-0].num);
					     ParseError = 1;
					  } else {
					     mods |= (Mod1Mask << (yypvt[-0].num - 1));
					  }
					} break;
case 86:
# line 329 "gram.y"
{ } break;
case 89:
# line 336 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 90:
# line 337 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 91:
# line 338 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 92:
# line 339 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 93:
# line 340 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 94:
# line 341 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 95:
# line 342 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 96:
# line 343 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 97:
# line 344 "gram.y"
{  } break;
case 100:
# line 351 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 101:
# line 352 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 102:
# line 353 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 103:
# line 354 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 104:
# line 355 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 105:
# line 356 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 106:
# line 357 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 107:
# line 358 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 108:
# line 359 "gram.y"
{ } break;
case 109:
# line 360 "gram.y"
{ Name = yypvt[-0].ptr; cont |= C_NAME_BIT; } break;
case 113:
# line 371 "gram.y"
{ SetHighlightPixmap (yypvt[-0].ptr); } break;
case 117:
# line 382 "gram.y"
{
			NewBitmapCursor(&Scr->FrameCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 118:
# line 384 "gram.y"
{
			NewFontCursor(&Scr->FrameCursor, yypvt[-0].ptr); } break;
case 119:
# line 386 "gram.y"
{
			NewBitmapCursor(&Scr->TitleCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 120:
# line 388 "gram.y"
{
			NewFontCursor(&Scr->TitleCursor, yypvt[-0].ptr); } break;
case 121:
# line 390 "gram.y"
{
			NewBitmapCursor(&Scr->IconCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 122:
# line 392 "gram.y"
{
			NewFontCursor(&Scr->IconCursor, yypvt[-0].ptr); } break;
case 123:
# line 394 "gram.y"
{
			NewBitmapCursor(&Scr->IconMgrCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 124:
# line 396 "gram.y"
{
			NewFontCursor(&Scr->IconMgrCursor, yypvt[-0].ptr); } break;
case 125:
# line 398 "gram.y"
{
			NewBitmapCursor(&Scr->ButtonCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 126:
# line 400 "gram.y"
{
			NewFontCursor(&Scr->ButtonCursor, yypvt[-0].ptr); } break;
case 127:
# line 402 "gram.y"
{
			NewBitmapCursor(&Scr->MoveCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 128:
# line 404 "gram.y"
{
			NewFontCursor(&Scr->MoveCursor, yypvt[-0].ptr); } break;
case 129:
# line 406 "gram.y"
{
			NewBitmapCursor(&Scr->ResizeCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 130:
# line 408 "gram.y"
{
			NewFontCursor(&Scr->ResizeCursor, yypvt[-0].ptr); } break;
case 131:
# line 410 "gram.y"
{
			NewBitmapCursor(&Scr->WaitCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 132:
# line 412 "gram.y"
{
			NewFontCursor(&Scr->WaitCursor, yypvt[-0].ptr); } break;
case 133:
# line 414 "gram.y"
{
			NewBitmapCursor(&Scr->MenuCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 134:
# line 416 "gram.y"
{
			NewFontCursor(&Scr->MenuCursor, yypvt[-0].ptr); } break;
case 135:
# line 418 "gram.y"
{
			NewBitmapCursor(&Scr->SelectCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 136:
# line 420 "gram.y"
{
			NewFontCursor(&Scr->SelectCursor, yypvt[-0].ptr); } break;
case 137:
# line 422 "gram.y"
{
			NewBitmapCursor(&Scr->DestroyCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 138:
# line 424 "gram.y"
{
			NewFontCursor(&Scr->DestroyCursor, yypvt[-0].ptr); } break;
case 142:
# line 436 "gram.y"
{ if (!do_colorlist_keyword (yypvt[-1].num, color,
								     yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled list color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 143:
# line 445 "gram.y"
{ list = do_colorlist_keyword(yypvt[-1].num,color,
								      yypvt[-0].ptr);
					  if (!list) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color list keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 145:
# line 456 "gram.y"
{ if (!do_color_keyword (yypvt[-1].num, color,
								 yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 149:
# line 474 "gram.y"
{ do_string_savecolor(color, yypvt[-0].ptr); } break;
case 150:
# line 475 "gram.y"
{ do_var_savecolor(yypvt[-0].num); } break;
case 154:
# line 485 "gram.y"
{ if (Scr->FirstTime &&
					      color == Scr->Monochrome)
					    AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 155:
# line 490 "gram.y"
{ 
				    if (HasShape) Scr->SqueezeTitle = TRUE;
				} break;
case 156:
# line 493 "gram.y"
{ list = &Scr->SqueezeTitleL; 
				  if (HasShape && Scr->SqueezeTitle == -1)
				    Scr->SqueezeTitle = TRUE;
				} break;
case 158:
# line 498 "gram.y"
{ Scr->SqueezeTitle = FALSE; } break;
case 159:
# line 499 "gram.y"
{ list = &Scr->DontSqueezeTitleL; } break;
case 162:
# line 504 "gram.y"
{
				if (Scr->FirstTime) {
				   do_squeeze_entry (list, yypvt[-3].ptr, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num);
				}
			} break;
case 166:
# line 519 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-2].ptr, (char *)
						AllocateIconManager(yypvt[-2].ptr, NULLSTR,
							yypvt[-1].ptr,yypvt[-0].num));
					} break;
case 167:
# line 525 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-3].ptr, (char *)
						AllocateIconManager(yypvt[-3].ptr,yypvt[-2].ptr,
						yypvt[-1].ptr, yypvt[-0].num));
					} break;
case 171:
# line 539 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-0].ptr, 0);
					} break;
case 175:
# line 551 "gram.y"
{ if (Scr->FirstTime) AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 179:
# line 561 "gram.y"
{ AddToMenu(root, "", Action, NULLSTR, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					} break;
case 183:
# line 574 "gram.y"
{ AddToMenu(root, yypvt[-1].ptr, Action, pull, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					  pull = NULL;
					} break;
case 184:
# line 579 "gram.y"
{
					  AddToMenu(root, yypvt[-6].ptr, Action, pull, yypvt[-0].num,
						yypvt[-4].ptr, yypvt[-2].ptr);
					  Action = "";
					  pull = NULL;
					} break;
case 185:
# line 587 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 186:
# line 588 "gram.y"
{
				yyval.num = yypvt[-1].num;
				Action = yypvt[-0].ptr;
				switch (yypvt[-1].num) {
				  case F_MENU:
				    pull = GetRoot (yypvt[-0].ptr, NULLSTR,NULLSTR);
				    pull->prev = root;
				    break;
				  case F_WARPRING:
				    if (!CheckWarpRingArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.warptoring argument \"%s\"\n",
						 Action);
					yyval.num = F_NOP;
				    }
				  case F_WARPTOSCREEN:
				    if (!CheckWarpScreenArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr, 
			"ignoring invalid f.warptoscreen argument \"%s\"\n", 
					         Action);
					yyval.num = F_NOP;
				    }
				    break;
				  case F_COLORMAP:
				    if (CheckColormapArg (Action)) {
					yyval.num = F_COLORMAP;
				    } else {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.colormap argument \"%s\"\n", 
						 Action);
					yyval.num = F_NOP;
				    }
				    break;
				} /* end switch */
				   } break;
case 187:
# line 629 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 188:
# line 630 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 189:
# line 631 "gram.y"
{ yyval.num = -(yypvt[-0].num); } break;
case 190:
# line 634 "gram.y"
{ yyval.num = yypvt[-0].num;
					  if (yypvt[-0].num == 0)
						yyerror("bad button 0");

					  if (yypvt[-0].num > MAX_BUTTONS)
					  {
						yyval.num = 0;
						yyerror("button number too large");
					  }
					} break;
case 191:
# line 646 "gram.y"
{ ptr = (char *)malloc(strlen(yypvt[-0].ptr)+1);
					  strcpy(ptr, yypvt[-0].ptr);
					  RemoveDQuote(ptr);
					  yyval.ptr = ptr;
					} break;
case 192:
# line 651 "gram.y"
{ yyval.num = yypvt[-0].num; } break; 
		}
		goto yystack;  /* stack new state and value */

	}
