/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 */
/*
 *  I18N_CONVERTER.H
 */

#ifndef I18n_CONVERTER_H
#define I18n_CONVERTER_H
#if defined(VMS) || defined (__VMS)
#include <X11/apienvset.h>
#endif

/*
 * compound string converter status returns
 */

#define I18nCvtStatusOK        1
#define I18nCvtStatusDataLoss  2
#define I18nCvtStatusFail      3

/*
 * Compound string parser and constructor callback constants and context
 */
#define I18nCvtInitCallback	0
#define I18nCvtEndCallback	1
#define I18nCvtSegmentCallback	2
#define I18nCvtLineCallback	3

#define I18nCvtMaxCallback	4

typedef struct
{
    int			status;
    void		(*callback[I18nCvtMaxCallback])();
    Opaque *		stream;
    Opaque *		stream_context;

    int			memory_length;
    Opaque *		memory;    
    Opaque *		memory_context;
    
    unsigned char	direction;
    unsigned char *	charset;
    int			byte_length;
    unsigned char *	text;
    int			nest_level;
    int                 version;
} I18nCvtContextRec, *I18nCvtContext;

#if defined(VMS) || defined (__VMS)
#include <X11/apienvrst.h>
#endif
#endif /* I18n_CONVERTER_H */
