/*
 * Copyright 1993 by Digital Equipment Corporation, Maynard, Massachusetts,
 * and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the names of Digital or MIT not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL DIGITAL
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * 
 * Include file for WinSock network interface under Microsoft Windows-NT.
 * 
 * The definitions here have been lifted from the include files provided by
 * Microsoft under Windows NT, and from Unix system files. It was impossible 
 * to just include them directly, because there are too many conflicting 
 * definitions and symbols. The NT definitions are based on the October 1992 
 * Beta kit. If future versions of NT are used, the definitions here will 
 * have to be checked against the new ones. It ain't pretty, but it's the
 * only way I could figure out to get the stuff ported.
 *
 */

#ifndef __NUTC__
 
#ifndef _XLIB_NT_H_
#define _XLIB_NT_H_

// Hack for Xt - jtf
#define ERRORDB "%s\\lib\\X11\\XtErrorDB"

extern int MakeWinSockDECnetConnection();
extern int MakeWinSockTCPConnection();
extern int WinSockBytesReadable();
extern int WinSockSelect();
extern int WinSockClose();
extern int WinSockRead();
extern int WinSockWrite();
extern int WinSockReadv();
extern int WinSockWritev();
extern int WinSockSetNonblocking();
extern int WinSockGetHostName();
extern struct hostent * WinSockGetHostByName();
extern int WinSockWaitForReadable();
extern int WinSockWaitForWritable();
extern int gettimeofday();
extern char * _XGetInstalledLocation();

#ifndef _DXSDK_SLEEP_DEFINED
extern __stdcall Sleep();
#endif

#include <sys\timeb.h>
#include <fcntl.h>
#include <limits.h>
#ifndef PATH_MAX
#define PATH_MAX 255
#endif
#ifndef OPEN_MAX
#define OPEN_MAX 255
#endif
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN  256
#endif
#define isascii __isascii
#define access _access
#define stat _stat
#define open _open
#define close _close
#define read _read
#define write _write
#define creat _creat
#define lseek _lseek
#define fileno _fileno
#define unlink _unlink
#define pclose _pclose
#define popen _popen
#define sleep Sleep
#define stat _stat
#define mktemp _mktemp
#ifndef bcopy
#define bcopy(src,dst,len) memmove( dst, src, (size_t) (len) )
#endif
#define sys_errlist _sys_errlist
#define sys_nerr _sys_nerr
#define hypot _hypot
#define _XWaitForWritable WinSockWaitForWritable
#define _XWaitForReadable WinSockWaitForReadable
#define R_OK 4
#define EWOULDBLOCK 35
#define O_RDONLY _O_RDONLY
#define S_IFDIR _S_IFDIR

typedef char * caddr_t;

struct iovec {
    char * iov_base;
    int iov_len;
};

/* Only define these if not already defined by WINSOCK */
#ifndef _WINSOCKAPI_
struct timeval {
    long    tv_sec;         /* seconds */
    long    tv_usec;        /* and microseconds */
};
/*
 * Structures returned by network data base library, taken from the
 * BSD file netdb.h.  All addresses are supplied in host order, and
 * returned in network order (suitable for use in system calls).
 */
struct  hostent {
        char    *h_name;           /* official name of host */
        char    **h_aliases;  /* alias list */
        short   h_addrtype;             /* host address type */
        short   h_length;               /* length of address */
        char    **h_addr_list; /* list of addresses */
#define h_addr  h_addr_list[0]          /* address, for backward compat */
};
#define AF_INET 2
#endif /* _WINSOCKAPI_ */

struct timezone {
    int tz_minuteswest;     /* of Greenwich ("Universal Coordinated Time") */
    int tz_dsttime;         /* Daylight savings flag */
};

#endif /* _XLIB_NT_H_ */

#endif /* __NUTC__ */
