.TH XINITREMOTE 1 "" "NCDware 3.2"
.SH NAME
xinitremote - X Window System initializer
.SH SYNOPSIS
.B xinitremote
[[\fIclient\fP] \fIoptions\fP] [-- [\fIserver\fP] [\fIdisplay number\fP] \fIoptions\fP]
.SH DESCRIPTION
The \fIxinitremote\fP program is used to start the Xremote server and a first
client program (usually a terminal emulator).
When this first client exits, 
\fIxinitremote\fP will kill the Xremote server and then terminate.
.PP
When running \fIxinitremote\fP, the \fIXremote\fP program acts as a
proxy for display \fIn\fP on the current host.  The display number (\fIn\fP)
is chosen dynamically by the \fIXremote\fP program, and the chosen number
is given back to \fIxinitremote\fP, and then placed into the environment
before the client is executed.
.PP
If no specific client program is given on the command line,
\fIxinitremote\fP will look for a file in the user's home directory
called \fI.xinitremoterc\fP to run as a shell script to start up client programs.
If no such file exists, \fIxinitremote\fP will use the following as a default:
.sp
	xterm -geometry +1+1 -n login
.sp
.PP
If no specific server program is given on the command line,
\fIxinitremote\fP will look for a file in the user's home directory
called \fI.xservremoterc\fP to run as a shell script to start up the server.
If no such file exists, \fIxinitremote\fP will use the following as a default:
.sp
        Xremote
.sp
Note that this assumes that there is a program named \fIXremote\fP in the current
search path.
.PP
An important point is that programs that are run by \fI\&.xinitremoterc\fP
and by \fI\&.xservremoterc\fP should be run in the background if they do 
not exit right away, so that they don't prevent other programs from
starting up.
However, the last long-lived program started (usually
a window manager or terminal emulator) should be
left in the foreground so that the script won't exit (which
indicates that the user is done and that \fIxinitremote\fP should exit).
.PP
An alternate client and/or server may be specified on the
command line.  The desired client program and its arguments should be given
as the first command line arguments to \fIxinitremote\fP. 
To specify a particular
server command line, append a double dash (--) to the \fIxinitremote\fP command
line (after any client and arguments) followed by the desired server command.
.PP
Both the client program name and the server program name must begin with a
slash (/) or a period (.).  Otherwise, they are treated as an arguments to be
appended to their respective startup lines.  This makes it possible to 
add arguments (for example, foreground and background colors) without 
having to retype the whole command line.
.PP
If an explicit server name is not given and the first argument following the
double dash (--) is a colon followed by a digit,
\fIXremote\fP will use that 
number as the display 
number instead of its initial default of one.
All remaining arguments are appended to the server 
command line.
.PP
.SH EXAMPLES
Below are several examples of how command line arguments in
\fIxinitremote\fP are used.
.TP 8
.B xinitremote
This will start up a server named \fIXremote\fP and run the user's \fI\.xinitremoterc\fP,
if it exists, or else start an \fIxterm\fP.
.TP 8
.B "xinitremote -geometry =80x65+10+10 -fn 8x13 -j -fg white -bg navy"
This will start up a server named \fIXremote\fP, and will append the given
arguments to the default \fIxterm\fP command.
It will ignore \fI\&.xinitremoterc\fP.
.TP 8
.PP
Below is a sample \fI\&.xinitremoterc\fP that starts
a clock, several terminals, and
leaves the window manager running as the ``last'' application.  Assuming that
the window manager has been configured properly, the user
then chooses the ``Exit'' menu item to shut down X.
.sp
.in +8
.nf
xrdb -load $HOME/.Xres
xsetroot -solid gray &
xclock -g 50x50-0+0 -bw 0 &
xload -g 50x50-50+0 -bw 0 &
xterm -g 80x24+0+0 &
xterm -g 80x24+0-0 &
uwm
.fi
.in -8
.sp
Sites that want to create a common startup environment could simply create
a default \fI\.xinitremoterc\fP that references a site-wide startup file:
.sp
.in +8
.nf
#!/bin/sh
\&. /usr/local/lib/site.xinitremoterc
.fi
.in -8
.sp
Another approach is to write a script that starts \fIxinitremote\fP
with a specific shell script.
Such scripts are usually named \fIx11\fP, \fIxstart\fP, or
\fIstartx\fP and are a convenient way to provide a simple interface for
novice users:
.sp
.in +8
.nf
#!/bin/sh
xinitremote /usr/local/bin/startx
.fi
.in -8
.sp
.SH "ENVIRONMENT VARIABLES"
.TP 8
.B DISPLAY
This variable gets set to the name of the display to which clients should
connect.
.TP 8
.B XINITRC
This variable specifies an init file containing shell commands to start up the
initial windows. 
By default, \fI\.xinitremoterc\fP in the home directory will be used.
.TP 8
.B XSERVERRC
This variable specifies a file containing shell commands to start up the
Xremote server.
By default, \fI\.xservremoterc\fP in the home directory will be used.
.TP 8
.B XREMOTETMPDIR
This variable is used as the directory in which the log file for
all stdio library output from the Xremote helper and all the clients
run by the \fI\&.xinitremoterc\fP script.  A file in this directory with the
name \fBXremote\fIdigits\fR, where \fIdigits\fP comprise the display number,
contains the output from the session.
.TP 8
.B TMPDIR
If there is no \fIXREMOTETMPDIR\fP variable, the \fITMPDIR\fP
variable is consulted for the name of the directory in which to leave
the log file.  If both these variables are not present, then the
log file is left in the \fI/usr/tmp\fP directory.
.SH "FILES"
.PD 0
.TP 20
.B /usr/tmp/Xremote*
Contains redirected standard out and standard error streams from
the \fIXremote\fP server.
The numerical suffix of this file name is the display number that
was established by the \fIXremote\fP server.
.TP
.B /dev/tty
Default line on which to run the \fIXremote\fP server.  See the manual
page for \fIXremote\fP for further details.
.TP
.B ~/\&.xinitremoterc
This file contains the script that describes what clients to start
when the Xremote session is initiated.
.TP
.B ~/\&.xinitrc
For backward compatibility with older versions of \fIxinitremote\fP,
this file will be used as the startup script if the \fI\&.xinitremotrc\fP
file is not present.
.TP
.B ~/\&.xservremoterc
This file contains the script that describes what server to start.
.PD
.SH "SEE ALSO"
X(1), Xremote(1), xterm(1), xrdb(1), tempnam(3s)
.SH COPYRIGHT
Copyright 1990-1994 Network Computing Devices, Inc.
.br
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Dave Cornelius, Network Computing Devices, Inc.
.br
Bob Scheifler, MIT Laboratory for Computer Science
\" $NCDId: @(#)xinitremote.man,v 14.11 1994/02/04 15:54:40 jan Exp $
