.TH XREMOTE 1 "" "NCDware 3.2"
.SH NAME
Xremote - X Protocol interpreter for serial lines
.SH SYNOPSIS
.B Xremote
[
.BI : n
] [
.BI "-line /dev/tty" xxx
] [
.BI "-speed " rate
] [
.BI "-scanbase "  n
] [
.BI "-scanmax " n
] [
.BI "-report " fd
] [
.BI "-comp " bits
] [
.BI "-esc " char
] [
.BI "-inet "
] [
.BI "-port " portnum
] [
.BI "-display " display
]
.SH DESCRIPTION
Typically, the \fIXremote\fP program is invoked by \fIxinitremote\fP, which
will also initiate one or more X Window System client programs.
.PP
The \fIXremote\fP program is a protocol interpreter that acts as the
endpoint of a TCP-domain X connection, and communicates with
an appropriately configured NCD X server using
a proprietary protocol.  For the underlying transport protocol,
\fIXremote\fP supports both an NCD proprietary
protocol designed for serial lines and TCP.
.PP
\fIXremote\fP listens on TCP port 6000+\fIn\fP on the host for
incoming connections
from X-windows clients on the network, and multiplexes all these
clients' X-wire data into a single stream to the NCD.
The \fIXremote\fP program starts looking for available TCP ports
at its default base of 6001, which corresponds to X display 1, and
attempts to bind to successive ports up to 6051.
.PP
On HP-UX systems, \fIXremote\fP also opens the UNIX-domain
socket that corresponds to the display number obtained
by the scan for free TCP ports.  This allows \fIxinitremote\fP
to set the environment variable \fI$DISPLAY\fP
to \fIhostname:1\fP which is interpreted by HP-UX's
\fIXlib\fP in a fashion similar to \fIunix:1\fP on
other implementations of \fIXlib\fP.
.PP
The proprietary transport protocol is a two layer stack that connects
the helper process on the host machine to the server code running in the NCD.
The lowest layer of the protocol is a datagram service.  Each datagram
is protected by a 16-bit CRC frame check sequence.
A character-stuffing mechanism is used to mark datagram boundaries, and
to escape certain special characters in the data stream.
The second level is used to implement a reliable full-duplex data stream,
which allows multiple in-flight packets and
handles packet retransmission
.PP
Above the transport layer, whether it be the proprietary protocol or
TCP, \fIXremote\fP
provides X-wire specific data compression,
general purpose data compression,
and X-connection and X-wire data transport services.
.PP
.SH OPTIONS
.TP 8
.BI "-line /dev/tty" xxx
Use the specified device name for running the serial protocol.  Default
is \fI/dev/tty\fP.
Applies only when the proprietary transport protocol is being used.
.TP 8
.BI "-speed " rate
Set the baud rate on the line to the given rate.  Default is to use
whatever rate is currently set.
Applies only when the proprietary transport protocol is being used.
.TP 8
.BI "-scanbase " n
Set the base for the display scanning.  Default is 1.  This number is
added to 6000 to generate the TCP port number upon which the \fIXremote\fP
process will listen for incoming X connections.
.TP 8
.BI : n
Same as \fB-scanbase \fIn\fR.
Used for compatibility with other \fIxinitremote\fP-style
startup sequences.
.TP 8
.BI "-scanmax " n
Limits the number of TCP ports that will be scanned before giving up.
Default is 1 if the \fB-report\fP option is not specified,
and 50 if \fB-report\fP is specified.
.TP 8
.BI "-report " fd
Emit the display number obtained by the TCP port scan
on inherited file descriptor \fIfd\fP as a decimal number.
Typically, this file descriptor is the writable side of a pipe into
the parent process.  This argument is supplied automatically
when \fIxinitremote\fP invokes \fIXremote\fP.
The file descriptor is
closed immediately after the display number is written.
.TP 8
.BI "-comp " bits
This option is used to select the code size, in bits, of the
LZW compressed data.
A larger code size results in better compression performance, but
requires more memory in both the helper and the X server.
\fIbits\fP may be 0 (to indicate that no compression is to be
used), 12 or 14.
The code size is negotiated between the helper and the X server
at connect time.
If this option is omitted, and the X server has not specified
a code size either, then the code size will default to 12 bits.
If only one side specifies a code size, then that code size will
be used.
If both sides specify a code size, then the code size that will
result in the smallest amount of memory usage will be used.
.TP 8
.BI "-esc " char
This option only applies when the proprietary transport protocol is
being used.
Although there is a predefined set of characters which are
always escaped, some intervening communications equipment may
recognize other characters as escape sequences.
This option allows these other special characters to be included in
the list of those that are escaped.
\fB-esc\fP \fIchar\fP may be specified multiple times and
\fIchar\fP may be specified in decimal or hexadecimal.
Hexadecimal values need to have a leading ``0x''
or ``0X''.
.TP 8
.BI "-inet "
If \fB-inet\fP is specified, then TCP will be used as the transport
protocol.
By default, the proprietary transport protocol is used.
.TP 8
.BI "-port " portnum
\fIportnum\fP is the TCP port in the NCD display which
\fIXremote\fP will attempt to contact.
The default is 5900.
This option only applies when \fB-inet\fP is specified.
.TP 8
.BI "-display " display
Specifies the NCD display to contact.
If \fB-display\fP is not specified, then the \fIDISPLAY\fP
environment variable will be used.
If that is not set, then an error will result.
This option only applies when \fB-inet\fP is specified.
.SH "FILES"
.PD 0
.TP 20
.B /dev/tty
Default line on which to run the \fIXremote\fP server.
.PD
.SH "SEE ALSO"
X(1), xinitremote(1)
.SH COPYRIGHT
Copyright 1990, 1994 Network Computing Devices, Inc.
.br
.SH AUTHOR
Dave Cornelius, Network Computing Devices, Inc.
\" $NCDId: @(#)Xremote.man,v 14.9 1994/02/04 14:14:17 jan Exp $
