$ set noverify !V502
$!------------------------------------------------------------------------!
$! PCX$SERVER.COM - Start up X applications to eXcursion		  !
$!------------------------------------------------------------------------!
$!*************************************************************************
$!*									  *
$!*  COPYRIGHT (c) 1988, 1989, 1990, 1991, 1992, 1993 BY		  *
$!*  DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.			  *
$!*  ALL RIGHTS RESERVED.						  *
$!*									  *
$!*************************************************************************
$!
$!************************************************************************
$!*
$!* PCX$SERVER.COM
$!*
$!* 24-NOV-1993 V5.0 for eXcursion and PCDECwindows
$!*
$!* The purpose of this file is for Remote Startup of X clients.
$!* For VMS/DECnet systems, this command file will be executed when a server
$!* connects to object named PCX$SERVER, number 0.  For VMS TCP/IP systems,
$!* this command file will be executed by the REXEC server.
$!*
$!* This command file is useful on other VMS systems that support DECwindows.
$!* The following commands show you how to install this program on other
$!* systems:
$!*
$!* To be able to remote start X applications from a VMS node using DECnet:
$!*  1. Login to the other VMS system using the SYSTEM account.
$!*  2. Rename or delete any older versions of PCX$SERVER.COM.  For example:
$!*     RENAME /LOG PCX$SERVER.COM;* PCX$SERVER.OLD;*
$!*  3. COPY /LOG node"user pass"::SYS$SYSTEM:PCX$SERVER.COM SYS$COMMON:[SYSEXE]
$!*  4. SET PROT=(S:RWED,O:RWED,G:RWED,W:RE) SYS$COMMON:[SYSEXE]PCX$SERVER.COM
$!*  5. NCP := $NCP
$!*  6. NCP DEFINE OBJECT PCX$SERVER FILE SYS$COMMON:[SYSEXE]PCX$SERVER.COM -
$!*     NUMBER 0
$!*  7. NCP SET OBJECT PCX$SERVER FILE SYS$COMMON:[SYSEXE]PCX$SERVER.COM -
$!*     NUMBER 0
$!*
$!* To be able to remote start X applications from a VMS node using TCP/IP
$!* perform steps 1 through 4 above.
$!*
$!************************************************************************
$!
$!  Cancel any symbols for dcl verbs we use
$   assign = "assign"
$   close = "close"
$   create = "create"
$   define = "define"
$   goto = "goto"
$   if = "if"
$   on = "on"
$   open = "open"
$   read = "read"
$   set = "set"
$   show = "show"
$   spawn = "spawn"
$   wait = "wait"
$   write = "write"
$!
$   set message /facility /identification /severity /text
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   First check for DECNET username and disallow:
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$   IF f$edit(f$getjpi("", "USERNAME"), "COLLAPSE") .EQS. "DECNET" THEN exit
$   ON warning THEN goto security_risk
$!
$  decnet_object = 0
$  is_DCL = 0
$  version_ge_53 = 0
$  version = "4"
$  version4 = "4"
$  version3 = "3"
$  server = "0"
$  screen = "0"
$!
$ IF "''VXT_LOGOUT'" .EQS. "" THEN VXT_LOGOUT = F$TRN("VXT$LOGOUT")
$ IF "''VXT_LOGIN_NORESTART'" .EQS. "" THEN VXT_LOGIN_NORESTART = F$TRN("VXT$LOGIN_NORESTART")
$ IF (VXT_LOGIN_NORESTART .EQS. "") .OR. VXT_LOGIN_NORESTART
$ THEN VXT_LOGIN_NORESTART = "TRUE"
$ ELSE VXT_LOGIN_NORESTART = "FALSE"
$ ENDIF
$ VXT$WSA = F$ELE(0,";",F$SEARCH("VXT$LIBRARY:VXT$WSA.EXE"))
$ IF VXT$WSA .EQS. ""
$ THEN
$    VXT$WSA = F$ELE(0,";",F$SEARCH(F$PARSE("VXT$WSA.EXE;",F$ENV("PROCEDURE"))))
$ ENDIF
$ DEFINE/NOLOG/USER DECW$LOGIN_NORESTART 'VXT_LOGIN_NORESTART'
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   If we got any command line parameters, this is the TCP/IP version
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$  if p1 .eqs. "" then decnet_object = 1
$  if decnet_object then goto open_DECnetlink
$  REM_TRAN := TCPIP
$!
$  set noon
$  if f$search( "sys$login:ucx$rexecd_startup.log;-10" ) .nes. "" then -
	purge /keep=6 /nolog ucx$rexecd_startup.log
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   Parse the command line parameters for TCP/IP
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$  vers = f$element( 0, ",", p1	)		! version number
$  server = f$element( 1, ",", p1 )		! server number
$  screen = f$element( 2, ",", p1 )		! screen number
$  tran = f$element( 3, ",", p1 )		! transport (TCPIP or DECnet)
$  node = f$element( 4, ",", p1	)		! Node name
$  cmd = p2					! Full Command
$  goto continue
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   Open the connection and redirect output
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$open_DECnetlink:
$  REM_TRAN := DECNET
$  ON error THEN goto shutdown
$  open /read /write pcx_server_link sys$net
$  set noon
$  if f$search( "sys$login:netserver.log;-10" ) .nes. "" then -
	purge /keep=6 /nolog netserver.log
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   Read a  command from the server
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$    read /end_of_file=shutdown /error=shutdown pcx_server_link cmd_string
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   Parse the command string (for v3 added version checking)
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$  vers = f$element(0, "," , cmd_string)      ! version number
$  if vers .NE. version4 then goto version3
$  server = f$element(1, ",", cmd_string)     ! server number
$  screen = f$element(2, ",", cmd_string)     ! screen number
$  tran = f$element(3, "," , cmd_string)      ! transport (TCP or DECnet)
$  node = f$element(4, "," , cmd_string)      ! Node name
$  cmdpos = f$locate( node, cmd_string ) + f$length( node ) + 1
$  cmd	= f$extract( cmdpos, 9999, cmd_string ) ! Full Command
$  goto continue
$version3:
$  if vers .NE. version3 then goto version2
$  version = "3"
$  tran = f$element(1, "," , cmd_string)      ! transport (TCP or DECnet)
$  node = f$element(2, "," , cmd_string)      ! Node name
$  cmd	= f$element(3, "," , cmd_string)      ! Full Command
$  goto continue
$version2:
$  version = "2"
$  node = f$element(0, "," , cmd_string)      ! Node name
$  cmd	= f$element(1, "," , cmd_string)      ! Full Command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$continue:
$  semic = f$locate( ";:;", cmd )             ! delimits VMS command
$  cmd = f$extract( 0, semic, cmd )		
$  exe = f$element( 0, " ", cmd )             ! Name of program or command file
$  rest_of_cmd = f$locate( " ", cmd )         ! Save the command-line parameters
$  params = f$extract( rest_of_cmd, f$length(cmd), cmd)
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   Check for DCL command - if first character is "$"
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$  dollar = f$locate("$", cmd)
$  IF dollar .eq. 0
$   THEN
$	is_DCL = 1
$	runfile = f$extract(1, f$length(cmd), cmd)
$	goto runit
$   ENDIF
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   Check to see if command is a .COM file in SYS$LOGIN and SYS$SYSTEM
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$  IF f$locate(".COM", f$edit(exe, "UPCASE"))  .lt. f$length(exe)
$  THEN
$	comfile1 = f$parse(exe, "", "sys$login:")
$	IF f$search(comfile1) .EQS. ""
$	THEN
$		comfile1 = f$parse(exe, "", "sys$system:")
$		if f$search(comfile1) .EQS. "" THEN  goto notfound
$	ENDIF
$	runfile :== @'comfile1''params'
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!  Check to see if command is an .EXE file in SYS$LOGIN and SYS$SYSTEM
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$  ELSE
$	runfile1 = f$parse(exe,".EXE","sys$login:")
$	IF f$search(runfile1) .EQS. ""
$	THEN
$		runfile1 = f$parse(exe,".EXE","sys$system:")
$		IF f$search(runfile1) .EQS. "" THEN goto notfound
$	ENDIF
$	if f$locate( ";", runfile1 ) .eq. f$length( runfile1 ) - 1 then -
$       	runfile1 = runfile1 - ";"
$!
$	runfile :== $'runfile1''params'
$  ENDIF
$  GOTO runit
$!
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! File not found error handler
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$notfound:
$  if decnet_object
$     then
$         write pcx_server_link "NOT FOUND"
$         close pcx_server_link
$     else
$         write sys$output "''cmd': not found"
$     endif
$  exit
$!
$runit:
$!
$  SET noon
$  DEFINE /nolog sys$error sys$output
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!   Parse the node name from the x.yyy format into xxxxx::
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! check for old version of PC DECwindows
$ if version .EQS. "2" then goto decnet_transport
$!
$! new version, check transport
$ if tran .EQS. "DECNET" then goto decnet_transport
$!
$! TCPIP Node - just use NODE as is
$ node_name = "''NODE'"
$! set display /create /node='NODE /server='server /screen='screen -
$!	/transport=tcpip 
$!
$ goto continue_transport
$!
$decnet_transport:
$! DECNET Node
$    area = f$element(0, ".", NODE)
$    address = f$element(1, ".", NODE)
$    node_name = area * 1024 + address
$!
$! DECnet define
$!    define decw$display 'node_name::'server.'screen
$!    set display /create /node='node_name /server='server /screen='screen -
$!	/transport=decnet
$!
$!
$continue_transport:
$ IF VXT$WSA .NES. ""
$ THEN
$    DEFINE/NOLOG/USER VXT$REM_NODE "''node_name'"
$    DEFINE/NOLOG/USER VXT$REM_TRAN 'REM_TRAN'
$    DEFINE/NOLOG/USER VXT$REM_SERVER 'server'
$    DEFINE/NOLOG/USER VXT$REM_SCREEN 'screen'
$    RUN 'VXT$WSA'
$    IF .NOT $STATUS
$    THEN
$	STATUS = $STATUS
$	WRITE SYS$ERROR "%VXT$SERVER-F-NODISPLAY, Failed to create display to node ''REM_NODE' transport ''REM_TRAN'"
$	GOTO shutdown
$    ENDIF
$ ELSE
$    SET DISPLAY/CREATE/NODE='node_name'/TRANSPORT='REM_TRAN'/server='server'-
	/screen='screen'
$ ENDIF
$ DEFINE/NOLOG/USER DECW$LOGIN_NORESTART 'VXT_LOGIN_NORESTART'
$!
$    ON error THEN goto kill_display
$    if decnet_object
$        then
$            SHOW DISPLAY
$            write pcx_server_link "OK"
$            close pcx_server_link
$            write sys$output -
			"PCX$SERVER_MSG: Starting the following application:"
$            write sys$output ''runfile
$        else
$            write sys$output "OK"
$        endif
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! Special case for DECterm terminal emulator
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$	vmsversion = F$GETSYI("VERSION")
$	version_number = F$EXTRACT(1,3,vmsversion)
$	IF version_number .GES. "5.3" THEN version_ge_53 = 1
$       IF version_number .LTS. "4.0" THEN version_ge_53 = 1 !for OpenVMS
$!
$	!if we started via REXEC, redirect application output to NULL
$	if .not. decnet_object
$          then
$             define /nolog sys$output nl:
$             define /nolog sys$error nl:
$          endif
$!
$	IF f$edit( f$parse(exe,,,"name","syntax_only"),"UPCASE") -
		   .EQS. "DECW$TERMINAL" THEN goto decterm_handler
$!
$	IF is_DCL .EQS. 1
$	THEN
$	   'runfile
$	ELSE
$	   runfile
$	ENDIF
$  GOTO good_bye
$!
$decterm_handler:
$	IF version_ge_53 .EQS. 1
$	THEN
$	   create /terminal /detach
$	   goto good_bye
$	ELSE
$!	  old decterm creation method - yuch!!!
$	  parent_proc = f$process()
$	  front = f$extract(0,4,parent_proc)
$	  back = f$extract(9,10,parent_proc)
$	  decterm_proc :== "''front'TERM''back'"
$	  spawn /nowait /process='decterm_proc' run sys$system:decw$terminal.exe
$	  runfile :== $sys$system:decw$mail_createDecterm.exe
$	  runfile
$!	  check the decnet link, stay active until link is dropped
$	  wait 00:00:30
$	  assign /user 'decterm_proc'1.lis sys$output
$	  mcr ncp show known links with node 'node
$	  assign /user 'decterm_proc'2.lis sys$output
$	  search 'decterm_proc'1.lis 'node
$	  open linkname 'decterm_proc'2.lis /error=nolink
$      loop:
$	   read /end_of_file=endfile linkname thisone
$	   if f$locate("''decterm_proc'", thisone) .eq. f$length(thisone) THEN -
			goto loop
$	   rightone = thisone
$      endfile:
$	   close linkname
$      nolink:
$	   delete 'decterm_proc'1.lis;,'decterm_proc'2.lis;
$	   rightone = f$edit(rightone,"TRIM,COMPRESS")
$	   show symbol rightone
$	   IF .not $status THEN goto good_bye
$!	   Loop, looking for connection to be terminated
$	   linknumber = f$element(0," ",rightone)
$      islinkthere:
$	   wait 00:07:00
$	   mcr ncp show link 'linknumber'
$	   IF $status THEN goto islinkthere
$	   write sys$output "Link has gone away"
$	   goto good_bye
$	ENDIF
$!
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! Shutdown connection
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$good_bye:
$ wait 0:00:30 				! let the DISPLAY live a while longer
$!
$! IF version_ge_53 .EQS. 1
$! THEN
$ !!! set display /delete
$! ELSE
$!    set display /noperm
$! ENDIF
$! exit
$kill_display:
$! IF version_ge_53 .EQS. 1
$! THEN
$!    set display /delete
$! ELSE
$!    set display /noperm
$! ENDIF
$shutdown:
$ if decnet_object then close pcx_server_link
$ exit
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! Security_risk (error occured, write a message and exit)
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$security_risk:
$  write sys$output -
   "PCX$SERVER_MSG: Error connecting to node (not allowed to LOGIN as DECNET)"
$  exit
$!
