$	saved_verify = 'f$verify(0.or.f$trnlnm("NCD_XINITREMOTE_VERIFY"))'
$	saved_control = f$environment("CONTROL")'
$	if f$mode().eqs."INTERACTIVE" then goto mode_interactive
$	goto mode_other
$!
$!  $NCDId: @(#)xinitremote.com,v 15.1 1993/07/14 05:37:44 dct Exp $
$!
$!	         Copyright 1990, 1991, 1992 Network Computing Devices.
$!	                        All rights reserved.
$!
$!  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$!  ONLY IN  ACCORDANCE WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
$!  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
$!  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
$!  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE IS  HEREBY
$!  TRANSFERRED.
$!
$!  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
$!  AND  SHOULD  NOT  BE  CONSTRUED AS  A COMMITMENT BY NETWORK COMPUTING
$!  DEVICES.
$!
$!		Network Computing Devices
$!		350 North Bernardo Ave
$!		Mountain View, Ca  94043
$!		(415)694-0650 
$!
$+++
$!  FACILITY:
$!
$!	XINITREMOTE.COM
$!
$!  ABSTRACT:
$!
$!	VAX/VMS Specific Xremote user initialization procedure
$!	This procedure is actually two distinct procedures
$!	called in different contexts.  The primary context is
$!	when invoked interactively by a user wishing to establish
$!	a remote X session to his NCD Display Station.  From this
$!	interactive invocation, a detach process is then created
$!	running this procedure, which therein performs its other
$!	role of running the DECwindows session manager.  
$!	
$!  ENVIRONMENT:
$!
$!	NCD Xremote - X over Serial 
$!
$!  AUTHOR:
$!
$!      Mark Pizzolato, Network Computing Devices
$!
$!  CREATION DATE:     23-Oct-1990
$!
$!  MODIFICATION HISTORY:
$!	03-Nov-1990 Mark Pizzolato
$!		complete reorganization to Not use the xset program which
$!		required the server to operate in "retain X settings" mode.
$!		and also had us transitioning in and out of X serial mode.
$!
$!	10-Jan-1991 Mark Pizzolato
$!	      - Added SYSGEN parameter checks to assure that Xremote will not
$!		attempt to start on a system that must be tuned first.
$!	      - Removed reference which allowed an alternate window manager to
$!		be specified via an argument to this procedure.  This
$!		functionality is properly achieved by a selection within the
$!		Session Manager's "Window" customization.
$!
$!	29-Mar-1991 Mark Pizzolato
$!	      - Cleaned up SYSGEN message generation to coordinate with base
$!		line release SYSGEN message strategy which was modeled from
$!		the work done here first.
$!
$!	22-Apr-1991 Mark Pizzolato
$!	      - Added mechanism to allow sets of resource files that are 
$!		Xremote specific: 
$!			DECW$XDEFAULTS_XREMOTE.DAT ->	DECW$XDEFAULTS.DAT
$!			DECW$SM_GENERAL_XREMOTE.DAT ->	DECW$SM_GENERAL.DAT
$!			DECW$SM_COLOR_XREMOTE.DAT ->	DECW$SM_COLOR.DAT
$!			DECW$SM_BW_XREMOTE.DAT ->	DECW$SM_BW.DAT
$!
$!	25-Apr-1991 Mark Pizzolato
$!	      - Added Support for the standard DECwindows specific system 
$!		wide and per user login procedures for Xremote.
$!	      - Added Copyright Message.
$!
$!	15-May-1991 Mark Pizzolato
$!	      - Added support for creation of a session manager (and window
$!		manager) log file(s) to help debug certain site configuration 
$!		problems that cause the session/window manager to fail prior 
$!		to starting.
$!
$!	21-Jan-1992 Mark Pizzolato
$!	      - Reorganized to deal with reasonable functionality under
$!		DECwindows Motif AS WELL AS DECwindows XUI.
$!	      - Moved SYSGEN parameter checking and all of the DECwindows
$!		Motif & XUI resource file processing from this DCL code into 
$!		the Xinitremote program.  This was done to facilitate
$!		reasonable startup and rundown performance.  Provisions have
$!		been made to allow a local site to customize the files and/or
$!		SYSGEN parameters that are checked as necessary - See Below.
$!--
$!/
$!
$!	Interactive (Primary) Procedure Call Arguments:
$!		P1 = alternate font set
$!		P2 thru P8 are passed unmodified to the Xremote helper program
$!
$!	Detached Procedure Call Arguments:
$!		none
$!
$!	Logicals that are used by the XREMOTE program include:
$!
$!	NCD_XREMOTE_SERVER_TRANSPORTS
$!				defines a list of transport names that
$!				XREMOTE is to establish the server using.
$!				If unspecified, LOCAL transport is all that
$!				is initialized, but may be defined to include
$!				other useful things like TCPIP, DECNET, etc.
$!	Debugging Support:
$!	NCD_XREMOTE_MBX_'PID'	'PID' is the process id of the processing
$!				running xremote. this logical defines a 
$!				mailbox which, when written to, will cause
$!				a DumpStats to be written to the log file
$!				for each line which is written to it.
$!	NCD_XREMOTE_LOG_FLUSH_INTERVAL
$!				set the interval (in seconds) that the log file
$!				is flushed, and the other debugging logical
$!				names are examined.  The default is 15 seconds.
$!	NCD_XREMOTE_DEBUG	sets the value of the "debug" variable used
$!				by main.c in xremote.
$!	NCD_XREMOTE_BSDEBUG	sets the value of the "BSdebug" variable used
$!				by bytestream.c, and bytestream_vms.c
$!	NCD_XREMOTE_DEBUGCOMPRESSION sets the value of the "debugCompression"
$!				variable used by bytestream.c
$!	NCD_XREMOTE_DEBUGPROTO	sets the value of the "debugProto" variable
$!				used by bytestream.c.
$!
$!	NCD_XREMOTE_SELECT_DEBUG sets the value of the "select_debug" variable
$!				used by vms_select.c.
$!
$!	NCD_XREMOTE_XPDEBUG	sets the value of the "XPdebug" variable
$!				used by vms_xport.c.
$!
$!	NCD_XINITREMOTE_DEBUG	sets the value of debug within xinitremote
$!				this causes various debug messages to be
$!				written to sys$login:ncd_xinitremote.log.
$!				bit 1 of this will cause the xinitremote to 
$!				not start the Xremote helper process and
$!				to wait for it to be started by some other
$!				means.  Bit 2 causes xinitremote to wait for
$!				the first Xevent and then to close it's display
$!				connection.  Bit 3 asks for a 2 second sleep
$!				prior opening the display variable.  Bit 4 
$!				causes the helper's Xremote stats to be 
$!				dumped just prior to the display variable 
$!				being opened.
$!
$! The Xremote program requires various privileges in the VMS environment.
$! these privs are required only to deal with the the various transports that
$! may be being used, but they ARE required for useful functionality:
$!	SYSNAM, TMPMBX, PRMMBX, SYSGBL, SYSPRV, NETMBX.
$! Normally the Xremote program will be installed with these privs at system
$! startup time.
$!
$
$mode_interactive:
$	set nocontrol=(T,Y)
$	set noon
$	path = f$parse(f$environment("PROCEDURE"),,,"DEVICE")+		-
		f$parse(f$environment("PROCEDURE"),,,"DIRECTORY")
$	say := write sys$output
$!
$!	Now we actually start up the Xremote helper
$!
$! We pass the helper process invocation command as part of the environment 
$! of the current process.  The setup program will spawn this command at the
$! appropriate time.
$!
$	xremote := $'path'xremote -line 'f$trnlnm("TT")' -scanmax 50 'p2' 'p3' 'p4' 'p5' 'p6' 'p7' 'p8'
$	if f$search("''path'xremote.exe").eqs.""
$	    then
$		say "%XINITREMOTE-E-NOHELPER, missing Xremote helper program: ''path'xremote.exe"
$		say "%XINITREMOTE-F-XREMOTELICENSE, check installation of NCD Xremote license"
$		exit_status = %x10000004
$		goto exit
$	endif
$!
$! Determine/Remember if we are running under DECwindows Motif.
$!
$	DECwindows_Motif =						-
			f$integer(f$search("SYS$SYSTEM:DECW$WSINIT.EXE").nes."")
$!
$!
$! pass this procedure's file spec to the setup program since this is used
$! later in it's other context to actually run the session manager.
$!
$	define/user/nolog NCD_DECW$SESSION 'f$environment("PROCEDURE")'
$!
$! pass along whether or not we are running in the DECwindows Motif environment.
$!
$	define/user/nolog NCD_DECWINDOWS_MOTIF 'DECwindows_Motif'
$!
$! pass the alternate font path and alternate window manager along as
$! logical names
$!
$	if p1.nes."" then define/user/nolog NCD_XREMOTE_FONTPATH 'p1'
$!
$! if we want to track the progress of the xinitremote program, we do so
$! based on the existence of the logical name NCD_XINITREMOTE_DEBUG so we
$! redirect SYS$ERROR to something that we can look at later. Also direct 
$! the session & window manager's output an actual files
$!
$	if f$trnlnm("NCD_XINITREMOTE_DEBUG").eqs.""
$	    then
$		define/user/nolog sys$error nla0:
$	    else
$		define/user/nolog sys$error sys$login:ncd_xinitremote.log
$		define/user/nolog DECW$SESSION_OUTPUT 		-
			'f$trnlnm("SYS$LOGIN")'NCD_XREMOTE_DECW$SM.LOG
$		define/user/nolog DECW$WINMGR_OUTPUT 		-
			'f$trnlnm("SYS$LOGIN")'NCD_XREMOTE_DECW$WM.LOG
$	endif
$	run 'path'xinitremote
#
#	This is the environment validation & customization control script
#
# The VMS system environment is validated to assure that sufficient resources 
# are available to run both Xremote AND the rest of a DECwindows environment.
#
SYSGEN_CHECK_MIN 	TTY_TYPAHDSZ	 1600
SYSGEN_CHECK_MIN 	TTY_ALTYPAHD	 1600
SYSGEN_CHECK_MIN 	PQL_MASTLM	  150
SYSGEN_CHECK_MIN 	PQL_MBIOLM	   60
SYSGEN_CHECK_MIN 	PQL_MDIOLM	   40
SYSGEN_CHECK_MIN 	PQL_MFILLM	  100
SYSGEN_CHECK_MIN 	PQL_MPRCLM	    8
SYSGEN_CHECK_MIN 	PQL_MBYTLM      45000
SYSGEN_CHECK_MIN 	PQL_MPGFLQUOTA  20000
SYSGEN_CHECK_MIN 	PQL_MTQELM	   20
SYSGEN_CHECK_MIN 	PQL_MWSQUOTA	  500
SYSGEN_CHECK_MIN 	PQL_DWSQUOTA	 1024
SYSGEN_CHECK_MIN 	PQL_DWSEXTENT	 4096
SYSGEN_CHECK_MIN 	GBLPAGES        30000
SYSGEN_CHECK_MIN 	GBLPAGFIL	 6024
SYSGEN_CHECK_MIN 	GBLSECTIONS	  400
SYSGEN_CHECK_MIN 	SPTREQ		 4096
SYSGEN_CHECK_MIN 	MAXBUF		 5000
SYSGEN_CHECK_MIN 	SWPOUTPGCNT	  500
SYSGEN_CHECK_MIN 	VIRTUALPAGECNT  20480
####
####
# 	Setup the Xremote Specific default resource environment.
####
#
# User Specific Standard Resource File
#
Standard_FILE		DECW$XDEFAULTS
#
# DECwindows Motif Specific Resource Files
#
DECwindows_Motif_FILE	DECW$PRINTSCREEN
DECwindows_Motif_FILE	DECW$PAUSESESSION
DECwindows_Motif_FILE	DECW$ENDSESSION
DECwindows_Motif_FILE	DECW$MESSAGEPANEL
DECwindows_Motif_FILE	DECW$SMB_KEYBOARD
DECwindows_Motif_FILE	DECW$SMB_WINMGR
DECwindows_Motif_FILE	DECW$SMB_SECURITY
DECwindows_Motif_FILE	DECW$SMB_LANGUAGE
DECwindows_Motif_FILE	DECW$SMB_POINTER
DECwindows_Motif_FILE	DECW$SMB_POINTER_COLOR
DECwindows_Motif_FILE	DECW$SMB_POINTER_GRAY
DECwindows_Motif_FILE	DECW$SMB_POINTER_BW
DECwindows_Motif_FILE	DECW$SMB_BACKGROUND
DECwindows_Motif_FILE	DECW$SMB_BACKGROUND_COLOR
DECwindows_Motif_FILE	DECW$SMB_BACKGROUND_GRAY
DECwindows_Motif_FILE	DECW$SMB_BACKGROUND_BW
DECwindows_Motif_FILE	DECW$SMB_WINDOW
DECwindows_Motif_FILE	DECW$SMB_WINDOW_COLOR
DECwindows_Motif_FILE	DECW$SMB_WINDOW_GRAY
DECwindows_Motif_FILE	DECW$SMB_WINDOW_BW
DECwindows_Motif_FILE	VUE$PROFILE.VUE$DAT	MODIFY
#
# DECwindows XUI Specific Resource Files
#
DECwindows_XUI_FILE	DECW$SM_GENERAL
DECwindows_XUI_FILE	DECW$SM_BW
DECwindows_XUI_FILE	DECW$SM_COLOR
#
#	End of environment validation & customization control script
#(((*)))
$	exit_status = $status
$	goto exit
$!

$!
$! this part of this procedure is used to run the session manager as a 
$! detached process.  Logically it is a completely different procedure
$! from the above stuff, but things are simpler if we have less files
$! to keep track of.
$!
$mode_other:
$mode_detach:
$mode_batch:
$!
$! Determine/Remember if we are running under DECwindows Motif.
$!
$	DECwindows_Motif =						-
			f$integer(f$search("SYS$SYSTEM:DECW$WSINIT.EXE").nes."")
$	if DECwindows_Motif
$	    then
$		say = "write sys$output "
$	    else
$		say = "write sys$error "
$	endif
$	exit_status = ""
$!
$! if no command files executed, then status will be blank
$!

$	if $status .EQS. "" then goto do_session
$!
$! if status is ok, no errors in command procedures, so start session manager
$!
$	if  $status then goto do_session
$!
$! if error on entry, then check if error came while doing session manager.
$! sys$input points to this file, so errors will cause process to re-enter
$! with an error status
$!
$	exit_status = $status
$	if f$trnlnm("decw$doing_session") .EQS. "T" then goto do_exit
$!
$! start the session manager - and set logical that remembers this
$!
$do_session:
$!
$! make sure that the whole job family knows about the display variable
$!
$	if .not.DECwindows_Motif
$	    then
$		say "Setting DECW$DISPLAY to: ''f$getdvi("sys$output","FULLDEVNAM")'"
$		define/job/exec decw$display 'f$getdvi("sys$output","FULLDEVNAM")'
$	endif
$!
$! here's where the site's and user's DECwindows specific login procedures
$! actually get executed in the normal sequence of things so if they exist
$! then run them.  Normally, the system wide SYLOGIN, and user personal
$! LOGIN are not executed in this context when not running with DECwindows
$! Motif, so we conditionally run them.
$!
$	set noon
$	if DECwindows_Motif
$	    then
$		syloginname = f$trnlnm("SYS$SYLOGIN",		-
					"LNM$SYSTEM_TABLE",,"EXECUTIVE")
$		if syloginname.nes.""
$		    then
$			say "Executing System SYLOGIN: ''syloginname'"
$			@'syloginname
$		endif
$		if f$search("SYS$LOGIN:LOGIN.COM").nes.""
$		    then
$			say "Executing User LOGIN: ''f$search("SYS$LOGIN:LOGIN.COM")'"
$			@SYS$LOGIN:LOGIN.COM
$		endif
$		!
$		! DECwindows Motif performs the resource property on the
$		! root window in this context, so we do it now to emulate that.
$		!
$		sessioninit = f$trnlnm("DECW$SESSIONINIT")
$		if sessioninit.nes.""
$		    then
$			say "Executing Session Init: ''sessioninit'"
$			'sessioninit
$		endif
$		!
$		! DECwindows Motif allows for a logical name to specify the
$		! system wide DECwindows login procedure, with an explicit
$		! fallback to SYS$MANAGER:DECW$SYLOGIN.COM as before.
$		!
$		decwsyloginname = f$trnlnm("DECW$SYLOGIN",		-
					   "LNM$SYSTEM_TABLE",,"EXECUTIVE")
$		if (decwsyloginname.eqs."")
$		    then
$			decwsyloginname = f$search("SYS$MANAGER:DECW$SYLOGIN.COM")
$		endif
$		if decwsyloginname.nes.""
$		    then
$			say "Executing DECW$SYLOGIN: ''decwsyloginname'"
$			@'decwsyloginname 
$		endif
$	    else
$		if f$search("SYS$MANAGER:DECW$SYLOGIN.COM").nes.""
$		    then
$			say "Executing SYS$MANAGER:DECW$SYLOGIN.COM"
$			@SYS$MANAGER:DECW$SYLOGIN.COM
$		endif
$	endif
$	if f$search("SYS$LOGIN:DECW$LOGIN.COM").nes.""
$	    then
$		say "Executing SYS$LOGIN:DECW$LOGIN.COM"
$	        @SYS$LOGIN:DECW$LOGIN.COM
$	endif
$	set on
$!
$! flag the fact that we are running the Session Manager (I don't know why this
$! is necessary, but DEC does it in the workstation case, so we'll do it also)
$!
$	define decw$doing_session T
$	ws = f$trnlnm("DECW$SM_WSQUOTA")
$	if ws .NES. "" then set working_set/quota='ws'/nolog
$	if DECwindows_Motif
$	    then
$		sessionmain = f$trnlnm("DECW$SESSIONMAIN")
$		if sessionmain.nes.""
$		    then
$			say "Executing Session Manager with: ''sessionmain'"
$			'sessionmain
$		endif
$	    else
$		say "Executing Session Manager: SYS$SYSTEM:DECW$SESSION.EXE"
$		run sys$system:decw$session
$	endif
$	exit_status = $status
$!
$! DECwindows Motif allows for a Session End procedure, so once again, we
$! emulate that.
$!
$	if DECwindows_Motif
$	    then
$		sessionend = f$trnlnm("DECW$SESSIONEND")
$		if sessionend.nes.""
$		    then
$			say "Executing Session End with: ''sessionend'"
$			'sessionend
$		endif
$	endif
$do_exit:
$!
$! tear ourselves down
$!
$	stop/id=0
$
$mode_network:
$exit:	if saved_control.nes."" then set control=('saved_control')
$	exit 'exit_status'	! 'f$verify(saved_verify)'
