
/*++

Copyright (c) 1996  Digital Equipment Corporation

Module Name:

    types.h

Abstract:

    This header defines basic types.

Author:

    Hy Pham  [DEC] 7-Nov-96

Revision History:

--*/

#ifndef _TYPES_H_
#define _TYPES_H_

//
// Data Types
//

#ifndef IN
#define IN
#define OUT
#endif

#ifndef NULL
#define	NULL	0
#endif

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

#ifndef VOID         //defined  in ddk\inc\miniport.h or minitape.h or ntdef.h 
#define VOID    void
typedef signed char      CHAR;           //  8 bits    signed
typedef unsigned char    UCHAR;          //  8 bits  unsigned
typedef signed short     SHORT;          // 16 bits    signed
typedef unsigned short   USHORT;         // 16 bits  unsigned
typedef signed long      LONG;           // 32 bits    signed
typedef unsigned long    ULONG;          // 32 bits  unsigned
typedef __int64          LONGLONG;       // 64 bits    signed
typedef unsigned __int64 ULONGLONG;      // 64 bits  unsigned

typedef UCHAR            BOOLEAN;	
typedef USHORT           WCHAR;

typedef union{
    struct {
        ULONG LowPart;
        LONG HighPart;
    };
    struct {
        ULONG LowPart;
        LONG HighPart;
    } u;
    LONGLONG QuadPart;
} LARGE_INTEGER,*PLARGE_INTEGER;         

typedef VOID *PVOID;
typedef CHAR *PCHAR;
typedef UCHAR *PUCHAR;
typedef LONG *PLONG;
typedef ULONG *PULONG;
typedef SHORT *PSHORT;
typedef USHORT *PUSHORT;
typedef WCHAR *PWCHAR;

#endif \\ void    

#ifndef _SIZE_T_DEFINED
typedef unsigned int   size_t;
#endif

#ifndef _FPOS_T_DEFINED
typedef __int64         fpos_t;         // to match arc seek requirement.
#else
#undef _FPOS_T_DEFINED
typedef __int64         fpos_t; 
#endif

#ifndef _OFF_T_DEFINED
typedef __int64         off_t;  
#else
#undef _OFF_T_DEFINED
typedef __int64         off_t;  
#endif

#ifndef _TIME_T_DEFINED      
typedef int            time_t;
#endif

#ifndef _CLOCK_T_DEFINED
typedef __int64        clock_t;
#else
#undef _OFF_T_DEFINED
typedef __int64        clock_t; 
#endif

typedef LONGLONG         quad_t;
typedef ULONGLONG        u_quad_t;
typedef LONG ARC_STATUS;


#endif // _TYPES_H_ 
