//////////////////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Class Library - CDX.lib ]
// Source File:    [ CDXMenu Implementation ]
// Author:         [ Bil Simser - bsimser@home.com ]
// Revision:       [ 1.99b ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXMenu Default Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXMenu::CDXMenu()
{
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMenu Constructor
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::Create(CDXSurface *pSurface, int Spacing)
{
	m_Spacing = Spacing;
	m_ItemCount = 0;
	m_CurrentItem = 0;
	m_pSurface = pSurface;
	m_bWrap = TRUE;
	ZeroMemory(&m_Title, sizeof(m_Title));
}

//////////////////////////////////////////////////////////////////////////////////
// Sets the wrapping capabilities of the menu
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::SetWrap(BOOL bWrap)
{
	m_bWrap = bWrap;
}

//////////////////////////////////////////////////////////////////////////////////
// Sets the title used by the menu (optional)
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::SetTitle(const char *szTitle, COLORREF color)
{
	strcpy(m_Title.m_szTitle, szTitle);
	m_Title.m_color = color;
	m_Title.m_bActive = TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// Adds an item to the menu
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::AddItem(char *szString, COLORREF oncolor, COLORREF offcolor)
{
	strcpy(m_MenuItems[m_ItemCount].m_szString, szString);
	m_MenuItems[m_ItemCount].m_OnColor = oncolor;
	m_MenuItems[m_ItemCount].m_OffColor = offcolor;
	m_ItemCount++;
}

//////////////////////////////////////////////////////////////////////////////////
// Returns the current menu item
//////////////////////////////////////////////////////////////////////////////////
int CDXMenu::Enter()
{
	return m_CurrentItem;
}

//////////////////////////////////////////////////////////////////////////////////
// Sets the current item to the first on in the menu
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::Home()
{
	m_CurrentItem = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// Moves up one menu option. If wrapping is enabled, wraps to the last item
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::Up()
{
	m_CurrentItem--;
	if(m_CurrentItem < 0) {
		if(m_bWrap) {
			End();
		}
		else {
			Home();
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////
// Moves down one menu option. If wrapping is enabled, wraps to the first item
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::Down()
{
	m_CurrentItem++;
	if(m_CurrentItem > (m_ItemCount-1)) {
		if(m_bWrap) {
			Home();
		}
		else {
			End();
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////
// Sets the last menu item as the current one
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::End()
{
	m_CurrentItem = m_ItemCount - 1;
}

//////////////////////////////////////////////////////////////////////////////////
// Draws the menu to the surface specified in the constructor
//////////////////////////////////////////////////////////////////////////////////
void CDXMenu::Draw(int X, int Y)
{
	COLORREF col;

	m_pSurface->GetDC();
	m_pSurface->SetFont();

	if(m_Title.m_bActive) {
		m_pSurface->TextXY(X, Y, m_Title.m_color, m_Title.m_szTitle);
	}

	for(int i=0; i<m_ItemCount; i++) {
		col = (i == m_CurrentItem) ? m_MenuItems[i].m_OnColor : m_MenuItems[i].m_OffColor;
		if(m_Title.m_bActive) {
			m_pSurface->TextXY(X, Y+((i+1)*m_Spacing), col, m_MenuItems[i].m_szString);
		}
		else {
			m_pSurface->TextXY(X, Y+(i+1*m_Spacing), col, m_MenuItems[i].m_szString);
		}
	}

	m_pSurface->ReleaseDC();
}
