//////////////////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Class Library - CDX.lib ]
// Source File:    [ CDXSound Implementation ]
// Author:         [ Bil Simser - bsimser@home.com ]
// Contributions:  [ Dan Farley ]
// Revision:       [ 1.99a ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXSound Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXSound::CDXSound()
{
	m_lpDS = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSound Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXSound::~CDXSound()
{
	if(m_lpDS) m_lpDS->Release();
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSound Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSound::Create(void *hWnd)
{
	HRESULT rval;

	rval = DirectSoundCreate(NULL, &m_lpDS, NULL);
	if(rval != DS_OK) DSError(rval, hWnd);

	rval = m_lpDS->SetCooperativeLevel((HWND)hWnd, DSSCL_NORMAL);
	if(rval != DS_OK) DSError(rval, hWnd);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSound GetCaps
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSound::GetCaps(void)
{
	HRESULT rval;

	rval = m_lpDS->GetCaps(&m_DSCaps);
	if(rval != DS_OK) return FALSE;

	return TRUE;
}
