/* getlogin for Novell + DOS */

/* by Rich Braun @ Kronos, 1991/03/13 */
/* further hacking by Paul Eggert and Frank Whaley */

	/* $Id: logindos.c,v 1.2 1992/01/06 03:18:25 eggert Exp $ */

#include <dos.h>
#include <string.h>
#include <process.h>

#pragma pack(1)
#define MAXPATHNAMELEN 128

/* Invoke the Novell API.  */
#define novell_API(function, args, results, regsin, regsout, segregs) ( \
	(regsin).h.ah = (function), \
	(regsin).x.si = (unsigned short)(args), \
	(regsin).x.di = (unsigned short)(results), \
	intdosx(&(regsin), regsout, segregs) \
)


/* system call definitions */

/* Get Connection Information E3(16) */
struct _gcireq {
	unsigned short len;
	unsigned char func;
	unsigned char number;
};
struct _gcirep {
	unsigned short len;
	unsigned long objectID;
	unsigned short objecttype;
	char objectname[48];
	unsigned char logintime[7];
	unsigned char reserved[39];
};

/* Scan File Information E3(0F) */
struct _sfireq {
	unsigned short len;
	unsigned char func;
	unsigned short seq;
	char handle;
	unsigned char attrib;
	unsigned char pathlen;
	char path[MAXPATHNAMELEN];
};
struct _fileinfo {
	unsigned char attrib;
	unsigned char xattrib;
	unsigned long size;
	unsigned short cdate;
	unsigned short adate;
	unsigned long utime;
	unsigned long ownerID;
	unsigned long atime;
	char res[56];
};
struct _sfirep {
	unsigned short len;
	unsigned short seq;
	char filename[14];
	struct _fileinfo info;
};

/* Set File Information E3(10) */
struct _setfireq {
	unsigned short len;
	unsigned char func;
	struct _fileinfo info;
	unsigned char handle;
	unsigned char search;
	unsigned char pathlen;
	unsigned char path[MAXPATHNAMELEN];
};
struct _setfirep {
	unsigned short len;
};

/* Scan Directory for Trustees E2(0C) */
struct _sdftreq {
	unsigned short len;
	unsigned char func;
	unsigned char handle;
	unsigned char seq;
	unsigned char pathlen;
	char path[MAXPATHNAMELEN];
};
struct _sdftrep {
	unsigned short len;
	char name[16];
	unsigned long ctime;
	unsigned long ownerID;
	unsigned long trustee[5];
	unsigned char rights[5];
};

/* Scan Directory Information E2(02) */
struct _sdireq {
	unsigned short len;
	unsigned char func;
	unsigned char handle;
	unsigned short seq;
	unsigned char pathlen;
	char path[MAXPATHNAMELEN];
};
struct _sdirep {
	unsigned short len;
	char name[16];
	unsigned long ctime;
	unsigned long ownerID;
	unsigned char rights;
	unsigned char res;
	unsigned short dirnum;
};

#pragma pack()

	char *
getlogin()
{
	/* These are static because we assume segment register DS.  */
	static struct _gcirep gcirep;
	static struct _gcireq gcireq;

	union REGS r;
	struct SREGS s;

	/* Load Get Connection Number function code.   */
	r.x.ax = 0xDC00;
	intdos(&r, &r);

	/*
	 * If the connection number is in range 1-100,
	 * invoke Get Connection Information to get the user name.
	 */
	if (0 < r.h.al  &&  r.h.al <= 100) {
		gcireq.len = sizeof(gcireq)-sizeof(gcireq.len);
		gcireq.func = 0x16;
		gcireq.number = r.h.al;
		gcirep.len = sizeof(gcirep)-sizeof(gcirep.len);
		segread(&s);
		novell_API(0xE3, &gcireq, &gcirep, r, &r, &s);
		if (r.h.al == 0) {
			strlwr(gcirep.objectname);
			return gcirep.objectname;
		}
	}
	return 0;
}
