// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com







#include "bochs.h"




  void
BX_CPU_C::enter_protected_mode(void)
{
// bx_printf("processor switching into PROTECTED mode!!!\n");
// debug(BX_CPU_THIS_PTR prev_eip);
  if (v8086_mode()) bx_panic("protect_ctrl: v8086 mode unsupported\n");

  if (bx_dbg.reset)
    bx_printf("processor switching into PROTECTED mode!!!\n");

if ( BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].selector.rpl!=0 || BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].selector.rpl!=0 )
  bx_panic("enter_protected_mode: CS or SS rpl != 0\n");
}


  void
BX_CPU_C::enter_real_mode(void)
{
// ???
// bx_printf("processor switching into REAL mode!!!\n");
// debug(BX_CPU_THIS_PTR prev_eip);
  if (v8086_mode()) bx_panic("protect_ctrl: v8086 mode unsupported\n");

  if (bx_dbg.reset)
    bx_printf("processor switching into REAL mode!!!\n");

if ( BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].selector.rpl!=0 || BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].selector.rpl!=0 )
  bx_panic("enter_real_mode: CS or SS rpl != 0\n");
}
