// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//  US Mail:  Kevin Lawton
//            439 Marrett Rd.
//            Lexington, MA 02421-7714
//
//  EMail:    bochs@world.std.com


// Header file for low-level OS specific CDROM emulation


class cdrom_interface {
public:
  cdrom_interface(char *dev);
  ~cdrom_interface(void);

  // Load CD-ROM. Returns false if CD is not ready.
  bool insert_cdrom();

  // Logically eject the CD.
  void eject_cdrom();

  // Read CD TOC. Returns false if start track is out of bounds.
  bool read_toc(uint8* buf, int* length, bool msf, int start_track);

  // Return CD-ROM capacity (in 2048 byte frames)
  uint32 capacity();

  // Read a single block from the CD
  void read_block(uint8* buf, int lba);

private:
  int fd;
  char *path;
  };
