// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com

// eth.cc  - helper code to find and create pktmover classes

// Peter Grehan (grehan@iprg.nokia.com) coded all of this
// NE2000/ether stuff.

#include "bochs.h"

eth_locator_c *eth_locator_c::all;

//
// Each pktmover module has a static locator class that registers
// here 
//
eth_locator_c::eth_locator_c(const char *type)
{
  next = all;
  all  = this;
  this->type = type;
}

//
// Called by ethernet chip emulations to locate and create a pktmover
// object
//
eth_pktmover_c *
eth_locator_c::create(const char *type, const char *netif,
		      const char *macaddr,
		      eth_rx_handler_t rxh, void *rxarg)
{
#ifdef eth_static_constructors
  for (eth_locator_c *p = all; p != NULL; p = p->next) {
    if (strcmp(type, p->type) == 0)
      return (p->allocate(netif, macaddr, rxh, rxarg));
  }
#else
  eth_locator_c *ptr = 0;

#ifdef ETH_NULL
  {
    extern bx_null_match;
    if (!strcmp(type, "null"))
      ptr = (eth_locator_c *) &bx_null_match; 
  }
#endif
#ifdef ETH_FBSD
  {
    extern bx_fbsd_match;
    if (!strcmp(type, "fbsd"))    
      ptr = (eth_locator_c *) &bx_fbsd_match;
  }
#endif
#ifdef ETH_TEST
  {
    extern bx_test_match;
    if (!strcmp(type, "test"))    
      ptr = (eth_locator_c *) &bx_test_match;
  }
#endif
  if (ptr)
    return (ptr->allocate(netif, macaddr, rxh, rxarg));
#endif

  return (NULL);
}
