// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com



#define BX_MAX_G2H_CHANNELS 8
#define BX_G2H_ERROR        ((unsigned) -1)
  // IO port number for this interface.  Align on dword boundary.
#define BX_G2H_PORT  0x2000
  // Magic number which is first dword passed by guest
#define BX_G2H_MAGIC 0xffeeddcc
  // Number of dwords in packet from guest
#define BX_G2H_PACKET_SIZE 5



typedef Bit32u bx_guest_packet_t[BX_G2H_PACKET_SIZE];
typedef void (*bx_g2h_callback_t)(bx_guest_packet_t *);



class bx_g2h_c {
public:
  bx_g2h_c(void);
  ~bx_g2h_c(void);
  static void   init(bx_devices_c *d);
  unsigned aquire_channel(bx_g2h_callback_t);
  unsigned deaquire_channel(unsigned channel);

private:

  static Bit32u inp_handler(void *this_ptr, Bit32u addr, unsigned io_len);
  static void   outp_handler(void *this_ptr, Bit32u addr,
                              Bit32u value, unsigned io_len);
  // state info
  struct {
    struct {
      bx_g2h_callback_t f;
      Boolean used;
      } callback[BX_MAX_G2H_CHANNELS];

    // Define the data received from the guest OS.
    //   dword0: magic number, should be BX_G2H_MAGIC
    //   dword1: channel ID
    //   dword2: address of data structure in guest physical memory
    //   dword3: size of data structure in guest physical memory
    //   dword4: address of return data structure in guest physical memory
    unsigned packet_count;
    bx_guest_packet_t guest_packet;
    } s;
  };

extern bx_g2h_c bx_g2h;
