// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com




#include "bochs.h"



#if BX_USE_PAR_SMF
bx_parallel_c bx_parallel;
#define this (&bx_parallel)
#endif



bx_parallel_c::bx_parallel_c(void)
{
  // nothing for now
}

bx_parallel_c::~bx_parallel_c(void)
{
  // nothing for now
}

  void
bx_parallel_c::init(bx_devices_c *d)
{
  BX_PAR_THIS devices = d;

#if 0
  /* PARALLEL PORT 1 */

  BX_PAR_THIS devices->register_irq(7, "Parallel Port 1");
  for (unsigned addr=0x03BC; addr<=0x03BE; addr++) {
    BX_PAR_THIS devices->register_io_read_handler(this,
       read_handler,
       addr, "Parallel Port 1");
    BX_PAR_THIS devices->register_io_write_handler(this,
       write_handler,
       addr, "Parallel Port 1");
    }
#endif
}



  // static IO port read callback handler
  // redirects to non-static class handler to avoid virtual functions

  Bit32u
bx_parallel_c::read_handler(void *this_ptr, Bit32u address, unsigned io_len)
{
#if !BX_USE_PAR_SMF
  bx_parallel_c *class_ptr = (bx_parallel_c *) this_ptr;

  return( class_ptr->read(address, io_len) );
}


  Bit32u
bx_parallel_c::read(Bit32u address, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif  // !BX_USE_PAR_SMF
  UNUSED(address);
  UNUSED(io_len);

  /* PARALLEL PORT 1 */
  return(0);
}


  // static IO port write callback handler
  // redirects to non-static class handler to avoid virtual functions

  void
bx_parallel_c::write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len)
{
#if !BX_USE_PAR_SMF
  bx_parallel_c *class_ptr = (bx_parallel_c *) this_ptr;

  class_ptr->write(address, value, io_len);
}

  void
bx_parallel_c::write(Bit32u address, Bit32u value, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif  // !BX_USE_PAR_SMF
  UNUSED(address);
  UNUSED(value);
  UNUSED(io_len);
  /* PARALLEL PORT 1 */
}
