// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com


#if BX_USE_PAR_SMF
#  define BX_PAR_SMF  static
#  define BX_PAR_THIS bx_parallel.
#else
#  define BX_PAR_SMF
#  define BX_PAR_THIS this->
#endif




class bx_parallel_c {
public:

  bx_parallel_c(void);
  ~bx_parallel_c(void);
  BX_PAR_SMF void   init(bx_devices_c *);

private:

  struct {
    unsigned unused;  // filler for now
    } s;

  bx_devices_c *devices;

  static Bit32u read_handler(void *this_ptr, Bit32u address, unsigned io_len);
  static void   write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len);
#if !BX_USE_PAR_SMF
  Bit32u read(Bit32u address, unsigned io_len);
  void   write(Bit32u address, Bit32u value, unsigned io_len);
#endif
  };


#if BX_USE_PAR_SMF
extern bx_parallel_c bx_parallel;
#endif
