//
// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// This file (SOUNDLNX.H) written and donated by Josef Drexler
// 
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//     
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//     
//     EMail:    bochs@world.std.com
//


#if defined(linux)

#include "bochs.h"

#define WRITELOG        sb16->writelog
#define BOTHLOG(x)      (x)
#define MIDILOG(x)      ((bx_options.sb16.midimode>0?x:0x7f))
#define WAVELOG(x)      ((bx_options.sb16.wavemode>0?x:0x7f))

#define BX_SOUND_LINUX_BUFSIZE   BX_SOUND_OUTPUT_WAVEPACKETSIZE

class bx_sound_linux_c : public bx_sound_output_c {
public:
  bx_sound_linux_c(bx_sb16_c *sb16);
  BX_SOUND_VIRTUAL ~bx_sound_linux_c();

  // if virtual functions are used, we have to override them
  // and define our own. Otherwise this file will just implement
  // the original functions
#ifdef BX_USE_SOUND_VIRTUAL
  BX_SOUND_VIRTUAL int    waveready();
  BX_SOUND_VIRTUAL int    midiready();

  BX_SOUND_VIRTUAL int    openmidioutput(char *device);
  BX_SOUND_VIRTUAL int    sendmidicommand(int delta, int command, int length, Bit8u data[]);
  BX_SOUND_VIRTUAL int    closemidioutput();

  BX_SOUND_VIRTUAL int    openwaveoutput(char *device);
  BX_SOUND_VIRTUAL int    startwaveplayback(int frequency, int bits, int stereo, int format);
  BX_SOUND_VIRTUAL int    sendwavepacket(int length, Bit8u data[]);
  BX_SOUND_VIRTUAL int    stopwaveplayback();
  BX_SOUND_VIRTUAL int    closewaveoutput();
#endif

private:
  bx_sb16_c *sb16;
  FILE *midi;
  char *wavedevice;
  int wave;
  int bufferpos;
  Bit8u audio_buffer[BX_SOUND_LINUX_BUFSIZE];
  int oldfreq,oldbits,oldstereo,oldformat;
};

#endif  // defined(linux)
