//
// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com


// Classes for helping to make checkpoints of the emulator state.

#ifndef _STATE_FILE_H
#define _STATE_FILE_H
#include <stdio.h>
#include <stddef.h>


class state_file {
public:
  FILE *file;

  FILE *get_handle();
  void write(Bit8u);
  void write(Bit16u);
  void write(Bit32u);
  void write(Bit64u);
  void write(const void*, size_t);
  void read(Bit8u &);
  void read(Bit16u &);
  void read(Bit32u &);
  void read(Bit64u &);
  void read(void *, size_t);
  void write_check(const char *);
  void read_check (const char *);

  state_file (const char *name, const char *options);
  state_file (FILE *f);
  ~state_file();
};

#endif  // #ifndef _STATE_FILE_H
