@rem = '--*-Perl-*--';
@rem = '
@echo off
if not exist src\ntt\perl.exe goto perlnotthere
@echo src\ntt\perl.exe exists, copying into current directory
del /f perl.exe
copy src\ntt\perl.exe .
:perlnotthere
if exist perl.exe goto perlhere
echo Could not find Perl interpreter!!
echo *gasp* *wheez* *choke*
pause
goto endofperl 
:perlhere
cmd /c perl %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
@rem ';

@INC = 'lib';

#(c) 1995 Microsoft Corporation. All rights reserved. 
#        Developed by hip communications inc., http://info.hip.com/info/

print <<'--end--';
This install script assumes that you have unpacked NT Perl into the final
intended destination directory. It will copy the executable and batch files
into a separate directory, but all documentation and libraries remain where
they currently are. Do you wish to proceed? [Y/n]
--end--
$in = <STDIN>;
until ( $in eq "\n" || $in =~ /^y/i ) {
	exit if ( $in =~ /^no?\n$/i );
	print "Do you wish to proceed? [Y/n]";
	$in = <STDIN>;
}


chop( $perldir = `cd` );

$libdir = $perldir . '\lib';
$docdir = $perldir . '\docs';

$perldir =~ s/\\5\.001//;
$bindir = $perldir . '\bin';

require 'ctime.pl' || warn $!;

$date = ctime( time );

( $myversion ) = grep( /perl[^\d]*(\d\.\d\.?\d\.?\d)/, `perl -v` );
( $myversion ) = $myversion =~ /perl[^\d]*(\d\.(\d\.?)+)/;


open ( LOG, '>>install.log' ) || warn "Couldn't open log file!\n";

&log( $date );

sub log {
    ( $message ) = @_;
    print LOG $message;
    print $message;
}

sub gripe {
    ( $message ) = @_;
    print LOG $message;
    warn $message;
}

if ( -d $bindir ) {
    &log( "$bindir exists\n" );
} else {
    &log( "creating $bindir\n" );
    mkdir( $bindir, 0 ) || die $!;
}

&log( "Installing Windows NT Perl into $perldir\n" );

if ( -f "$bindir\\perl.exe" ) {
    ( $version ) = grep( /perl[^\d]*(\d\.\d\.?\d\.?\d)/, `$bindir\\perl -v` );
    ( $version ) = $version =~ /perl[^\d]*(\d\.(\d\.?)+)/;
    &log( "Previous version $version exists in bin directory,\n" );
    &log( "Renaming it to perl.$version.exe\n" );
    rename "$bindir\\perl.exe", "$bindir\\perl.$version.exe";
}

&log( "Copying over perl and utility scripts to $bindir\n" );

`copy src\\ntt\\perlglob.exe .` if ( -e 'src/ntt/perlglob.exe' );
`copy perl.exe $bindir`;
`copy perlglob.exe $bindir`;
`copy mkolex.bat $bindir`;
`copy pl2bat.bat $bindir`;

require 'NT.ph' || die "Unable to locate lib/NT.ph!! Installation aborted.\n";

NTRegCreateKeyEx( &HKEY_LOCAL_MACHINE, 'SOFTWARE\Microsoft\Resource Kit\PERL5',
    &NULL, 'NT Perl 5', &REG_OPTION_NON_VOLATILE, &KEY_ALL_ACCESS, &NULL,
    $hkey, $disposition ) ?
    &log( "Added key for Perl 5 to NT Registry Database..\n" ):
    &gripe( "Couldn't add key for Perl 5 to NT Registry Database!!\n" );

if ( $disposition  == &REG_OPENED_EXISTING_KEY ) {
    &gripe( "Key exists already, modifying existing key...\n" );
}

NTRegSetValueEx( $hkey, 'BIN', &NULL, &REG_SZ, "$bindir" ) ?
    &log( "Adding $bindir to script path information\n" ):
    &gripe( "Couldn't add script path to registry!!\n" );

NTRegSetValueEx( $hkey, 'PRIVLIB', &NULL, &REG_SZ, "$libdir" ) ?
    &log( "Adding $libdir to library include path information\n" ):
    &gripe( "Couldn't add library path to registry!!\n" );

NTRegSetValueEx( $hkey, 'HTML-DOCS', &NULL, &REG_SZ, "$docdir" ) ?
    &log( "Adding $docdir to documentation directory\n" ) :
    &gripe( "Couldn't add documentation directory to registry!!\n" );

NTRegCloseKey( $hkey );

$fred = 'Bill Gates is a sexy surfing hunk';

until ( $fred =~ /^(y|n)/i || $fred eq '' ) {
    print "Modify search path? [Y/n]";
    chop( $fred = <STDIN> );
}

unless ( $fred =~ /^n/i ) {
    NTRegOpenKeyEx ( &HKEY_LOCAL_MACHINE,
        'SYSTEM\CurrentcontrolSet\control\Session Manager\Environment',
        &NULL, &KEY_ALL_ACCESS, $hkey ) ?
        &log( "Retrieving Path information from session manager\n" ):
        &gripe( "Couldn't retrieve path information from session manager!!\n" );

    NTRegQueryValueEx( $hkey, 'Path', &NULL, $type, $pathstring );

    $pathstring =
        ".;$bindir;" . join (';', grep(!/(perl|\.)/i, split(/;/, $pathstring))) . ";";

    NTRegSetValueEx( $hkey, 'Path', &NULL, $type, $pathstring ) ?
        &log( "Updated path information in session manager\n" ):
        &gripe( "Couldn't update path information in session manager!!\n" );
    NTRegCloseKey( $hkey );
}    

&log( "Perl $myversion installation finished.\n" );

__END__
:endofperl
