#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

# browse --
# This script generates a directory browser, which lists the working
# directory and allows you to open files or subdirectories by
# double-clicking.
#
# SCCS: @(#) browse 1.8 96/02/16 10:49:18

# Create a scrollbar on the right side of the main window and a listbox
# on the left side.

scrollbar .scroll -command ".list yview"
pack .scroll -side right -fill y
listbox .list -yscroll ".scroll set" -relief sunken -width 20 -height 20 \
	-setgrid yes
pack .list -side left -fill both -expand yes
wm minsize . 1 1

# The procedure below is invoked to open a browser on a given file;  if the
# file is a directory then another instance of this program is invoked; if
# the file is a regular file then the Mx editor is invoked to display
# the file.

proc browse {dir file} {
    global env
    if {[string compare $dir "."] != 0} {set file $dir/$file}
    if [file isdirectory $file] {
	exec browse $file &
    } else {
	if [file isfile $file] {
	    if [info exists env(EDITOR)] {
		eval exec $env(EDITOR) $file &
	    } else {
		exec xedit $file &
	    }
	} else {
	    puts stdout "\"$file\" isn't a directory or regular file"
	}
    }
}

# Fill the listbox with a list of all the files in the directory (run
# the "ls" command to get that information).

if $argc>0 {set dir [lindex $argv 0]} else {set dir "."}
foreach i [exec ls -a $dir] {
    .list insert end $i
}

# Set up bindings for the browser.

bind all <Control-c> {destroy .}
bind .list <Double-Button-1> {foreach i [selection get] {browse $dir $i}}
