#
#
# Copyright (C) 1995 Christopher M Sedore
#
# This code may be modified and reused for any purpose.
#
# Setowner.tcl sample program 
#
#


load ntsys.dll ntsys


proc dialog {message } {
  global mc;
  
  set w .t[incr mc]
  set wmsg .t[set mc].msg

  toplevel $w
  message $wmsg -width 30 -text $message
  button .b -text "OK" -command "destroy $w"
}



proc setowner {} {
  global filename owner status

  if { [expr ![string compare $filename ""] || ![ string compare $owner "" ]]} {
   set status "Please fill in the owner and filename fields" 
   return
  }

  NT_AssertPrivilege SeRestorePrivilege
  if {[catch {set secd [  NT_CreateSecurityDescriptor $owner {} {} {} ]} msg] } {
    set status "NT_CreateSecurityDescriptor failed: $msg"
    return 
  }
  if {[catch {NT_SetFileSecurity $secd OWNER_SECURITY_INFORMATION $filename}]} {
    set status "NT_SetFileSecurity failed"
    NT_FreeStructure $secd
    return
  }

  NT_FreeStructure $secd

  set status "Successful!"

}

wm command . "SetOwner"
wm title . "SetOwner"

frame .fn 
label .fn.lf -text "Filename:" 
entry .fn.fe -width 64 -textvariable filename
pack .fn.lf -anchor w -side left 
pack .fn.fe -side right -anchor e
frame .fo
label .fo.lo -text "New owner:"
entry .fo.oe -width 64 -textvariable owner
pack .fo.lo -side left -anchor w
pack .fo.oe -side right -anchor e
frame .fs
label .fs.st -text "Status from last command:"
entry .fs.ste -textvariable status
pack .fs.st -side left -anchor w
pack .fs.ste -side right -anchor e -fill x -expand 1
pack .fn .fo .fs -expand 1 -fill x
button .b -text "Do it!" -command {setowner } 
pack .b 

set mc 0
