proc oClassExists {className} {
    global __oClasses
    return [info exists __oClasses($className)]
}
proc oObjExists {objectName} {
    global __oObjects
    return [info exists __oObjects($objectName)]
}
proc oVarExists {objectName varName} {
    global $objectName
    return [info exists [format %s(%s) $objectName $varName]]
}
proc oType {objectName} {
    global __oObjects
    if [oObjExists $objectName] {
    	return $__oObjects($objectName)
    } else {
        error [format {No such object as ^"%s^".} $objectName]
    }
}
proc oParentOf {classList className} {
	global __oClasses
	foreach class $classList {
		if [string compare $class $className] {
			return 1
		}
		set parents $__oClasses($class)
		if {[string compare $parents {}]} {
			if [oChildOf $parents $className] {
				return 1
			}
		}
	}
	return 0
}
proc oTypeOf {className objectName} {
	if [oClassExists $className] {
    	return [oParentOf [oType $objectName] $className]
	} else {
		error [format {No such class as ^"%s^".} $className]
	}
}
proc oSet {objectName varName varValue} {
    global $objectName
    if [oObjExists $objectName] {
	    set [format %s(%s) $objectName $varName] $varValue
	    return $varValue
    } else {
        error [format {No such object as ^"%s^".} $objectName]
    }
}
proc oGet {objectName varName} {
    global $objectName
    if [oObjExists $objectName] {
	    return [set [format %s(%s) $objectName $varName]]
    } else {
        error [format {No such object as ^"%s^".} $objectName]
    }
}
proc oClass {className classDefinition {superClass {}}} {
    global __oClasses
    if {0 == [string compare $className {}]
        || (-1 != [string first :: $className])} {
        error [format {Invalid class name ^"%s^".} $className]
    }
    if [oClassExists $className] {
        error [format {Class ^"%s^" already defined.} $className]
    }
    foreach sClass $superClass {
        if {! [oClassExists $sClass]} {
            error [format {Superclass ^"%s^" not defined.} $sClass]
        }
    }
    try {
        set n [llength $classDefinition]
        for {set i 0} {$i < $n} {incr i 3} {
            set ip1 [expr {$i + 1}]
            set ip2 [expr {$i + 2}]
            set methodName [lindex $classDefinition $i]
            if {-1 != [string first :: $methodName]} {
                error [format {^"%s^" is an invalid method name.} $methodDame]
            }
            proc [format %s::%s $className $methodName] ^
                [lindex $classDefinition $ip1] ^
                [lindex $classDefinition $ip2]
        }
    } catch errorString {
        foreach methodName [info procs [format %s::* $className]] {
            rename $methodName {}
        }
        error $errorString
    }
    set __oClasses($className) $superClass
}
proc oMethod {classNames methodName} {
    global __oClasses __oThisClass
    foreach class $classNames {
        set method $class::$methodName
        if {[string compare [info procs $method] {}]} {
            set __oThisClass $class
            return $method
        }
        set superClasses $__oClasses($class)
        if {[string compare $superClasses {}]} {
            set method [oMethod $superClasses $methodName]
            if {[string compare $method {}]} {
                return $method
            }
        }
    }
    return
}
proc oNew {objectName className {args {}}} {
    global oThis __oObjects __oThisClass
    if [oObjExists $objectName] {
        error [foramt {Object ^"%s^" already exists.} $objectName]
    }
    if {! [oClassExists $className]} {
        error [format {Class ^"%s^" is not defined.} $className]
    }
    set method $className::$className
    if {0 == [string compare [info procs $method] {}]} {
        if {1 < [llength $args]} {
            error [format {Invalid object initialization for object ^"%s^".} $objectName]
        }
        set vars [lindex $args 0]
        set n [llength $vars]
        for {set i 0} {$i < $n} {incr i 2} {
            set var [lindex $vars $i]
            set val [lindex $vars [expr {$i + 1}]]
            set [format %s(%s) $objectName $var] $val
        }
    } {
        set tmpThisClass $__oThisClass
        set tmpThis $oThis
        set __oThisClass $className
        set oThis $objectName
        set err [catch {eval [concat $method $args]} errorString]
        set oThis $tmpThis
        set __oThisClass $tmpThisClass
        if {$err} {
            error $errorString {} $err
        }
    }
    set __oObjects($objectName) $className
}
proc oDestroy {objectName {args {}}} {
    global oThis __oObjects __oThisClass $objectName
    set class [oType $objectName]
    set method $class::~$class
    if {[string compare [info procs $method] {}]} {
        set tmpThisClass $__oThisClass
        set __oThisClass $class
        set tmpThis $oThis
        set oThis $objectName
        set err [catch {eval [concat $method $args]} errorString]
        set oThis $tmpThis
        set __oThisClass $tmpThisClass
        if {$err} {
            error $errorString {} $err
        }
    }
    if {0 == [string compare $args {}]} {
        unset __oObjects($objectName) $objectName
    } {
        error {Invalid arguments.}
    }
}
proc oSend {objectName methodName {args {}}} {
    global oThis __oThisClass
    set class [oType $objectName]
    set tmpThisClass $__oThisClass
    set method [oMethod $class $methodName]
    if {0 == [string compare $method {}]} {
        error [format {Method ^"%s^" is not defined for object ^"%s^".} $methodName $objectName]
    }
    set tmpThis $oThis
    set oThis $objectName
    set err [catch {eval [concat $method $args]} retval]
    set oThis $tmpThis
    set __oThisClass $tmpThisClass
    if {$err} {
        error $retval {} $err
    }
    return $retval
}
proc oInherited {methodName {args {}}} {
    global oThis __oClasses __oThisClass
    if [[string compare __oThisClass {}]] {
	    set superClass $__oClasses($__oThisClass)
	    set tmpThisClass $__oThisClass
	    set method [oMethod $superClass $methodName]
	   	if {0 == [string compare $method {}]} {
	        error [format {Inherited method ^"%s^" is not defined for object ^"%s^".} $methodName $oThis]
	    }
	    set err [catch {eval [concat $method $args]} retval]
	    set __oThisClass $tmpThisClass
	    if {$err} {
	        error $retval {} $err
	    }
	    return $retval
    } else {
    	error "oInherited only defined within methods"
    }
}
global oThis __oClasses __oObjects __oThisClass
set oThis {}
set __oThisClass {}
