//**
//**  AQMAPII.H:  Internal AQM API functions
//**
//**  The functions in this header file would normally be included in
//**  AQMAPI.H, but they are not intended to be exposed to third parties.
//**

// JobSummary (JobSumm)
//
typedef struct _JobSumm
	{
	struct _JobSumm* JobSummFlink;
	struct _JobSumm* JobSummBlink;
	DWORD JobNumber;
	unsigned long QueueNumber;
	FILETIME AfterTime;
	} JobSumm;

typedef struct _QE
	{
	CRITSEC CriticalSection;
	BOOL MarkDel;
	HANDLE hQueueChangeEvent;
	JobSumm* QeHoldingFlink;
	JobSumm* QeHoldingBlink;
	JobSumm* QePendingFlink;
	JobSumm* QePendingBlink;
	AQM_QUEUE_INFO info;
	PSECURITY_DESCRIPTOR pSD;
	} QE;

typedef struct _THREAD_LIST_ENTRY	// THREAD LIST ENTRY
   {
   DWORD   Tid;	// ... THREAD ID
   DWORD   Pid;	// ... PROCESS ID
   HANDLE  hThread;	// ... THREAD HANDLE
   struct _THREAD_LIST_ENTRY * pNext;	// ... POINTER TO NEXT ENTRY
   } THREAD_LIST_ENTRY;

typedef struct _EXEC_JOB	// EXECUTING JOB STRUCTURE
   {
   QE     *pQE;	// ... POINTER TO QUEUE THAT JOB IS IN
   HANDLE  hPrimaryProcess;	// ... HANDLE OF JOB'S PRIMARY PROCESS
   struct            	// ... ARRAY FOR SUBPROCESS INFORMATION
      {
      HANDLE  handle;	//     ... PROCESS HANDLE
      DWORD   id;	//     ... PROCESS ID
      } sp [MAX_JOB_SUBPROCESSES];
   THREAD_LIST_ENTRY * pThreadList;	// ... POINTER TO THREAD LIST
   LI      CpuCompl;   	// ... CPU TIME FOR ALL COMPLETED PROCESSES IN JOB
   DWORD   StatusAfterCompl;	// ... STATUS TO SET AFTER COMPLETION
   DWORD   ReasonAfterCompl;	// ... STATUS REASON TO SET AFTER COMPLETION
	// ... ACCOUNT NAME OF USER WHO ABORTED JOB
   TCHAR   AccountName [AQM_ACCOUNT_NAME_SIZE];
   } EXEC_JOB;


//  JOB ENTRY STRUCTURE
//
//  This structure is the internal representation of a job.  Job entries
//  are stored in linked lists attached to queue entries.
//
typedef struct _JE	// JOB ENTRY STRUCTURE
   {
   JINFO   info;	// ... JOB INFO
   PSECURITY_DESCRIPTOR pSD;	// ... POINTER TO SECURITY DESCRIPTOR
   EXEC_JOB * pExec;	// ... POINTER TO EXECUTING JOB INFO
   } JE;

DWORD   AqmInitiateLink (	// INITIATE LINK
        LPCSTR  ServerName,	// > SERVER NAME
        DBOOL   DumpInitialState,	// > TRUE = DUMP INITIAL STATE
        HPIPE  *rhPipe);	// * HANDLE TO PIPE WITH LINK

