//**
//**  COMMON MESSAGES
//**
//**  The messages defined in this file are common between all modules
//**  if the product.  This file defines the messages for the errors
//**  that may be set in the reply packets sent by the queue manager
//**  service.
//**
//**
//**  HEADER SECTION
//**
//**
//**  MESSAGE DEFINITIONS
//**
//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//


//
// MessageId: AQMERR_SUCCESS
//
// MessageText:
//
//  No error.
//
#define AQMERR_SUCCESS                   ((DWORD)0x00000000L)

//
// MessageId: AQMERR_UNHANDLED_SERVICE_ERROR
//
// MessageText:
//
//  An unhandled error occurred in the AQM service while carrying out the work request.
//  Please have an administrator check the System Event Log on the AQM server computer.
//
#define AQMERR_UNHANDLED_SERVICE_ERROR   ((DWORD)0x00000001L)

//
// MessageId: AQMERR_SYSTEM_ACCESS_DENIED
//
// MessageText:
//
//  Access to the system is denied.
//
#define AQMERR_SYSTEM_ACCESS_DENIED      ((DWORD)0x00000002L)

//
// MessageId: AQMERR_QUEUE_ACCESS_DENIED
//
// MessageText:
//
//  Access to queue denied.
//
#define AQMERR_QUEUE_ACCESS_DENIED       ((DWORD)0x00000003L)

//
// MessageId: AQMERR_JOB_ACCESS_DENIED
//
// MessageText:
//
//  Access to job denied.
//
#define AQMERR_JOB_ACCESS_DENIED         ((DWORD)0x00000004L)

//
// MessageId: AQMERR_ACCESS_DENIED_TO_JOB_IN_QUEUE
//
// MessageText:
//
//  Access to one or more jobs in the queue is denied.
//
#define AQMERR_ACCESS_DENIED_TO_JOB_IN_QUEUE ((DWORD)0x00000005L)

//
// MessageId: AQMERR_ACCESS_DENIED_TO_REQUEUE_QUEUE
//
// MessageText:
//
//  Access to the queue specified for requeuing jobs to is denied.
//
#define AQMERR_ACCESS_DENIED_TO_REQUEUE_QUEUE ((DWORD)0x00000006L)

//
// MessageId: AQMERR_DUPL_QUEUE_NAME
//
// MessageText:
//
//  Duplicate queue name.
//
#define AQMERR_DUPL_QUEUE_NAME           ((DWORD)0x00000007L)

//
// MessageId: AQMERR_INVALID_QUEUE_NAME
//
// MessageText:
//
//  Invalid queue name.
//
#define AQMERR_INVALID_QUEUE_NAME        ((DWORD)0x00000008L)

//
// MessageId: AQMERR_RETAIN_COMPLETED_INVALID
//
// MessageText:
//
//  The length of time to retain completed jobs is invalid.
//
#define AQMERR_RETAIN_COMPLETED_INVALID  ((DWORD)0x00000009L)

//
// MessageId: AQMERR_QUEUE_FULL
//
// MessageText:
//
//  The queue is full.
//
#define AQMERR_QUEUE_FULL                ((DWORD)0x0000000AL)

//
// MessageId: AQMERR_QUEUE_CLOSED
//
// MessageText:
//
//  The queue is closed.
//
#define AQMERR_QUEUE_CLOSED              ((DWORD)0x0000000BL)

//
// MessageId: AQMERR_JOB_ALREADY_IN_QUEUE
//
// MessageText:
//
//  The job is already in the queue.
//
#define AQMERR_JOB_ALREADY_IN_QUEUE      ((DWORD)0x0000000CL)

//
// MessageId: AQMERR_NO_SUCH_JOB
//
// MessageText:
//
//  No such job exists.
//
#define AQMERR_NO_SUCH_JOB               ((DWORD)0x0000000DL)

//
// MessageId: AQMERR_JOB_EXECUTING
//
// MessageText:
//
//  The job is executing.
//
#define AQMERR_JOB_EXECUTING             ((DWORD)0x0000000EL)

//
// MessageId: AQMERR_JOB_NOT_EXECUTING
//
// MessageText:
//
//  The job is not executing.
//
#define AQMERR_JOB_NOT_EXECUTING         ((DWORD)0x0000000FL)

//
// MessageId: AQMERR_NO_SUCH_QUEUE
//
// MessageText:
//
//  No such queue exists.
//
#define AQMERR_NO_SUCH_QUEUE             ((DWORD)0x00000010L)

//
// MessageId: AQMERR_FILE_ALREADY_EXISTS
//
// MessageText:
//
//  The file already exists.
//
#define AQMERR_FILE_ALREADY_EXISTS       ((DWORD)0x00000011L)

//
// MessageId: AQMERR_INVALID_FILENAME
//
// MessageText:
//
//  The filename is invalid.
//
#define AQMERR_INVALID_FILENAME          ((DWORD)0x00000012L)

//
// MessageId: AQMERR_NO_DEFAULT_QUEUE
//
// MessageText:
//
//  No default queue is defined.
//
#define AQMERR_NO_DEFAULT_QUEUE          ((DWORD)0x00000013L)

//
// MessageId: AQMERR_INVALID_QUEUE_PRIORITY
//
// MessageText:
//
//  Invalid queue priority.
//
#define AQMERR_INVALID_QUEUE_PRIORITY    ((DWORD)0x00000014L)

//
// MessageId: AQMERR_PENDING_JOBS_LIMIT_TOO_HIGH
//
// MessageText:
//
//  The pending jobs limit is too high.
//
#define AQMERR_PENDING_JOBS_LIMIT_TOO_HIGH ((DWORD)0x00000015L)

//
// MessageId: AQMERR_EXECUTING_JOBS_LIMIT_TOO_HIGH
//
// MessageText:
//
//  The executing jobs limit is too high.
//
#define AQMERR_EXECUTING_JOBS_LIMIT_TOO_HIGH ((DWORD)0x00000016L)

//
// MessageId: AQMERR_QUEUE_ALREADY_STARTED
//
// MessageText:
//
//  The queue is already started.
//
#define AQMERR_QUEUE_ALREADY_STARTED     ((DWORD)0x00000017L)

//
// MessageId: AQMERR_QUEUE_ALREADY_STOPPED
//
// MessageText:
//
//  The queue is already stopped.
//
#define AQMERR_QUEUE_ALREADY_STOPPED     ((DWORD)0x00000018L)

//
// MessageId: AQMERR_QUEUE_ALREADY_OPEN
//
// MessageText:
//
//  The queue is already open.
//
#define AQMERR_QUEUE_ALREADY_OPEN        ((DWORD)0x00000019L)

//
// MessageId: AQMERR_QUEUE_ALREADY_CLOSED
//
// MessageText:
//
//  The queue is already closed.
//
#define AQMERR_QUEUE_ALREADY_CLOSED      ((DWORD)0x0000001AL)

//
// MessageId: AQMERR_SYSTEM_ALREADY_PAUSED
//
// MessageText:
//
//  The system is already paused.
//
#define AQMERR_SYSTEM_ALREADY_PAUSED     ((DWORD)0x0000001BL)

//
// MessageId: AQMERR_SYSTEM_NOT_PAUSED
//
// MessageText:
//
//  The system is not paused.
//
#define AQMERR_SYSTEM_NOT_PAUSED         ((DWORD)0x0000001CL)

//
// MessageId: AQMERR_SYSTEM_PAUSED
//
// MessageText:
//
//  The system is paused.
//
#define AQMERR_SYSTEM_PAUSED             ((DWORD)0x0000001DL)

//
// MessageId: AQMERR_NO_SUCH_REQUEUE_QUEUE
//
// MessageText:
//
//  The queue specified to requeue jobs to does not exist.
//
#define AQMERR_NO_SUCH_REQUEUE_QUEUE     ((DWORD)0x0000001EL)

//
// MessageId: AQMERR_REQUEUE_QUEUE_CLOSED
//
// MessageText:
//
//  The queue specified to requeue jobs to is closed.
//
#define AQMERR_REQUEUE_QUEUE_CLOSED      ((DWORD)0x0000001FL)

//
// MessageId: AQMERR_REQUEUE_QUEUE_FULL
//
// MessageText:
//
//  The queue specified to requeue jobs to is full.
//
#define AQMERR_REQUEUE_QUEUE_FULL        ((DWORD)0x00000020L)

//
// MessageId: AQMERR_QUEUE_AND_REQUEUE_QUEUE_SAME
//
// MessageText:
//
//  Jobs cannot be requeued to the same queue that is being deleted; queue not deleted.
//
#define AQMERR_QUEUE_AND_REQUEUE_QUEUE_SAME ((DWORD)0x00000021L)

//
// MessageId: AQMERR_LOG_SIZE_LIMIT_TOO_LARGE
//
// MessageText:
//
//  The specified product log file size limit is too large.
//
#define AQMERR_LOG_SIZE_LIMIT_TOO_LARGE  ((DWORD)0x00000022L)

//
// MessageId: AQMERR_LOG_SIZE_LIMIT_TOO_SMALL
//
// MessageText:
//
//  The specified product log file size limit is too small.
//
#define AQMERR_LOG_SIZE_LIMIT_TOO_SMALL  ((DWORD)0x00000023L)

//
// MessageId: AQMERR_MAX_LINKS_EXIST
//
// MessageText:
//
//  The maximum number of links already exist.
//
#define AQMERR_MAX_LINKS_EXIST           ((DWORD)0x00000024L)

//
// MessageId: AQMERR_QUEUE_SYSTEM_FULL
//
// MessageText:
//
//  The queue system is full.
//
#define AQMERR_QUEUE_SYSTEM_FULL         ((DWORD)0x00000025L)

//
// MessageId: AQMERR_UNTERMINATED_STRING
//
// MessageText:
//
//  An unterminated string was passed as a parameter.
//
#define AQMERR_UNTERMINATED_STRING       ((DWORD)0x00000026L)

//
// MessageId: AQMERR_UNABLE_TO_OPEN_OR_CREATE_FILE
//
// MessageText:
//
//  Unable to open or create the file.
//
#define AQMERR_UNABLE_TO_OPEN_OR_CREATE_FILE ((DWORD)0x00000027L)

//
// MessageId: AQMERR_INVALID_LOG_SIZE_LIMIT
//
// MessageText:
//
//  The log size limit is invalid.
//
#define AQMERR_INVALID_LOG_SIZE_LIMIT    ((DWORD)0x00000028L)

//
// MessageId: AQMERR_INVALID_RETAIN_TIME
//
// MessageText:
//
//  The queue job retention time is invalid.
//
#define AQMERR_INVALID_RETAIN_TIME       ((DWORD)0x00000029L)

//
// MessageId: AQMERR_EVERY_TIME_WITHOUT_AFTER_TIME
//
// MessageText:
//
//  An "Every" time was specified without an "After" time.
//
#define AQMERR_EVERY_TIME_WITHOUT_AFTER_TIME ((DWORD)0x0000002AL)

//
// MessageId: AQMERR_JOB_FILE_FILE_NOT_FOUND
//
// MessageText:
//
//  The job file was not found.
//
#define AQMERR_JOB_FILE_FILE_NOT_FOUND   ((DWORD)0x0000002BL)

//
// MessageId: AQMERR_JOB_FILE_ACCESS_DENIED
//
// MessageText:
//
//  The user does not have permission to access the job file.
//
#define AQMERR_JOB_FILE_ACCESS_DENIED    ((DWORD)0x0000002CL)

//
// MessageId: AQMERR_JOB_FILE_INVALID
//
// MessageText:
//
//  The job file is invalid. 
//
#define AQMERR_JOB_FILE_INVALID          ((DWORD)0x0000002DL)

//
// MessageId: AQMERR_JOB_FILE_NETWORK_LOGON_NOT_GRANTED
//
// MessageText:
//
//  The user is not granted network logon access to the system where the job file is located.
//
#define AQMERR_JOB_FILE_NETWORK_LOGON_NOT_GRANTED ((DWORD)0x0000002EL)

//
// MessageId: AQMERR_JOB_FILE_PATH_NOT_FOUND
//
// MessageText:
//
//  The job file path was not found.
//
#define AQMERR_JOB_FILE_PATH_NOT_FOUND   ((DWORD)0x0000002FL)

//
// MessageId: AQMERR_JOB_FILE_BAD_NET_NAME
//
// MessageText:
//
//  The filename of the job file contains a bad or invalid network name.
//
#define AQMERR_JOB_FILE_BAD_NET_NAME     ((DWORD)0x00000030L)

//
// MessageId: AQMERR_UNHANDLED_ERROR_CHECKING_JOB_FILE
//
// MessageText:
//
//  The AQM service cannot access the job file.  Check the System Event Log on the AQM server computer for details.
//
#define AQMERR_UNHANDLED_ERROR_CHECKING_JOB_FILE ((DWORD)0x00000031L)

//
// MessageId: AQMERR_FAILURE_JOB_FILE_NOT_FOUND
//
// MessageText:
//
//  The failure job file was not found.
//
#define AQMERR_FAILURE_JOB_FILE_NOT_FOUND ((DWORD)0x00000032L)

//
// MessageId: AQMERR_FAILURE_JOB_ACCESS_DENIED
//
// MessageText:
//
//  The user does not have permission to access the failure job file.
//
#define AQMERR_FAILURE_JOB_ACCESS_DENIED ((DWORD)0x00000033L)

//
// MessageId: AQMERR_FAILURE_JOB_INVALID
//
// MessageText:
//
//  The failure job file is invalid. 
//
#define AQMERR_FAILURE_JOB_INVALID       ((DWORD)0x00000034L)

//
// MessageId: AQMERR_FAILURE_JOB_NETWORK_LOGON_NOT_GRANTED
//
// MessageText:
//
//  The user is not granted network logon access to the system where the failure job file is located.
//
#define AQMERR_FAILURE_JOB_NETWORK_LOGON_NOT_GRANTED ((DWORD)0x00000035L)

//
// MessageId: AQMERR_FAILURE_JOB_PATH_NOT_FOUND
//
// MessageText:
//
//  The failure job file path was not found.
//
#define AQMERR_FAILURE_JOB_PATH_NOT_FOUND ((DWORD)0x00000036L)

//
// MessageId: AQMERR_FAILURE_JOB_BAD_NET_NAME
//
// MessageText:
//
//  The filename of the failure job contains a bad or invalid network name.
//
#define AQMERR_FAILURE_JOB_BAD_NET_NAME  ((DWORD)0x00000037L)

//
// MessageId: AQMERR_UNHANDLED_ERROR_CHECKING_FAILURE_JOB
//
// MessageText:
//
//  The AQM service cannot access the failure job file.  Check the System Event Log on the AQM server computer for details.
//
#define AQMERR_UNHANDLED_ERROR_CHECKING_FAILURE_JOB ((DWORD)0x00000038L)

//
// MessageId: AQMERR_SUCCESS_JOB_FILE_NOT_FOUND
//
// MessageText:
//
//  The success job files was not found.
//
#define AQMERR_SUCCESS_JOB_FILE_NOT_FOUND ((DWORD)0x00000039L)

//
// MessageId: AQMERR_SUCCESS_JOB_ACCESS_DENIED
//
// MessageText:
//
//  The user does not have permission to access the success job file.
//
#define AQMERR_SUCCESS_JOB_ACCESS_DENIED ((DWORD)0x0000003AL)

//
// MessageId: AQMERR_SUCCESS_JOB_INVALID
//
// MessageText:
//
//  The success job file is invalid. 
//
#define AQMERR_SUCCESS_JOB_INVALID       ((DWORD)0x0000003BL)

//
// MessageId: AQMERR_SUCCESS_JOB_NETWORK_LOGON_NOT_GRANTED
//
// MessageText:
//
//  The user is not granted network logon access to the system where the success job file is located.
//
#define AQMERR_SUCCESS_JOB_NETWORK_LOGON_NOT_GRANTED ((DWORD)0x0000003CL)

//
// MessageId: AQMERR_SUCCESS_JOB_PATH_NOT_FOUND
//
// MessageText:
//
//  The success job file path was not found.
//
#define AQMERR_SUCCESS_JOB_PATH_NOT_FOUND ((DWORD)0x0000003DL)

//
// MessageId: AQMERR_SUCCESS_JOB_BAD_NET_NAME
//
// MessageText:
//
//  The filename of the success job contains a bad or invalid network name.
//
#define AQMERR_SUCCESS_JOB_BAD_NET_NAME  ((DWORD)0x0000003EL)

//
// MessageId: AQMERR_UNHANDLED_ERROR_CHECKING_SUCCESS_JOB
//
// MessageText:
//
//  The AQM service cannot access the success job file.  Check the System Event Log on the AQM server computer for details.
//
#define AQMERR_UNHANDLED_ERROR_CHECKING_SUCCESS_JOB ((DWORD)0x0000003FL)

//
// MessageId: AQMERR_SIDS_DO_NOT_MATCH
//
// MessageText:
//
//  The user's SID does not match the SID created by logging on the user at the AQM server computer.
//
#define AQMERR_SIDS_DO_NOT_MATCH         ((DWORD)0x00000040L)

//
// MessageId: AQMERR_NO_DOMAIN_CONTROLLER
//
// MessageText:
//
//  No domain controller is available to log on the user at the AQM server computer.
//
#define AQMERR_NO_DOMAIN_CONTROLLER      ((DWORD)0x00000041L)

//
// MessageId: AQMERR_LOGON_NOT_GRANTED
//
// MessageText:
//
//  AQM was unable to log on the user because the logon was not granted by the local security policy on the AQM server computer.
//
#define AQMERR_LOGON_NOT_GRANTED         ((DWORD)0x00000042L)

//
// MessageId: AQMERR_LOGON_TYPE_NOT_GRANTED
//
// MessageText:
//
//  AQM was unable to log on the user because the logon type was not granted by the local security policy on the AQM server computer.
//  If the job has a password, then the "Log on locally" user right is required.
//  If the job has no password, then the "Log on as a batch job" user right is required.
//
#define AQMERR_LOGON_TYPE_NOT_GRANTED    ((DWORD)0x00000043L)

//
// MessageId: AQMERR_LOGON_FAILURE
//
// MessageText:
//
//  The AQM service was unable to log on the user on the AQM server computer.  The password or other information may be incorrect.
//
#define AQMERR_LOGON_FAILURE             ((DWORD)0x00000044L)

//
// MessageId: AQMERR_ACCOUNT_RESTRICTION
//
// MessageText:
//
//  The AQM service was unable to log on the user on the AQM server computer because of a policy restriction on the user's account.
//
#define AQMERR_ACCOUNT_RESTRICTION       ((DWORD)0x00000045L)

//
// MessageId: AQMERR_AUTHENTICATION_PACKAGE_NOT_FOUND
//
// MessageText:
//
//  The AQM service was unable to log on the user on the AQM server computer because the authentication package was not found.
//
#define AQMERR_AUTHENTICATION_PACKAGE_NOT_FOUND ((DWORD)0x00000046L)

//
// MessageId: AQMERR_UNHANDLED_LOGON_ERROR
//
// MessageText:
//
//  The AQM service was unable to log on the user on the AQM server computer because of an unhandled logon error.
//  Check the System Event Log on the AQM server computer for more information.
//
#define AQMERR_UNHANDLED_LOGON_ERROR     ((DWORD)0x00000047L)

//
// MessageId: AQMERR_SD_NOT_VALID
//
// MessageText:
//
//  The security descriptor is not valid.
//
#define AQMERR_SD_NOT_VALID              ((DWORD)0x00000048L)

//
// MessageId: AQMERR_NO_DACL_PRESENT
//
// MessageText:
//
//  The security descriptor does not contain a discretionary access control list.
//
#define AQMERR_NO_DACL_PRESENT           ((DWORD)0x00000049L)

//
// MessageId: AQMERR_SD_NOT_SELF_RELATIVE
//
// MessageText:
//
//  The security descriptor is not in self-relative format.
//
#define AQMERR_SD_NOT_SELF_RELATIVE      ((DWORD)0x0000004AL)

//
// MessageId: AQMERR_QUEUE_CONTAINS_EXECUTING_JOBS
//
// MessageText:
//
//  The queue contains one or more executing jobs.
//
#define AQMERR_QUEUE_CONTAINS_EXECUTING_JOBS ((DWORD)0x0000004BL)

//
// MessageId: AQMERR_INVALID_STARTUP_JOB_NUMBER
//
// MessageText:
//
//  The startup job number is invalid.
//
#define AQMERR_INVALID_STARTUP_JOB_NUMBER ((DWORD)0x0000004CL)

//
// MessageId: AQMERR_INVALID_STARTUP_JOB_CONDITION
//
// MessageText:
//
//  The startup job condition is invalid.
//
#define AQMERR_INVALID_STARTUP_JOB_CONDITION ((DWORD)0x0000004DL)

//
// MessageId: AQMERR_INVALID_STARTUP_JOB_TIME_LIMIT
//
// MessageText:
//
//  The startup job time limit is invalid.
//
#define AQMERR_INVALID_STARTUP_JOB_TIME_LIMIT ((DWORD)0x0000004EL)

//
// MessageId: AQMERR_STARTUP_JOB_FILE_FILE_NOT_FOUND
//
// MessageText:
//
//  The startup job file was not found.
//
#define AQMERR_STARTUP_JOB_FILE_FILE_NOT_FOUND ((DWORD)0x0000004FL)

//
// MessageId: AQMERR_STARTUP_JOB_FILE_ACCESS_DENIED
//
// MessageText:
//
//  The AQM service does not have access to the startup job file.
//
#define AQMERR_STARTUP_JOB_FILE_ACCESS_DENIED ((DWORD)0x00000050L)

//
// MessageId: AQMERR_STARTUP_JOB_FILE_INVALID
//
// MessageText:
//
//  The startup job file is invalid. 
//
#define AQMERR_STARTUP_JOB_FILE_INVALID  ((DWORD)0x00000051L)

//
// MessageId: AQMERR_STARTUP_JOB_FILE_NETWORK_LOGON_NOT_GRANTED
//
// MessageText:
//
//  The AQM service is not granted network logon access to the system where the startup job file is located.
//
#define AQMERR_STARTUP_JOB_FILE_NETWORK_LOGON_NOT_GRANTED ((DWORD)0x00000052L)

//
// MessageId: AQMERR_STARTUP_JOB_FILE_PATH_NOT_FOUND
//
// MessageText:
//
//  The startup job file path was not found.
//
#define AQMERR_STARTUP_JOB_FILE_PATH_NOT_FOUND ((DWORD)0x00000053L)

//
// MessageId: AQMERR_STARTUP_JOB_FILE_BAD_NET_NAME
//
// MessageText:
//
//  The filename of the startup job file contains a bad or invalid network name.
//
#define AQMERR_STARTUP_JOB_FILE_BAD_NET_NAME ((DWORD)0x00000054L)

//
// MessageId: AQMERR_UNHANDLED_ERROR_CHECKING_STARTUP_JOB_FILE
//
// MessageText:
//
//  The AQM service cannot access the startup job file.  Check the System Event Log on the AQM server computer for details.
//
#define AQMERR_UNHANDLED_ERROR_CHECKING_STARTUP_JOB_FILE ((DWORD)0x00000055L)

//
// MessageId: AQMERR_ERROR_CONNECTING_TO_SERVICE
//
// MessageText:
//
//  Error connecting to AQM service.
//
#define AQMERR_ERROR_CONNECTING_TO_SERVICE ((DWORD)0x00000056L)

//
// MessageId: AQMERR_ERROR_SENDING_WORK_REQUEST
//
// MessageText:
//
//  Error sending work request to AQM service.
//
#define AQMERR_ERROR_SENDING_WORK_REQUEST ((DWORD)0x00000057L)

//
// MessageId: AQMERR_ERROR_READING_REPLY
//
// MessageText:
//
//  Error reading reply from AQM service.
//
#define AQMERR_ERROR_READING_REPLY       ((DWORD)0x00000058L)

//
// MessageId: AQMERR_STRING_TOO_LONG
//
// MessageText:
//
//  A string was too long.
//
#define AQMERR_STRING_TOO_LONG           ((DWORD)0x00000059L)

//
// MessageId: AQMERR_INVALID_PARAMETER
//
// MessageText:
//
//  A parameter was invalid.
//
#define AQMERR_INVALID_PARAMETER         ((DWORD)0x0000005AL)

//
// MessageId: AQMERR_CANNOT_ALLOCATE_MEMORY
//
// MessageText:
//
//  Memory could not be allocated.
//
#define AQMERR_CANNOT_ALLOCATE_MEMORY    ((DWORD)0x0000005BL)

//
// MessageId: AQMERR_VERSION_UNSUPPORTED
//
// MessageText:
//
//  This operation is not supported in this version of AQM.
//
#define AQMERR_VERSION_UNSUPPORTED       ((DWORD)0x0000005CL)

//
// MessageId: AQMERR_RPC_SERVER_TOO_BUSY_TO_CHECK_FILE
//
// MessageText:
//
//  There were too many connections (server sessions) to the workstation for the AQM service to check access to a file.
//
#define AQMERR_RPC_SERVER_TOO_BUSY_TO_CHECK_FILE ((DWORD)0x0000005DL)

//
// MessageId: AQMERR_SERVICE_PIPE_NOT_FOUND
//
// MessageText:
//
//  The AQM service is not running.
//  Start the AQM service from the Control Panel applet "Services".
//
#define AQMERR_SERVICE_PIPE_NOT_FOUND    ((DWORD)0x0000005EL)

//
// MessageId: AQMERR_SERVICE_BUSY
//
// MessageText:
//
//  The AQM service is too busy to accept the work request.
//
#define AQMERR_SERVICE_BUSY              ((DWORD)0x0000005FL)

//
// MessageId: AQMERR_ALTERNATE_ACCOUNT_REQUIRES_PASSWORD
//
// MessageText:
//
//  A job submitted to run under an alternate account (an account other than the submitting user's) requires the password for the alternate account.
//
#define AQMERR_ALTERNATE_ACCOUNT_REQUIRES_PASSWORD ((DWORD)0x00000060L)

//
// MessageId: AQMERR_JOB_ALREADY_PAUSED
//
// MessageText:
//
//  The job is already paused.
//
#define AQMERR_JOB_ALREADY_PAUSED        ((DWORD)0x00000061L)

//
// MessageId: AQMERR_JOB_NOT_PAUSED
//
// MessageText:
//
//  The job is not paused.
//
#define AQMERR_JOB_NOT_PAUSED            ((DWORD)0x00000062L)

//
// MessageId: AQMERR_OPERATION_TIMED_OUT
//
// MessageText:
//
//  The operation timed out.
//
#define AQMERR_OPERATION_TIMED_OUT       ((DWORD)0x00000063L)

//
// MessageId: AQMERR_ERROR_CREATING_OVERLAPPED_EVENT
//
// MessageText:
//
//  Error creating overlapped event structure.
//  Investigate system resource availability.
//
#define AQMERR_ERROR_CREATING_OVERLAPPED_EVENT ((DWORD)0x00000064L)

//
// MessageId: AQMERR_ERROR_WAITING_FOR_OVERLAPPED_EVENT
//
// MessageText:
//
//  Error waiting for asynchronous I/O.
//  A critical I/O did not complete as expected within an acceptable time.
//
#define AQMERR_ERROR_WAITING_FOR_OVERLAPPED_EVENT ((DWORD)0x00000065L)

//
// MessageId: AQMERR_NOT_ALL_DATA_READ
//
// MessageText:
//
//  Not all data was read from the pipe.
//  Make sure AQM is correctly and completely installed.
//
#define AQMERR_NOT_ALL_DATA_READ         ((DWORD)0x00000066L)

//
// MessageId: AQMERR_NOT_ALL_DATA_WRITTEN
//
// MessageText:
//
//  Not all data was written to the pipe.
//  Make sure AQM is correctly and completely installed.
//
#define AQMERR_NOT_ALL_DATA_WRITTEN      ((DWORD)0x00000067L)

//
// MessageId: AQMERR_ERROR_READING_PIPE
//
// MessageText:
//
//  Error reading from the service pipe.
//
#define AQMERR_ERROR_READING_PIPE        ((DWORD)0x00000068L)

//
// MessageId: AQMERR_ERROR_WRITING_PIPE
//
// MessageText:
//
//  Error writing to the service pipe.
//
#define AQMERR_ERROR_WRITING_PIPE        ((DWORD)0x00000069L)

//
// MessageId: AQMERR_ERROR_GETTING_OVERLAPPED_RESULT
//
// MessageText:
//
//  Error waiting for asynchronous I/O.
//  An attempt to wait for an expected I/O failed.
//  Call Argent Software for support.
//
#define AQMERR_ERROR_GETTING_OVERLAPPED_RESULT ((DWORD)0x0000006AL)

//
// MessageId: AQMERR_INVALID_PASSWORD
//
// MessageText:
//
//  Invalid password.
//
#define AQMERR_INVALID_PASSWORD          ((DWORD)0x0000006BL)

//
// MessageId: AQMERR_NETWORK_ACCESS_DENIED
//
// MessageText:
//
//  Network access denied.
//
#define AQMERR_NETWORK_ACCESS_DENIED     ((DWORD)0x0000006CL)

//
// MessageId: AQMERR_GENERAL_NETWORK_ERROR
//
// MessageText:
//
//  General network error.
//
#define AQMERR_GENERAL_NETWORK_ERROR     ((DWORD)0x0000006DL)

//
// MessageId: AQMERR_JOB_FILE_NETWORK_PATH_NOT_FOUND
//
// MessageText:
//
//  The job file network path was not found.
//
#define AQMERR_JOB_FILE_NETWORK_PATH_NOT_FOUND ((DWORD)0x0000006EL)

//
// MessageId: AQMERR_SUCCESS_JOB_NETWORK_PATH_NOT_FOUND
//
// MessageText:
//
//  The success job file network path was not found.
//
#define AQMERR_SUCCESS_JOB_NETWORK_PATH_NOT_FOUND ((DWORD)0x0000006FL)

//
// MessageId: AQMERR_FAILURE_JOB_NETWORK_PATH_NOT_FOUND
//
// MessageText:
//
//  The failure job file network path was not found.
//
#define AQMERR_FAILURE_JOB_NETWORK_PATH_NOT_FOUND ((DWORD)0x00000070L)

//
// MessageId: AQMERR_LICENSE_EXPIRED
//
// MessageText:
//
//  AQM license has expired.  Please contact Argent Software for assistance.
//
#define AQMERR_LICENSE_EXPIRED           ((DWORD)0x00000071L)

//
// MessageId: AQMERR_LICENSE_INVALID
//
// MessageText:
//
//  AQM event %0x197ca0.  Please contact Argent Software for assistance.
//
#define AQMERR_LICENSE_INVALID           ((DWORD)0x00000072L)

