Attribute VB_Name = "EnumFolders"
'****************************************************************
'Windows API/Global Declarations for :Enumerating Folders (advanced)
'****************************************************************

 Public Const MAX_PATH = 260
 
'      'GetDriveType return values
 Public Const DRIVE_REMOVABLE = 2
 Public Const DRIVE_FIXED = 3
 Public Const DRIVE_REMOTE = 4
 Public Const DRIVE_CDROM = 5
 Public Const DRIVE_RAMDISK = 6
 

 Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
 End Type

     

 Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * MAX_PATH
    cAlternate As String * 14
 End Type


 Public Declare Function GetDriveType Lib "kernel32" Alias "GetDriveTypeA" _
     (ByVal nDrive As String) As Long

 Public Declare Function GetLogicalDriveStrings Lib "kernel32" Alias "GetLogicalDriveStringsA" _
     (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long

 Public Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" _
     (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long

 Public Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" _
     (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long

 Public Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
    '      'flags for the user options
     Public displayExpanded As Boolean
     Public displaySorted As Boolean
     Public LoadAll As Boolean
     Public NoOfDrives As Integer
     
     '****************************************************************
' Name: Enumerating Folders (advanced)
' Description: This method provides for the optional loading of folders
'                    for either a single-level or an entire drive, and adds visua
'                    identification to the drives and folders with imagelist icons.
' By: VB Net (Randy Birch)
'
' Inputs:None
' Returns:None
' Assumes:Original recursion routine by Trond Solberg, soltro@Mandatum.no, http://www.mandatum.no. Start
'a new project, and to the form add a command buttons (cmdEnd), a Treeview control (tvwControl),
'an autosizing label (lblMessage), two checkbox controls (chkExpanded and chkSort), and a control
'array of 2 option buttons (optLoadType(0) & optLoadType(1))
' Side Effects:None
'
'****************************************************************

'        Add the following routines to the BAS module.

Public Function TrimNull(startstr$) As String

     Dim pos As Integer
     pos = InStr(startstr$, Chr$(0))
     

     If pos Then
         TrimNull = Left$(startstr$, pos - 1)
         Exit Function
     End If

         'if this far, there was no chr$(0), so return the
        '      string
        TrimNull = startstr$
         
    End Function


Public Sub GetAllDrivesFolders(tvwTree As Control, nodParentNode As Node)

     Dim nodX As Node
     
     Dim WFD As WIN32_FIND_DATA
     Dim hFile As Long
     
     Dim sFile As String
     Dim sPath As String
     Dim i As Integer
     Dim r As Long
     Dim found As Integer
     'assign the fullpath property to the path to sear
    '     ch,
    '      'assuring that the path is qualified.

    If Right$(nodParentNode.FullPath, 1) <> "\" Then
         sPath = nodParentNode.FullPath & "\"
    Else: sPath = nodParentNode.FullPath
    End If

         'strip off the "My Computer" from the FullPath pr
        '     operty.
         'The actual fullpath is "My Computer\C:\", howeve
        '     r,
         'the Findxxx APIs want only the qualified path, i
        '     .e "C:\".
        sPath = Mid$(sPath, 13, Len(sPath))
        '      'find the first file matching the parameter \*.*
        hFile = FindFirstFile(sPath & "*.*" & Chr$(0), WFD)
        '      'reset the counter flag
        found = 0
        ReDim fArray(200)
         

        If hFile <> -1 Then
             sFile = TrimNull(WFD.cFileName)
             WFD.dwFileAttributes = vbDirectory

             While FindNextFile(hFile, WFD)
                 sFile = TrimNull(WFD.cFileName)
                 
                '     'ignore the 2 standard root entries

                 If (sFile <> ".") And (sFile <> "..") Then

                    If (WFD.dwFileAttributes And vbDirectory) Then
                         found = found + 1
                         
                        '      'if found is at 200, then add some more room

                         If found Mod 200 = 0 Then ReDim Preserve fArray(found + 100)
                             fArray(found) = sFile
                        End If

                             
                         End If

                             
                         Wend

                         End If

                             
                             r = FindClose(hFile)
                             'trim down the array to equal the elements found
                            '
                            ReDim Preserve fArray(found)
                             
                            '      'add the folders to the treeview

                            For i = 1 To found
                                 Set nodX = tvwTree.Nodes.Add(nodParentNode.Key, tvwChild, sPath & fArray(i) & "Dir", fArray(i), 8, 9)
                                '     'and get some more

                                 If LoadAll Then GetAllDrivesFolders tvwTree, nodX
                                 Next i

                                     
                                     nodParentNode.Sorted = displaySorted
                                     nodParentNode.Expanded = displayExpanded
                            End Sub


Sub GetNextLevelFolders(tvwTree As Control, nodParentNode As Node)

     
     Dim nodX As Node
     
     Dim WFD As WIN32_FIND_DATA
     Dim hFile As Long
     
     Dim sFile As String
     Dim sPath As String
     Dim i As Integer
     Dim r As Long
     Dim found As Integer
     'assign the fullpath property to the path to sear
    '     ch,
    '      'assuring that the path is qualified.

     If Right$(nodParentNode.FullPath, 1) <> "\" Then
        sPath = nodParentNode.FullPath & "\"
     Else: sPath = nodParentNode.FullPath
     End If

         'strip off the "My Computer" from the FullPath pr
        '     operty.
         'The actual fullpath is "My Computer\C:\", howeve
        '     r,
         'the Findxxx APIs want only the qualified path, i
        '     .e "C:\".
         sPath = Mid$(sPath, 13, Len(sPath))
        '      'find the first file matching the parameter \*.*
         hFile = FindFirstFile(sPath & "*.*" & Chr$(0), WFD)

         If hFile <> -1 Then
             
            sFile = TrimNull(WFD.cFileName)

            While FindNextFile(hFile, WFD)
                 sFile = TrimNull(WFD.cFileName)
                '      'ignore the 2 standard root entries

                 If (sFile <> ".") And (sFile <> "..") Then
                     

                     If (WFD.dwFileAttributes And vbDirectory) Then
                        '      'add the item
'                         Set nodX = tvwTree.Nodes.Add(nodParentNode.Key, tvwChild, sPath & sFile & "Dir", sFile, 8, 9)
                         Set nodX = tvwTree.Nodes.Add(nodParentNode.Key, tvwChild, sPath & sFile & "Dir", sFile)
                     End If

                         
                     End If

                         
                    Wend

                     End If

                         
                         r = FindClose(hFile)
                         
                         nodParentNode.Sorted = displaySorted
                         nodParentNode.Expanded = displayExpanded
                End Sub


