VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form UnzipTo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Unzip Files"
   ClientHeight    =   4530
   ClientLeft      =   45
   ClientTop       =   360
   ClientWidth     =   6540
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4530
   ScaleWidth      =   6540
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox KeepDirectoriesCB 
      Caption         =   "&Preserve directory structure"
      Height          =   330
      Left            =   3615
      TabIndex        =   6
      Top             =   630
      Value           =   1  'Checked
      Width           =   2325
   End
   Begin VB.CheckBox ConfirmOverwriteCB 
      Caption         =   "Co&nfirm before overwrite"
      Height          =   330
      Left            =   3615
      TabIndex        =   5
      Top             =   1395
      Width           =   2055
   End
   Begin VB.CheckBox OverwriteExistingCB 
      Caption         =   "&Overwrite existing files"
      Height          =   330
      Left            =   3630
      TabIndex        =   4
      Top             =   1035
      Width           =   1920
   End
   Begin VB.Frame Frame1 
      Caption         =   "Files"
      Height          =   1440
      Left            =   3480
      TabIndex        =   7
      Top             =   2055
      Width           =   2610
      Begin VB.OptionButton SelectedFilesButton 
         Caption         =   "Extract &selected files"
         Height          =   270
         Index           =   1
         Left            =   225
         TabIndex        =   9
         Top             =   765
         Width           =   1815
      End
      Begin VB.OptionButton AllFilesButton 
         Caption         =   "Extract &all files"
         Height          =   270
         Index           =   0
         Left            =   225
         TabIndex        =   8
         Top             =   390
         Value           =   -1  'True
         Width           =   2085
      End
   End
   Begin VB.CommandButton UnzipOK 
      Caption         =   "&Ok"
      Height          =   555
      Left            =   3525
      TabIndex        =   3
      Top             =   3825
      Width           =   1350
   End
   Begin VB.CommandButton UnzipCancel 
      Caption         =   "&Cancel"
      Height          =   555
      Left            =   5010
      TabIndex        =   2
      Top             =   3825
      Width           =   1350
   End
   Begin ComctlLib.TreeView DriveTree 
      Height          =   3330
      Left            =   150
      TabIndex        =   1
      Top             =   420
      Width           =   2955
      _ExtentX        =   5212
      _ExtentY        =   5874
      _Version        =   327682
      LabelEdit       =   1
      Style           =   7
      Appearance      =   1
   End
   Begin VB.ComboBox DirectoryMRUBox 
      Enabled         =   0   'False
      Height          =   315
      Left            =   165
      TabIndex        =   0
      Text            =   "To be implemented"
      Top             =   3915
      Width           =   2955
   End
   Begin VB.Frame Frame2 
      Caption         =   "Unzip options"
      Height          =   1560
      Left            =   3480
      TabIndex        =   11
      Top             =   300
      Width           =   2580
   End
   Begin VB.Label Label1 
      Caption         =   "Please choose the destination folder:"
      Height          =   255
      Left            =   165
      TabIndex        =   10
      Top             =   105
      Width           =   2700
   End
End
Attribute VB_Name = "UnzipTo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumberOfSelectedFiles As Long

Private Sub UnzipOK_Click()
   Dim SelectedNode As Node
   Dim numf&, numx&, rc As Long, Directory As String, maxitems As Long, x&

   If DriveTree.SelectedItem.Index > 0 Then
       Set SelectedNode = DriveTree.SelectedItem

      ' unzip all files or just the selected ones
      If AllFilesButton(0).Value = True Then
         vbzipnam.s(0) = vbNullString
         numf = 0
      Else
            maxitems = Unzipform.lvwFiles.ListItems.Count
            numf = 0
            For x = 1 To maxitems
               If Unzipform.lvwFiles.ListItems(x).Selected = True Then
                  ' Unzip find routine needs the path (if any) and the file to find it in the directory
                  ' This is because there can be multiple directories with the same filename.
                  vbzipnam.s(numf) = Unzipform.lvwFiles.ListItems(x).SubItems(5) + Unzipform.lvwFiles.ListItems(x).Text
                  numf = numf + 1
               End If
               If x = 99 Then x = maxitems
            Next
      End If
    
    ' Exclude no files from unzip - no dialog box interface to this
     vbxnames.s(0) = vbNullString
     numx = 0
     
     Directory = Mid$(SelectedNode.FullPath, 13)
     If Right$(Directory, Len(Directory)) <> "\" Then Directory = Directory + "\"

       rc = VBUnzip(CurrentZipFile, _
                     0, _
                     Directory, _
                    KeepDirectoriesCB.Value, _
                    ConfirmOverwriteCB.Value, _
                    OverwriteExistingCB.Value, _
                    0, _
                    0, _
                    1, _
                    1, _
                    0, _
                    numf, numx)

      If rc > 0 Then
         MsgBox "Error during unzip rc = " & rc
      End If
   End If
   
   Unload Me
End Sub

Private Sub UnzipCancel_Click()
   Unload Me
End Sub

Private Sub Form_Load()

    ' Initialize the radio button
    NumberOfSelectedFiles = SendMessage(Unzipform.lvwFiles.hWnd, LVM_GETSELECTEDCOUNT, 0, 0)
    
    If NumberOfSelectedFiles > 0 Then
      SelectedFilesButton(1).Value = True
    Else
      SelectedFilesButton(1).Enabled = False
    End If

    'load the drive letters into the treeview
    GetSystemDrives

     'store the initial number of treeview elements for
     'later subtraction when presenting the total number
     'of files loaded (DriveTree_click routine)
    NoOfDrives = DriveTree.Nodes.Count
End Sub

Private Sub GetSystemDrives()

     Dim TreeNode As Node
     Dim r As Long
     Dim allDrives As String, currDrive As String
     Dim drvIcon As Integer
     
  ' add imagelist initialization stuff here - TODO
     
    ' assign the image list to the tree control
    'DriveTree.ImageList = ImageList1
    
    ' add a base "My Computer" to the tree
'     Set TreeNode = DriveTree.Nodes.Add(, , "Root", "My Computer", 1, 1)
     Set TreeNode = DriveTree.Nodes.Add(, , "Root", "My Computer")
     TreeNode.Expanded = True
     TreeNode.Selected = True
    
    ' get the list of all available drives
     allDrives$ = rgbGetAvailableDrives()

     Do Until allDrives$ = Chr$(0)
        'strip off one drive item from the allDrives$
         currDrive$ = StripNulls(allDrives$)
         
        'determine the appropriate imagelist icon to display
         drvIcon = GetDriveDisplayIcon(currDrive$)
         
        'we can't have the trailing slash, so ..
         currDrive$ = Left$(currDrive$, 2)
         
        'Add the drive to the treeview.
'         Set TreeNode = DriveTree.Nodes.Add("Root", tvwChild, currDrive$ & "Dir", currDrive$, drvIcon, drvIcon)
         Set TreeNode = DriveTree.Nodes.Add("Root", tvwChild, currDrive$ & "Dir", currDrive$)
         'TreeNode.Expanded = True
         TreeNode.Expanded = False
     Loop

     'force sorting of the drive letters
     TreeNode.Sorted = True
End Sub

Private Function rgbGetAvailableDrives() As String

    'returns a single string of available drive
    'letters, each separated by a chr$(0)
     Dim r As Long
     Dim tmp As String
     
     tmp$ = Space$(64)
     r& = GetLogicalDriveStrings(Len(tmp$), tmp$)
     
     rgbGetAvailableDrives = Trim$(tmp$)
End Function

Private Function GetDriveDisplayIcon(driveName$) As Integer
    Dim dIcon As Integer
     
    Select _
       Case GetDriveType(driveName$)
       Case 0, 1: dIcon = 1
       Case DRIVE_REMOVABLE:
            Select _
                Case Left$(driveName$, 1)
                Case "a", "b": dIcon = 2
                Case Else: dIcon = 5
            End Select
       Case DRIVE_FIXED: dIcon = 3
       Case DRIVE_REMOTE: dIcon = 6
       Case DRIVE_CDROM: dIcon = 4
       Case DRIVE_RAMDISK: dIcon = 7
    End Select
     
    GetDriveDisplayIcon = dIcon
End Function

Private Function StripNulls(startstr$) As String

     'Take a string separated by a chr$(0), and split off 1 item, and
     'shorten the string so that the next item is ready for removal.
     Dim pos As Integer
     Dim c As Integer
     pos% = InStr(startstr$, Chr$(0))
     

     If pos% Then
         StripNulls$ = Mid$(startstr$, 1, pos% - 1)
         startstr$ = Mid$(startstr$, pos% + 1, Len(startstr$))
         Exit Function
     End If

    End Function

Private Sub DriveTree_Click()

     Dim TreeNode As Node
    'show a wait message for long searches
    'lblMessage = "Searching drive " & DriveTree.SelectedItem & " for folders ... please wait"

    DoEvents
        
    'identify the selected node
    Set TreeNode = DriveTree.SelectedItem

    'verify it's valid
    If (UCase$(Right$(TreeNode.Key, 3)) = "DIR") And (TreeNode.Children = 0) Then
             
            'based on the user options, ...

             If LoadAll Then
                 GetAllDrivesFolders DriveTree, TreeNode
             Else: GetNextLevelFolders DriveTree, TreeNode
             End If

    End If

    'subtract NoOfDrives because "My Computer" and the
    'initial drives loaded should not be counted as a  folder
     'lblMessage = "Total folders displayed : " & DriveTree.Nodes.Count - NoOfDrives
End Sub
