/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The header file for class                        Luebeck               /
/   Bitmap                                           Summer, 1997          \
\			                                                   /
/   (C++)								   \
\                                     Last revision :  12:22 12 Oct 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#ifndef	Bitmap_h
#define	Bitmap_h

class Bitmap
{
   HBITMAP	On;
   HBITMAP	Off;
   HWND		Window;
   int		State;
public :

   Bitmap () { State = 0; }
   void Init
   (
      HINSTANCE	Instance,
      UINT	OnBitMap,
      UINT	OffBitMap
   );
   void SetWindow (HWND	ButtonWindow)
   {
      Window = ButtonWindow;
   }
   void Show ()
   {
      HDC	DC;

      DC = GetWindowDC (Window);
      DrawState
      (  DC,
         0, 0,
         (LPARAM) (State ? On : Off),
         0, 0, 0, 0, 0,
         DST_BITMAP | DSS_NORMAL
      );
      ReleaseDC (Window, DC);
   }
   void Toggle () { State ^= 1; }
   void Set () { State = 1; }
   int  IsChecked () { return State; }

}; // Bitmap

#endif	/*> Bitmap_h <*/
