/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The clipboard functions                          Luebeck               /
/   GetClipboard, PutClipboard                       Winter, 1996          \
\								           /
/   (C++)                                                                  \
\                                     Last revision :  13:13 02 Mar 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include "clipman.h"

int GetClipboard ()
{  // Opening the clipboard
   if (Board.Handle) PutClipboard ();
   if (  TheWindow == GetClipboardOwner ()		// Once again?
      || 0 == IsClipboardFormatAvailable (CF_TEXT)	// Has text?
      )  return 0;
   if (0 == OpenClipboard (TheWindow))
   {
      Error ("Cannot open the clipboard.");
      return 0;
   }
   if (0 == (Board.Handle = GetClipboardData (CF_TEXT)))
   {
      Error ("Cannot get the clipboard data.");
      PutClipboard ();
      return 0;
   }
   if (0 == (Board.Text = (char *) GlobalLock (Board.Handle)))
   {
      Error ("Cannot lock the clipboard data.");
      PutClipboard ();
      return 0;
   }
   return 1;

}  // GetClipboard

void PutClipboard (HGLOBAL New)
{  // Closing the clipboard
  if (0 == New)
  {  // No changes
     if (Board.Handle) GlobalUnlock (Board.Handle);
     Board.Handle = 0;
     Board.Text = 0;
     CloseClipboard ();
     return;
  }
  if (Board.Handle)
  {  // Unlock the old memory block
     GlobalUnlock (Board.Handle);
     Board.Handle = 0;
     Board.Text = 0;
  }
  if (0 == EmptyClipboard ())
  {  // Release the memory
     CloseClipboard ();
     GlobalFree (New);
     Error ("Cannot become the clipboard owner.");
     return;
  }
  if (0 == SetClipboardData (CF_TEXT, New))
  {  // Release the memory
     CloseClipboard ();
     GlobalFree (New);
     Error ("Cannot set the clipboard data.");
     return;
  }
  GlobalUnlock (New);
  if (0 == CloseClipboard ())
  {  // Close now
     Error ("Cannot close the clipboard.");
  }
}  // PutClipboard

