/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   Buffer management                                Luebeck               /
/                                                    Winter, 1994          \
\   (C++)								   /
/                                                                          \
\                                     Last revision :  21:43 20 Jan 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include	<windows.h>

#include	"buffer.h"

HGLOBAL GlobalStr::Export ()
{  // Export the buffer contents to the clipboard
   HGLOBAL	Result = Handle;

   if (0 == Handle)
   {  // What?
      MemError ("An internal error.");
   }
   Handle = 0;
   Total = 0;
   Size = 0;
   return Result;

}  // End of GlobalStr::Export

#define	    FRAME_LENGTH    40

static const char Frame [FRAME_LENGTH] =
		  {  ' ', ' ', ' ', ' ', ' ', 
		     ' ', ' ', ' ', ' ', ' ', 
		     ' ', ' ', ' ', ' ', ' ', 
		     ' ', ' ', ' ', ' ', ' ', 
		     ' ', ' ', ' ', ' ', ' ', 
		     ' ', ' ', ' ', ' ', ' ', 
		     ' ', ' ', ' ', ' ', ' ', 
		     ' ', ' ', ' ', ' ', ' '
                  };

void GlobalStr::Fill (int Length)
{  // Filling the global memory with spaces
   while (Length > 0)
   {  // Something to do
      Put
      (  Frame,
         FRAME_LENGTH > Length ? Length : FRAME_LENGTH
      );
      Length -= FRAME_LENGTH;
   }
}  // GlobalStr::Fill

void GlobalStr::Put (const char * Text, int Length)
{  // Writting onto the global memory block
   while (Length--)
   {  // Copy one more byte of the Text
      if (  0 == (Buffer [Size++] = *Text++)
	 || Size == BlockIncrement
	 )
      {  // The local memory block is full
	 char        *	Address;
	 HGLOBAL	OldHandle = Handle;

	 Total += Size;
	 if (  0
	    == (  Handle
	       =  (  Handle
	          ?  GlobalReAlloc
		     (  Handle,
		        Total,
		        GMEM_MOVEABLE | GMEM_DDESHARE
		     )
		  :  GlobalAlloc
		     (  GMEM_MOVEABLE | GMEM_DDESHARE,
		        Total
	    )  )  )  )
	 {  // Error during memory allocation
            if (OldHandle) GlobalFree (OldHandle);
            Total = 0;
            Size = 0;
	    throw MemError ("Cannot get more dynamic memory.");
	 }
	 if (  0
	    == (  Address
	       =  (char *) GlobalLock (Handle)
	    )  )
	 {  // Cannot lock the memory
            GlobalFree (Handle);
	    Handle = 0;
            Total = 0;
            Size = 0;
	    throw MemError ("Cannot lock the dynamic memory block.");
	 }
	 memcpy (&Address [Total - Size], &Buffer [0], Size);
	 Size = 0;
   }  }
}  // GlobalStr::Put
