/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   Header file for classes                          Luebeck               /
/   LocalStr and GlobalStr			     Winter, 1994          \
\                                                                          /
/   (C++)								   \
\                                     Last revision :  21:43 20 Jan 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#ifndef	Buffer_h
#define	Buffer_h

#define	BlockIncrement	4096

class MemError
{  // The memory allocation errors
public :
   const char * const Text;
   MemError (const char * Message) : Text (Message) {}

}; // End of MemError
/*>

   The  CharArray  class  povides  dynamic  strings.   The   string   is  
   automatically expanded when it is indexed out of the bound.

<*/
class CharArray
{  // Locally allocated string
protected :
   char	     *	Address;	// Address of the memory block
   int		Size;		// Its size

public :
   CharArray () : Address (0), Size (0) {}
  ~CharArray () {if (Address) free (Address);}
   char& operator [] (int Index)
   {  // Accessing the string body
      if (Index >= Size)
      {  // Expanding the string
	 if (  0
	    == (  Address
	       =  (char *) realloc
		  (  Address,
		     Size += BlockIncrement
	    )  )  )
	 {  // No more memory
	    Size = 0;
	    throw MemError ("Cannot get more local memory.");
      }  }
      return (Address [Index]);
   }
}; // End of CharArray
/*>

   The IntArray class povides  dynamic  arrays  of  int.  The  array  is 
   automatically expanded when it is indexed out of the bound.

<*/
class IntArray
{  // Locally allocated string
protected :
   int       *	Address;	// Address of the memory block
   int		Size;		// Its size

public :
   IntArray () : Address (0), Size (0) {}
  ~IntArray () {if (Address) free (Address);}
   int& operator [] (int Index)
   {  // Accessing the string body
      if (Index >= Size)
      {  // Expanding the string
	 if (  0
	    == (  Address
	       =  (int *) realloc
		  (  Address,
		     (  sizeof (int)
		     *  (  Size
		        += BlockIncrement / sizeof (int)
	    )  )  )  )  )
	 {  // No more memory
	    Size = 0;
	    throw MemError ("Cannot get more local memory.");
      }  }
      return (Address [Index]);
   }
}; // End of IntArray
/*>

   The  GlobalStr  class  provides  global  memory  pool.  The  pool  is  
   automatically expanded when user writes something into. Appearance of 
   the  NUL  (ASCII)  flushes  the buffer. The GlobalStr contents can be 
   exported to the clipboard (Export).

<*/
class GlobalStr
{  // The buffer of the system memory
private :
   HGLOBAL	Handle;			    // Of the global memory block
   int		Total;			    // Of the block
   int	  	Size;			    // Used bytes in Buffer
   char		Buffer [BlockIncrement];    // Buffer

public :
   HGLOBAL Export ();
   void Put  (const char * Text, int Length);
   void Fill (int Length);
   GlobalStr () : Handle (0), Total (0), Size (0) {}
  ~GlobalStr () { if (Handle) GlobalFree (Handle); }

}; // End of class GlobalStr

#endif	// Buffer_h
