/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The main Windows application                     Luebeck               /
/                                                    Winter, 1996          \
\   (C++)								   /
/									   \
\                                     Last revision :  12:22 12 Oct 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include	"clipman.h"
#include	"bitmap.h"
#include	"field.h"
#include	"fix.h"
#include	"reg.h"
#include	"taskbar.h"

HWND		TheWindow;
HWND		AClipboardViewer = 0;
UINT		State;
BitMapButtons	Button;
Icons		Icon;
Clipboard	Board = { 0, 0 };

Field	TabEdit (8, 1, 99, TabMessage);
Field	MarginEdit (72, 1, 999, MarginMessage);
Fix	Prefix  [FIX_NUMBER];
Fix	Postfix [FIX_NUMBER];

TaskBarIcon      FirstBarIcon (First_BAR);
TaskBarIcon      SecondBarIcon (Second_BAR);

static HINSTANCE	TheInstance;
//
// ResetButtons -- Change the state of radio buttons
//
//	NewState	- ID of the pressed button
//
static void ResetButtons (UINT NewState)
{
   if (NewState == State) return;
   if (Button.Format.IsChecked () ^ (NewState == Format_BUT))
   {  // Toggle the Format button
      Button.Format.Toggle ();
      Button.Format.Show ();
   }
   if (Button.Off.IsChecked () ^ (NewState == Off_BUT))
   {  // Toggle the Off button
      Button.Off.Toggle ();
      Button.Off.Show ();
   }
   if (Button.Sort.IsChecked () ^ (NewState == Sort_BUT))
   {  // Toggle the Sort button
      Button.Sort.Toggle ();
      Button.Sort.Show ();
   }
   State = NewState;

}  // ResetButtons
//
// ResetText -- Updates the text associated with the main window
//
//	FullName	- Use full/nick name
//
void ResetText (int FullName = 0)
{  // Set main window text
   SetWindowText
   (  TheWindow,
      (  FullName
      ?  MyName
      :  (  State == Format_BUT
         ?  "Formatting"
         :  (  State == Sort_BUT
            ?  "Sorting"
            :  "Inactive"
   )  )  )  );
}  // ResetText
//
// TaskBarState -- Query the task bar state
//
// Returns :
//
//	ID of the pressed button {Format_BUT|Off_BUT|Sort_BUT}
//
UINT TaskBarState ()
{  // Request the taskbar state
   if (  Format_BUT != FirstBarIcon
      && Format_BUT != SecondBarIcon
      )  return Format_BUT;
   if (  Sort_BUT != FirstBarIcon
      && Sort_BUT != SecondBarIcon
      )  return Sort_BUT;
   return Off_BUT;

}  // TaskBarState
//
// OnClipmanTaskBarNotify -- Respond to the notification message
//
//	WParam	- Of the message
//	LParam	- Of the message
//
// This function is called to respond a notification from the task base,
// i.e. when user press a button on the task bar. 
//
void OnClipmanTaskBarNotify (WPARAM WParam, LPARAM LParam)
{  // On taskbar notification
   if (WM_LBUTTONDOWN != (UINT) LParam) return;
   ShowWindow (TheWindow, SW_HIDE);
   switch ((UINT) WParam)
   {  // Which task bar button was pressed?
      case First_BAR :
         ResetButtons (FirstBarIcon);
         FirstBarIcon.Show (TaskBarState ());
         break;
      case Second_BAR :
         ResetButtons (SecondBarIcon);
         SecondBarIcon.Show (TaskBarState ());
         break;
   }
   ResetText ();
   ShowWindow (TheWindow, SW_MINIMIZE);

}  // OnClipmanTaskBarNotify
//
// AboutProc -- Dialog box procedure for the About dialog
//
BOOL CALLBACK AboutProc
(
   HWND		Window,
   UINT		Message,
   WPARAM	WParam,
   LPARAM	LParam
)
{
   switch (Message)
   {
      case WM_CLOSE :		// End the application
	 EndDialog (Window, 0);
         return 1;
      case WM_INITDIALOG :	// Called once before the window is opened
	 PostMessage (Window, WM_SETICON, TRUE,  (LPARAM) Icon.Clipman);
	 PostMessage (Window, WM_SETICON, FALSE, (LPARAM) Icon.Clipman);
	 return 1;
      default :
	 return 0;
   }
}  // AboutProc
//
// DialogProc -- Dialog box procedure for the main panel dialog box
//
BOOL CALLBACK DialogProc
(
   HWND		Window,
   UINT		Message,
   WPARAM	WParam,
   LPARAM	LParam
)
{
   switch (Message)
   {
      case WM_CLOSE :		// End the application
         ChangeClipboardChain (TheWindow, AClipboardViewer);
	 EndDialog (Window, 0);
	 return 1;
      case WM_DRAWCLIPBOARD :	// The clipboard was changed
         switch (State)
         {
            case Format_BUT : // Try to format the clipboard contents
               if (Format ()) return 1;
               break;
            case Sort_BUT :   // Try to sort the clipboard contents
               if (Sort ()) return 1;
               break;
         }
         if (AClipboardViewer)
         {  // Let the message go further
            PostMessage
            (  AClipboardViewer,
               WM_DRAWCLIPBOARD,
               0,
               0
            );
         }
         return 1;
      case WM_CHANGECBCHAIN :	// The viewer list was changed
         if ((HWND) WParam == AClipboardViewer)
         {  // The previous clipboard viewer is being removed
            AClipboardViewer = (HWND) LParam;
         }
         if (AClipboardViewer)
         {  // Here is the next viewer in the list
            PostMessage
            (  AClipboardViewer,
               WM_CHANGECBCHAIN,
               WParam,
               LParam
            );
         }
         return 1;
      case WM_DRAWITEM :	// Redraw some items
	 if (WParam)
         {
            if (  ODT_BUTTON == ((DRAWITEMSTRUCT *) LParam)->CtlType
               && ODA_DRAWENTIRE == ((DRAWITEMSTRUCT *) LParam)->itemAction
               )
	    {  // Redraw the buttons
	       switch (((DRAWITEMSTRUCT *) LParam)->CtlID)
	       {
	          case Off_BUT :
		     Button.Off.Show ();
	             break;
	          case Format_BUT :
		     Button.Format.Show ();
	             break;
	          case Sort_BUT :
		     Button.Sort.Show ();
	             break;
         }  }  }
	 return 1;
      case WM_INITDIALOG :	// Called once before the window is opened
      {
	 Registry	Data;
	 char		Text [MAX_FIX_LENGTH];
	 HMENU		Menu;

	 TheWindow = Window;

	 Menu = GetSystemMenu (TheWindow, FALSE);
	 DeleteMenu (Menu, 4, MF_BYPOSITION);
	 DeleteMenu (Menu, 2, MF_BYPOSITION);
         AppendMenu (Menu, MF_SEPARATOR, 0, 0);
         AppendMenu (Menu, MF_STRING, IDM_OFF, "Do not touch");
         AppendMenu (Menu, MF_STRING, IDM_FORMAT, "Format");
         AppendMenu (Menu, MF_STRING, IDM_SORT, "Sort");
         AppendMenu (Menu, MF_SEPARATOR, 0, 0);
         AppendMenu (Menu, MF_STRING, IDM_ABOUTBOX, "About ...");

	 Button.Format.SetWindow (GetDlgItem (Window, Format_BUT));
	 Button.Sort.SetWindow (GetDlgItem (Window, Sort_BUT));
	 Button.Off.SetWindow (GetDlgItem (Window, Off_BUT));
         switch (State = Data.GetInt ("State", Off_BUT))
         {  // Restore state from registry file if possible
            case Format_BUT :
	       Button.Format.Set ();
	       break;
            case Off_BUT :
	       Button.Off.Set ();
	       break;
            case Sort_BUT :
	       Button.Sort.Set ();
	       break;
            default :
	       Button.Off.Set ();
               State = Off_BUT;
         }	 
	 TabEdit.OnInit
         (  GetDlgItem (Window, Tab_ID),
            Data.GetInt ("Tab", TabEdit)
         );
	 MarginEdit.OnInit
         (  GetDlgItem (Window, Margin_ID),
            Data.GetInt ("Margin", MarginEdit)
         );
         Data.GetString ("Prefix1", Text, MAX_FIX_LENGTH);
	 Prefix [0].OnInit (GetDlgItem (Window, Pref1_ID), Text);
         Data.GetString ("Prefix2", Text, MAX_FIX_LENGTH);
	 Prefix [1].OnInit (GetDlgItem (Window, Pref2_ID), Text);
         Data.GetString ("Prefix3", Text, MAX_FIX_LENGTH);
	 Prefix [2].OnInit (GetDlgItem (Window, Pref3_ID), Text);
         Data.GetString ("Prefix4", Text, MAX_FIX_LENGTH);
	 Prefix [3].OnInit (GetDlgItem (Window, Pref4_ID), Text);

         Data.GetString ("Postfix1", Text, MAX_FIX_LENGTH);
	 Postfix [0].OnInit (GetDlgItem (Window, Suff1_ID), Text);
         Data.GetString ("Postfix2", Text, MAX_FIX_LENGTH);
	 Postfix [1].OnInit (GetDlgItem (Window, Suff2_ID), Text);
         Data.GetString ("Postfix3", Text, MAX_FIX_LENGTH);
	 Postfix [2].OnInit (GetDlgItem (Window, Suff3_ID), Text);
         Data.GetString ("Postfix4", Text, MAX_FIX_LENGTH);
	 Postfix [3].OnInit (GetDlgItem (Window, Suff4_ID), Text);

	 PostMessage (Window, WM_SETICON, TRUE,  (LPARAM) Icon.Clipman);
	 PostMessage (Window, WM_SETICON, FALSE, (LPARAM) Icon.Clipman);

         AClipboardViewer = SetClipboardViewer (TheWindow);

	 ShowWindow (Window, SW_SHOWMINIMIZED);
	 return 1;
      }
      case WM_COMMAND :		// A message
	 switch (HIWORD (WParam))
         {  // The event
            case BN_CLICKED :	// A button click
	       switch (LOWORD (WParam))
               {  // Which button
		  case About_BUT :	// About button
                     DialogBox
                     (  TheInstance,
	                MAKEINTRESOURCE (About_ID),
	                0,
                        (DLGPROC) &AboutProc
                     );
		     break;
	          case Format_BUT :	// Format button
	             ResetButtons (Format_BUT);
	             break;
	          case Off_BUT :	// Off button
	             ResetButtons (Off_BUT);
	             break;
	          case Save_BUT :	// Save button
	          {  // Save the current state
	             Registry	Data;

	             Data.PutInt ("State", State);
	             Data.PutInt ("Tab", TabEdit.Check ());
	             Data.PutInt ("Margin", MarginEdit.Check ());

	             Data.PutString ("Prefix1", Prefix [0].Text);
	             Data.PutString ("Prefix2", Prefix [1].Text);
	             Data.PutString ("Prefix3", Prefix [2].Text);
	             Data.PutString ("Prefix4", Prefix [3].Text);

	             Data.PutString ("Postfix1", Postfix [0].Text);
	             Data.PutString ("Postfix2", Postfix [1].Text);
	             Data.PutString ("Postfix3", Postfix [2].Text);
	             Data.PutString ("Postfix4", Postfix [3].Text);
	             break;
                  }
	          case Sort_BUT :	// Sort button
	             ResetButtons (Sort_BUT);
	             break;
               }
	       break;
            case EN_CHANGE :	// Edit control is up to change
	       switch (LOWORD (WParam))
               {  // Which control
		  case Tab_ID    : TabEdit.Check ();	break;
		  case Margin_ID : MarginEdit.Check ();	break;
		  case Pref1_ID  : Prefix [0].Set ();	break;
		  case Pref2_ID  : Prefix [1].Set ();	break;
		  case Pref3_ID  : Prefix [2].Set ();	break;
		  case Pref4_ID  : Prefix [3].Set ();	break;
		  case Suff1_ID  : Postfix [0].Set ();	break;
		  case Suff2_ID  : Postfix [1].Set ();	break;
		  case Suff3_ID  : Postfix [2].Set ();	break;
		  case Suff4_ID  : Postfix [3].Set ();	break;
	       }
	       break;
         }
	 return 1;
      case WM_SIZE :
	 switch (WParam)
	 {
            case SIZE_MINIMIZED :
               if (State == Off_BUT)
               {  // Show `Format' and `Sort'
                  FirstBarIcon.Show  (Format_BUT);
                  SecondBarIcon.Show (Sort_BUT);
               }
               else
               {  // Show `Off' and either `Format' or `Sort'
                  FirstBarIcon.Show  (Off_BUT);
                  SecondBarIcon.Show
                  (  State == Sort_BUT
                  ?  Format_BUT
		  :  Sort_BUT
		  );
               }
               ResetText ();
               break;
            case SIZE_RESTORED :
               FirstBarIcon.Hide ();
               SecondBarIcon.Hide ();
               ResetText (1);
               break;
         }
	 return 1;
      case WM_SYSCOMMAND :	// A message (via menu)
      {
	 UINT	But;

         switch (WParam & 0xFFF0)
         {  // Which command
            case IDM_ABOUTBOX :
               DialogBox
               (  TheInstance,
	          MAKEINTRESOURCE (About_ID),
	          0,
                  (DLGPROC) &AboutProc
               );
	       return 1;
            case IDM_OFF :
               But = Off_BUT;
               break;
            case IDM_FORMAT :
               But = Format_BUT;
               break;
            case IDM_SORT :
               But = Sort_BUT;
               break;
	    default :
	       return 0;
         }
         if (IsIconic (TheWindow))
         {  // Reset taskbar buttons
            if (But == FirstBarIcon)
               OnClipmanTaskBarNotify
               (  (WPARAM) FirstBarIcon.GetID (),
                  (LPARAM) WM_LBUTTONDOWN
               );
            if (But == SecondBarIcon)
               OnClipmanTaskBarNotify
               (  (WPARAM) SecondBarIcon.GetID (),
                  (LPARAM) WM_LBUTTONDOWN
               );
            ResetText ();
         }
         else
         {  // Reset main panel buttons
            ResetButtons (But);
            ResetText (1);
         }
	 return 1;
      }
      case WM_TASK_BAR_NOTIFY :
	 OnClipmanTaskBarNotify (WParam, LParam);
	 return 1;
      default :
	 return 0;
   }
}  // DialogProc

int WINAPI WinMain
(
   HINSTANCE	ThisInstance,
   HINSTANCE	PrevInstance,
   LPSTR	CommandLine,
   int		ShowCommand
)
{
   Icon.Clipman = LoadIcon (ThisInstance, MAKEINTRESOURCE (Clipman_ICON));
   Icon.Format = LoadIcon (ThisInstance, MAKEINTRESOURCE (Format_ICON));
   Icon.Off = LoadIcon (ThisInstance, MAKEINTRESOURCE (Off_ICON));
   Icon.Sort = LoadIcon (ThisInstance, MAKEINTRESOURCE (Sort_ICON));

   Button.Format.Init (ThisInstance, Format_on_BIT, Format_off_BIT);
   Button.Sort.Init (ThisInstance, Sort_on_BIT, Sort_off_BIT);
   Button.Off.Init (ThisInstance, Off_on_BIT, Off_off_BIT);

   TheInstance = ThisInstance;
   if ( -1
      == DialogBox
         (  ThisInstance,
	    MAKEINTRESOURCE (Dialog_ID),
	    0,
            (DLGPROC) &DialogProc
      )  )
   {  // Cannot open the window
      Error ("Cannot create the main window.");
   }
   return 0;

}  // WinMain

void Error (const char * Message)
{  // Drop an error message box
   MessageBox
   (  0,
      Message,
      MyName,
      MB_OK | MB_SYSTEMMODAL | MB_ICONEXCLAMATION
   );
}  // Error
