/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The header file for class                        Luebeck               /
/   Clipman                                          Winter, 1996          \
\			                                                   /
/   (C++ & Microsoft Foundation Classes)			           \
\                                     Last revision :  12:22 12 Oct 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#ifndef	Clipman_h
#define	Clipman_h

#include	<windows.h>

#define	    MyName	    "Clipboard Manager"
#define	    NickName	    "Clipman"
#define	    StateEntry	    "State"
#define	    TabEntry	    "TabSize"
#define	    MarginEntry	    "RightMargin"

#define	    TabMessage	    "The tabulation size was incorrectly "	\
			    "set. The size should be a number in "	\
			    "the range 1..99. The actual "		\
			    "tabulation size is not changed."
#define	    MarginMessage   "The right margin position for "		\
			    "text formatting was incorrectly set. "	\
			    "The position should be a number "		\
			    "in the range 1..999. The actual "		\
			    "position is not changed."
#define	    PatternMessage  "The left margin position of the "		\
			    "text in the clipboard should be "		\
			    "less than the right margin position "	\
			    "of formatting to provide at least "	\
			    "one character wide column. Notice "	\
			    "that a place is necessary for prefixes "	\
			    "and suffixes when they are used "		\
			    "clipboard contents is not changed."

#include "resource.h"		// Main symbols

void Error (const char * Message);

#include	"field.h"
#include	"fix.h"
#include	"bitmap.h"

typedef struct
{
   Bitmap	Format;
   Bitmap	Off;
   Bitmap	Sort;
}  BitMapButtons;

typedef struct
{
   HICON	Clipman;
   HICON	Format;
   HICON	Off;
   HICON	Sort;
}  Icons;

typedef struct
{
   char		 *  Text;		// The clipboard contents
   HGLOBAL	    Handle;		// Of the clipboard memory block
}  Clipboard;

extern HWND	TheWindow;		// The main window
extern HWND	AClipboardViewer;	// The next viewer in the chain
extern UINT	State;			// The actual button state

extern Field	TabEdit;
extern Field	MarginEdit;
extern Fix	Prefix  [FIX_NUMBER];
extern Fix	Postfix [FIX_NUMBER];

extern BitMapButtons	Button;
extern Icons		Icon;

extern Clipboard	Board;

int Format ();
int Sort ();
int GetClipboard ();
void PutClipboard (HGLOBAL New = 0);

#endif	/*> Clipman_h <*/
